<?php

namespace Signicat\DocumentServiceV3_API\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get-request-history-response StructType
 * @subpackage Structs
 */
class Get_request_history_response extends AbstractStructBase
{
    /**
     * The event
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Signicat\DocumentServiceV3_API\StructType\Event[]
     */
    public $event;
    /**
     * Constructor method for get-request-history-response
     * @uses Get_request_history_response::setEvent()
     * @param \Signicat\DocumentServiceV3_API\StructType\Event[] $event
     */
    public function __construct(array $event = array())
    {
        $this
            ->setEvent($event);
    }
    /**
     * Get event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Signicat\DocumentServiceV3_API\StructType\Event[]|null
     */
    public function getEvent()
    {
        return isset($this->event) ? $this->event : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEvent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventForArrayConstraintsFromSetEvent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $get_request_history_responseEventItem) {
            // validation for constraint: itemType
            if (!$get_request_history_responseEventItem instanceof \Signicat\DocumentServiceV3_API\StructType\Event) {
                $invalidValues[] = is_object($get_request_history_responseEventItem) ? get_class($get_request_history_responseEventItem) : sprintf('%s(%s)', gettype($get_request_history_responseEventItem), var_export($get_request_history_responseEventItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The event property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Event, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Event[] $event
     * @return \Signicat\DocumentServiceV3_API\StructType\Get_request_history_response
     */
    public function setEvent(array $event = array())
    {
        // validation for constraint: array
        if ('' !== ($eventArrayErrorMessage = self::validateEventForArrayConstraintsFromSetEvent($event))) {
            throw new \InvalidArgumentException($eventArrayErrorMessage, __LINE__);
        }
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->event);
        } else {
            $this->event = $event;
        }
        return $this;
    }
    /**
     * Add item to event value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Event $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Get_request_history_response
     */
    public function addToEvent(\Signicat\DocumentServiceV3_API\StructType\Event $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Event) {
            throw new \InvalidArgumentException(sprintf('The event property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Event, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->event[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Signicat\DocumentServiceV3_API\StructType\Get_request_history_response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
