<?php

namespace Signicat\DocumentServiceV3_API\EnumType;

/**
 * This class stands for lookup-provider EnumType
 * @subpackage Enumerations
 */
class Lookup_provider
{
    /**
     * Constant for value 'bisnode-norway'
     * @return string 'bisnode-norway'
     */
    const VALUE_BISNODE_NORWAY = 'bisnode-norway';
    /**
     * Constant for value 'bisnode-finland'
     * @return string 'bisnode-finland'
     */
    const VALUE_BISNODE_FINLAND = 'bisnode-finland';
    /**
     * Constant for value 'bolagsverket-sweden'
     * @return string 'bolagsverket-sweden'
     */
    const VALUE_BOLAGSVERKET_SWEDEN = 'bolagsverket-sweden';
    /**
     * Constant for value 'virk-denmark'
     * @return string 'virk-denmark'
     */
    const VALUE_VIRK_DENMARK = 'virk-denmark';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BISNODE_NORWAY
     * @uses self::VALUE_BISNODE_FINLAND
     * @uses self::VALUE_BOLAGSVERKET_SWEDEN
     * @uses self::VALUE_VIRK_DENMARK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BISNODE_NORWAY,
            self::VALUE_BISNODE_FINLAND,
            self::VALUE_BOLAGSVERKET_SWEDEN,
            self::VALUE_VIRK_DENMARK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
