<?php

namespace Signicat\DocumentServiceV3_API\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for request StructType
 * @subpackage Structs
 */
class Request extends AbstractStructBase
{
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profile;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Signicat\DocumentServiceV3_API\StructType\Subject[]
     */
    public $subject;
    /**
     * The document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Signicat\DocumentServiceV3_API\StructType\Document[]
     */
    public $document;
    /**
     * The task
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Signicat\DocumentServiceV3_API\StructType\Task[]
     */
    public $task;
    /**
     * The client_reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $client_reference;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Signicat\DocumentServiceV3_API\StructType\Sender
     */
    public $sender;
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Signicat\DocumentServiceV3_API\StructType\Notification[]
     */
    public $notification;
    /**
     * The days_until_deletion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $days_until_deletion;
    /**
     * The sdo_format
     * Meta informations extracted from the WSDL
     * - default: native
     * - minOccurs: 0
     * @var string
     */
    public $sdo_format;
    /**
     * The account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $account;
    /**
     * The packaging_task
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Signicat\DocumentServiceV3_API\StructType\Packaging_task[]
     */
    public $packaging_task;
    /**
     * The lookup_task
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Signicat\DocumentServiceV3_API\StructType\Lookup_task[]
     */
    public $lookup_task;
    /**
     * Constructor method for request
     * @uses Request::setProfile()
     * @uses Request::setLanguage()
     * @uses Request::setSubject()
     * @uses Request::setDocument()
     * @uses Request::setTask()
     * @uses Request::setClient_reference()
     * @uses Request::setSender()
     * @uses Request::setNotification()
     * @uses Request::setDays_until_deletion()
     * @uses Request::setSdo_format()
     * @uses Request::setAccount()
     * @uses Request::setPackaging_task()
     * @uses Request::setLookup_task()
     * @param string $profile
     * @param string $language
     * @param \Signicat\DocumentServiceV3_API\StructType\Subject[] $subject
     * @param \Signicat\DocumentServiceV3_API\StructType\Document[] $document
     * @param \Signicat\DocumentServiceV3_API\StructType\Task[] $task
     * @param string $client_reference
     * @param \Signicat\DocumentServiceV3_API\StructType\Sender $sender
     * @param \Signicat\DocumentServiceV3_API\StructType\Notification[] $notification
     * @param int $days_until_deletion
     * @param string $sdo_format
     * @param string $account
     * @param \Signicat\DocumentServiceV3_API\StructType\Packaging_task[] $packaging_task
     * @param \Signicat\DocumentServiceV3_API\StructType\Lookup_task[] $lookup_task
     */
    public function __construct($profile = null, $language = null, array $subject = array(), array $document = array(), array $task = array(), $client_reference = null, \Signicat\DocumentServiceV3_API\StructType\Sender $sender = null, array $notification = array(), $days_until_deletion = null, $sdo_format = 'native', $account = null, array $packaging_task = array(), array $lookup_task = array())
    {
        $this
            ->setProfile($profile)
            ->setLanguage($language)
            ->setSubject($subject)
            ->setDocument($document)
            ->setTask($task)
            ->setClient_reference($client_reference)
            ->setSender($sender)
            ->setNotification($notification)
            ->setDays_until_deletion($days_until_deletion)
            ->setSdo_format($sdo_format)
            ->setAccount($account)
            ->setPackaging_task($packaging_task)
            ->setLookup_task($lookup_task);
    }
    /**
     * Get profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profile, true), gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Signicat\DocumentServiceV3_API\StructType\Subject[]|null
     */
    public function getSubject()
    {
        return isset($this->subject) ? $this->subject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubjectForArrayConstraintsFromSetSubject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestSubjectItem) {
            // validation for constraint: itemType
            if (!$requestSubjectItem instanceof \Signicat\DocumentServiceV3_API\StructType\Subject) {
                $invalidValues[] = is_object($requestSubjectItem) ? get_class($requestSubjectItem) : sprintf('%s(%s)', gettype($requestSubjectItem), var_export($requestSubjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subject property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Subject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Subject[] $subject
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setSubject(array $subject = array())
    {
        // validation for constraint: array
        if ('' !== ($subjectArrayErrorMessage = self::validateSubjectForArrayConstraintsFromSetSubject($subject))) {
            throw new \InvalidArgumentException($subjectArrayErrorMessage, __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->subject);
        } else {
            $this->subject = $subject;
        }
        return $this;
    }
    /**
     * Add item to subject value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Subject $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToSubject(\Signicat\DocumentServiceV3_API\StructType\Subject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Subject) {
            throw new \InvalidArgumentException(sprintf('The subject property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Subject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subject[] = $item;
        return $this;
    }
    /**
     * Get document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Signicat\DocumentServiceV3_API\StructType\Document[]|null
     */
    public function getDocument()
    {
        return isset($this->document) ? $this->document : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDocumentItem) {
            // validation for constraint: itemType
            if (!$requestDocumentItem instanceof \Signicat\DocumentServiceV3_API\StructType\Document) {
                $invalidValues[] = is_object($requestDocumentItem) ? get_class($requestDocumentItem) : sprintf('%s(%s)', gettype($requestDocumentItem), var_export($requestDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The document property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Document[] $document
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->document);
        } else {
            $this->document = $document;
        }
        return $this;
    }
    /**
     * Add item to document value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Document $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToDocument(\Signicat\DocumentServiceV3_API\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The document property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->document[] = $item;
        return $this;
    }
    /**
     * Get task value
     * @return \Signicat\DocumentServiceV3_API\StructType\Task[]|null
     */
    public function getTask()
    {
        return $this->task;
    }
    /**
     * This method is responsible for validating the values passed to the setTask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskForArrayConstraintsFromSetTask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestTaskItem) {
            // validation for constraint: itemType
            if (!$requestTaskItem instanceof \Signicat\DocumentServiceV3_API\StructType\Task) {
                $invalidValues[] = is_object($requestTaskItem) ? get_class($requestTaskItem) : sprintf('%s(%s)', gettype($requestTaskItem), var_export($requestTaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Task, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Task[] $task
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setTask(array $task = array())
    {
        // validation for constraint: array
        if ('' !== ($taskArrayErrorMessage = self::validateTaskForArrayConstraintsFromSetTask($task))) {
            throw new \InvalidArgumentException($taskArrayErrorMessage, __LINE__);
        }
        $this->task = $task;
        return $this;
    }
    /**
     * Add item to task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Task $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToTask(\Signicat\DocumentServiceV3_API\StructType\Task $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Task) {
            throw new \InvalidArgumentException(sprintf('The task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Task, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->task[] = $item;
        return $this;
    }
    /**
     * Get client_reference value
     * @return string|null
     */
    public function getClient_reference()
    {
        return $this->{'client-reference'};
    }
    /**
     * Set client_reference value
     * @param string $client_reference
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setClient_reference($client_reference = null)
    {
        // validation for constraint: string
        if (!is_null($client_reference) && !is_string($client_reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client_reference, true), gettype($client_reference)), __LINE__);
        }
        $this->client_reference = $this->{'client-reference'} = $client_reference;
        return $this;
    }
    /**
     * Get sender value
     * @return \Signicat\DocumentServiceV3_API\StructType\Sender|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \Signicat\DocumentServiceV3_API\StructType\Sender $sender
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setSender(\Signicat\DocumentServiceV3_API\StructType\Sender $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Signicat\DocumentServiceV3_API\StructType\Notification[]|null
     */
    public function getNotification()
    {
        return isset($this->notification) ? $this->notification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestNotificationItem) {
            // validation for constraint: itemType
            if (!$requestNotificationItem instanceof \Signicat\DocumentServiceV3_API\StructType\Notification) {
                $invalidValues[] = is_object($requestNotificationItem) ? get_class($requestNotificationItem) : sprintf('%s(%s)', gettype($requestNotificationItem), var_export($requestNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The notification property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Notification[] $notification
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->notification);
        } else {
            $this->notification = $notification;
        }
        return $this;
    }
    /**
     * Add item to notification value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Notification $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToNotification(\Signicat\DocumentServiceV3_API\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The notification property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->notification[] = $item;
        return $this;
    }
    /**
     * Get days_until_deletion value
     * @return int|null
     */
    public function getDays_until_deletion()
    {
        return $this->{'days-until-deletion'};
    }
    /**
     * Set days_until_deletion value
     * @param int $days_until_deletion
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setDays_until_deletion($days_until_deletion = null)
    {
        // validation for constraint: int
        if (!is_null($days_until_deletion) && !(is_int($days_until_deletion) || ctype_digit($days_until_deletion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days_until_deletion, true), gettype($days_until_deletion)), __LINE__);
        }
        $this->days_until_deletion = $this->{'days-until-deletion'} = $days_until_deletion;
        return $this;
    }
    /**
     * Get sdo_format value
     * @return string|null
     */
    public function getSdo_format()
    {
        return $this->{'sdo-format'};
    }
    /**
     * Set sdo_format value
     * @param string $sdo_format
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setSdo_format($sdo_format = 'native')
    {
        // validation for constraint: string
        if (!is_null($sdo_format) && !is_string($sdo_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sdo_format, true), gettype($sdo_format)), __LINE__);
        }
        $this->sdo_format = $this->{'sdo-format'} = $sdo_format;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Get packaging_task value
     * @return \Signicat\DocumentServiceV3_API\StructType\Packaging_task[]|null
     */
    public function getPackaging_task()
    {
        return $this->{'packaging-task'};
    }
    /**
     * This method is responsible for validating the values passed to the setPackaging_task method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackaging_task method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackaging_taskForArrayConstraintsFromSetPackaging_task(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestPackaging_taskItem) {
            // validation for constraint: itemType
            if (!$requestPackaging_taskItem instanceof \Signicat\DocumentServiceV3_API\StructType\Packaging_task) {
                $invalidValues[] = is_object($requestPackaging_taskItem) ? get_class($requestPackaging_taskItem) : sprintf('%s(%s)', gettype($requestPackaging_taskItem), var_export($requestPackaging_taskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packaging_task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Packaging_task, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packaging_task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Packaging_task[] $packaging_task
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setPackaging_task(array $packaging_task = array())
    {
        // validation for constraint: array
        if ('' !== ($packaging_taskArrayErrorMessage = self::validatePackaging_taskForArrayConstraintsFromSetPackaging_task($packaging_task))) {
            throw new \InvalidArgumentException($packaging_taskArrayErrorMessage, __LINE__);
        }
        $this->packaging_task = $this->{'packaging-task'} = $packaging_task;
        return $this;
    }
    /**
     * Add item to packaging_task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Packaging_task $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToPackaging_task(\Signicat\DocumentServiceV3_API\StructType\Packaging_task $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Packaging_task) {
            throw new \InvalidArgumentException(sprintf('The packaging_task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Packaging_task, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packaging_task[] = $this->{'packaging-task'}[] = $item;
        return $this;
    }
    /**
     * Get lookup_task value
     * @return \Signicat\DocumentServiceV3_API\StructType\Lookup_task[]|null
     */
    public function getLookup_task()
    {
        return $this->{'lookup-task'};
    }
    /**
     * This method is responsible for validating the values passed to the setLookup_task method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLookup_task method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLookup_taskForArrayConstraintsFromSetLookup_task(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestLookup_taskItem) {
            // validation for constraint: itemType
            if (!$requestLookup_taskItem instanceof \Signicat\DocumentServiceV3_API\StructType\Lookup_task) {
                $invalidValues[] = is_object($requestLookup_taskItem) ? get_class($requestLookup_taskItem) : sprintf('%s(%s)', gettype($requestLookup_taskItem), var_export($requestLookup_taskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lookup_task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Lookup_task, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lookup_task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Lookup_task[] $lookup_task
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function setLookup_task(array $lookup_task = array())
    {
        // validation for constraint: array
        if ('' !== ($lookup_taskArrayErrorMessage = self::validateLookup_taskForArrayConstraintsFromSetLookup_task($lookup_task))) {
            throw new \InvalidArgumentException($lookup_taskArrayErrorMessage, __LINE__);
        }
        $this->lookup_task = $this->{'lookup-task'} = $lookup_task;
        return $this;
    }
    /**
     * Add item to lookup_task value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Lookup_task $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public function addToLookup_task(\Signicat\DocumentServiceV3_API\StructType\Lookup_task $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Lookup_task) {
            throw new \InvalidArgumentException(sprintf('The lookup_task property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Lookup_task, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lookup_task[] = $this->{'lookup-task'}[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Signicat\DocumentServiceV3_API\StructType\Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
