<?php

namespace Signicat\DocumentServiceV3_API\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authentication-based-signature StructType
 * @subpackage Structs
 */
class Authentication_based_signature extends AbstractStructBase
{
    /**
     * The dialog
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Signicat\DocumentServiceV3_API\StructType\Dialog
     */
    public $dialog;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Signicat\DocumentServiceV3_API\StructType\Method[]
     */
    public $method;
    /**
     * The if_authentication
     * @var string
     */
    public $if_authentication;
    /**
     * Constructor method for authentication-based-signature
     * @uses Authentication_based_signature::setDialog()
     * @uses Authentication_based_signature::setMethod()
     * @uses Authentication_based_signature::setIf_authentication()
     * @param \Signicat\DocumentServiceV3_API\StructType\Dialog $dialog
     * @param \Signicat\DocumentServiceV3_API\StructType\Method[] $method
     * @param string $if_authentication
     */
    public function __construct(\Signicat\DocumentServiceV3_API\StructType\Dialog $dialog = null, array $method = array(), $if_authentication = null)
    {
        $this
            ->setDialog($dialog)
            ->setMethod($method)
            ->setIf_authentication($if_authentication);
    }
    /**
     * Get dialog value
     * @return \Signicat\DocumentServiceV3_API\StructType\Dialog|null
     */
    public function getDialog()
    {
        return $this->dialog;
    }
    /**
     * Set dialog value
     * @param \Signicat\DocumentServiceV3_API\StructType\Dialog $dialog
     * @return \Signicat\DocumentServiceV3_API\StructType\Authentication_based_signature
     */
    public function setDialog(\Signicat\DocumentServiceV3_API\StructType\Dialog $dialog = null)
    {
        $this->dialog = $dialog;
        return $this;
    }
    /**
     * Get method value
     * @return \Signicat\DocumentServiceV3_API\StructType\Method[]|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * This method is responsible for validating the values passed to the setMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodForArrayConstraintsFromSetMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authentication_based_signatureMethodItem) {
            // validation for constraint: itemType
            if (!$authentication_based_signatureMethodItem instanceof \Signicat\DocumentServiceV3_API\StructType\Method) {
                $invalidValues[] = is_object($authentication_based_signatureMethodItem) ? get_class($authentication_based_signatureMethodItem) : sprintf('%s(%s)', gettype($authentication_based_signatureMethodItem), var_export($authentication_based_signatureMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The method property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Method, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set method value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Method[] $method
     * @return \Signicat\DocumentServiceV3_API\StructType\Authentication_based_signature
     */
    public function setMethod(array $method = array())
    {
        // validation for constraint: array
        if ('' !== ($methodArrayErrorMessage = self::validateMethodForArrayConstraintsFromSetMethod($method))) {
            throw new \InvalidArgumentException($methodArrayErrorMessage, __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Add item to method value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Method $item
     * @return \Signicat\DocumentServiceV3_API\StructType\Authentication_based_signature
     */
    public function addToMethod(\Signicat\DocumentServiceV3_API\StructType\Method $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Method) {
            throw new \InvalidArgumentException(sprintf('The method property can only contain items of type \Signicat\DocumentServiceV3_API\StructType\Method, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->method[] = $item;
        return $this;
    }
    /**
     * Get if_authentication value
     * @return string|null
     */
    public function getIf_authentication()
    {
        return $this->{'if-authentication'};
    }
    /**
     * Set if_authentication value
     * @param string $if_authentication
     * @return \Signicat\DocumentServiceV3_API\StructType\Authentication_based_signature
     */
    public function setIf_authentication($if_authentication = null)
    {
        // validation for constraint: string
        if (!is_null($if_authentication) && !is_string($if_authentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($if_authentication, true), gettype($if_authentication)), __LINE__);
        }
        $this->if_authentication = $this->{'if-authentication'} = $if_authentication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Signicat\DocumentServiceV3_API\StructType\Authentication_based_signature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
