<?php

namespace Signicat\DocumentServiceV3_API\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for task-status-info StructType
 * @subpackage Structs
 */
class Task_status_info extends AbstractStructBase
{
    /**
     * The request_id
     * @var string
     */
    public $request_id;
    /**
     * The task_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $task_id;
    /**
     * The task_status
     * @var string
     */
    public $task_status;
    /**
     * The client_reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $client_reference;
    /**
     * The client_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $client_status;
    /**
     * The document_status
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Signicat\DocumentServiceV3_API\StructType\Document_status[]
     */
    public $document_status;
    /**
     * Constructor method for task-status-info
     * @uses Task_status_info::setRequest_id()
     * @uses Task_status_info::setTask_id()
     * @uses Task_status_info::setTask_status()
     * @uses Task_status_info::setClient_reference()
     * @uses Task_status_info::setClient_status()
     * @uses Task_status_info::setDocument_status()
     * @param string $request_id
     * @param string $task_id
     * @param string $task_status
     * @param string $client_reference
     * @param string $client_status
     * @param \Signicat\DocumentServiceV3_API\StructType\Document_status[] $document_status
     */
    public function __construct($request_id = null, $task_id = null, $task_status = null, $client_reference = null, $client_status = null, array $document_status = array())
    {
        $this
            ->setRequest_id($request_id)
            ->setTask_id($task_id)
            ->setTask_status($task_status)
            ->setClient_reference($client_reference)
            ->setClient_status($client_status)
            ->setDocument_status($document_status);
    }
    /**
     * Get request_id value
     * @return string|null
     */
    public function getRequest_id()
    {
        return $this->{'request-id'};
    }
    /**
     * Set request_id value
     * @param string $request_id
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setRequest_id($request_id = null)
    {
        // validation for constraint: string
        if (!is_null($request_id) && !is_string($request_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($request_id)), __LINE__);
        }
        $this->request_id = $this->{'request-id'} = $request_id;
        return $this;
    }
    /**
     * Get task_id value
     * @return string|null
     */
    public function getTask_id()
    {
        return $this->{'task-id'};
    }
    /**
     * Set task_id value
     * @param string $task_id
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setTask_id($task_id = null)
    {
        // validation for constraint: string
        if (!is_null($task_id) && !is_string($task_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($task_id)), __LINE__);
        }
        $this->task_id = $this->{'task-id'} = $task_id;
        return $this;
    }
    /**
     * Get task_status value
     * @return string|null
     */
    public function getTask_status()
    {
        return $this->{'task-status'};
    }
    /**
     * Set task_status value
     * @param string $task_status
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setTask_status($task_status = null)
    {
        // validation for constraint: string
        if (!is_null($task_status) && !is_string($task_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($task_status)), __LINE__);
        }
        $this->task_status = $this->{'task-status'} = $task_status;
        return $this;
    }
    /**
     * Get client_reference value
     * @return string|null
     */
    public function getClient_reference()
    {
        return $this->{'client-reference'};
    }
    /**
     * Set client_reference value
     * @param string $client_reference
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setClient_reference($client_reference = null)
    {
        // validation for constraint: string
        if (!is_null($client_reference) && !is_string($client_reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($client_reference)), __LINE__);
        }
        $this->client_reference = $this->{'client-reference'} = $client_reference;
        return $this;
    }
    /**
     * Get client_status value
     * @return string|null
     */
    public function getClient_status()
    {
        return $this->{'client-status'};
    }
    /**
     * Set client_status value
     * @param string $client_status
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setClient_status($client_status = null)
    {
        // validation for constraint: string
        if (!is_null($client_status) && !is_string($client_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($client_status)), __LINE__);
        }
        $this->client_status = $this->{'client-status'} = $client_status;
        return $this;
    }
    /**
     * Get document_status value
     * @return \Signicat\DocumentServiceV3_API\StructType\Document_status[]|null
     */
    public function getDocument_status()
    {
        return $this->{'document-status'};
    }
    /**
     * Set document_status value
     * @throws \InvalidArgumentException
     * @param \Signicat\DocumentServiceV3_API\StructType\Document_status[] $document_status
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public function setDocument_status(array $document_status = array())
    {
        foreach ($document_status as $task_status_infoDocument_statusItem) {
            // validation for constraint: itemType
            if (!$task_status_infoDocument_statusItem instanceof \Signicat\DocumentServiceV3_API\StructType\Document_status) {
                throw new \InvalidArgumentException(sprintf('The document_status property can only contain items of \Signicat\DocumentServiceV3_API\StructType\Document_status, "%s" given', is_object($task_status_infoDocument_statusItem) ? get_class($task_status_infoDocument_statusItem) : gettype($task_status_infoDocument_statusItem)), __LINE__);
            }
        }
        $this->document_status = $this->{'document-status'} = $document_status;
        return $this;
    }
    /**
     */
    public function addToDocument_status(\Signicat\DocumentServiceV3_API\StructType\Document_status $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Signicat\DocumentServiceV3_API\StructType\Document_status) {
            throw new \InvalidArgumentException(sprintf('The document_status property can only contain items of \Signicat\DocumentServiceV3_API\StructType\Document_status, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->document_status[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Signicat\DocumentServiceV3_API\StructType\Task_status_info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
