<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rDonnees12 StructType
 * @subpackage Structs
 */
class RDonnees12 extends AbstractStructBase
{
    /**
     * The iNombreDeResultats
     * @var int
     */
    public $iNombreDeResultats;
    /**
     * The arFichesAnnuaire
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArFichesAnnuaire[]
     */
    public $arFichesAnnuaire;
    /**
     * Constructor method for rDonnees12
     * @uses RDonnees12::setINombreDeResultats()
     * @uses RDonnees12::setArFichesAnnuaire()
     * @param int $iNombreDeResultats
     * @param \StructType\ArFichesAnnuaire[] $arFichesAnnuaire
     */
    public function __construct($iNombreDeResultats = null, array $arFichesAnnuaire = array())
    {
        $this
            ->setINombreDeResultats($iNombreDeResultats)
            ->setArFichesAnnuaire($arFichesAnnuaire);
    }
    /**
     * Get iNombreDeResultats value
     * @return int|null
     */
    public function getINombreDeResultats()
    {
        return $this->iNombreDeResultats;
    }
    /**
     * Set iNombreDeResultats value
     * @param int $iNombreDeResultats
     * @return \StructType\RDonnees12
     */
    public function setINombreDeResultats($iNombreDeResultats = null)
    {
        // validation for constraint: int
        if (!is_null($iNombreDeResultats) && !is_numeric($iNombreDeResultats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNombreDeResultats)), __LINE__);
        }
        $this->iNombreDeResultats = $iNombreDeResultats;
        return $this;
    }
    /**
     * Get arFichesAnnuaire value
     * @return \StructType\ArFichesAnnuaire[]|null
     */
    public function getArFichesAnnuaire()
    {
        return $this->arFichesAnnuaire;
    }
    /**
     * Set arFichesAnnuaire value
     * @throws \InvalidArgumentException
     * @param \StructType\ArFichesAnnuaire[] $arFichesAnnuaire
     * @return \StructType\RDonnees12
     */
    public function setArFichesAnnuaire(array $arFichesAnnuaire = array())
    {
        foreach ($arFichesAnnuaire as $rDonnees12ArFichesAnnuaireItem) {
            // validation for constraint: itemType
            if (!$rDonnees12ArFichesAnnuaireItem instanceof \StructType\ArFichesAnnuaire) {
                throw new \InvalidArgumentException(sprintf('The arFichesAnnuaire property can only contain items of \StructType\ArFichesAnnuaire, "%s" given', is_object($rDonnees12ArFichesAnnuaireItem) ? get_class($rDonnees12ArFichesAnnuaireItem) : gettype($rDonnees12ArFichesAnnuaireItem)), __LINE__);
            }
        }
        $this->arFichesAnnuaire = $arFichesAnnuaire;
        return $this;
    }
    /**
     * Add item to arFichesAnnuaire value
     * @throws \InvalidArgumentException
     * @param \StructType\ArFichesAnnuaire $item
     * @return \StructType\RDonnees12
     */
    public function addToArFichesAnnuaire(\StructType\ArFichesAnnuaire $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArFichesAnnuaire) {
            throw new \InvalidArgumentException(sprintf('The arFichesAnnuaire property can only contain items of \StructType\ArFichesAnnuaire, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->arFichesAnnuaire[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RDonnees12
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
