<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for arAnomalie StructType
 * @subpackage Structs
 */
class ArAnomalie extends AbstractStructBase
{
    /**
     * The sCodeAnomalie
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sCodeAnomalie;
    /**
     * The sMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sMessage;
    /**
     * The sMessageEtendu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sMessageEtendu;
    /**
     * Constructor method for arAnomalie
     * @uses ArAnomalie::setSCodeAnomalie()
     * @uses ArAnomalie::setSMessage()
     * @uses ArAnomalie::setSMessageEtendu()
     * @param string $sCodeAnomalie
     * @param string $sMessage
     * @param string $sMessageEtendu
     */
    public function __construct($sCodeAnomalie = null, $sMessage = null, $sMessageEtendu = null)
    {
        $this
            ->setSCodeAnomalie($sCodeAnomalie)
            ->setSMessage($sMessage)
            ->setSMessageEtendu($sMessageEtendu);
    }
    /**
     * Get sCodeAnomalie value
     * @return string|null
     */
    public function getSCodeAnomalie()
    {
        return $this->sCodeAnomalie;
    }
    /**
     * Set sCodeAnomalie value
     * @param string $sCodeAnomalie
     * @return \StructType\ArAnomalie
     */
    public function setSCodeAnomalie($sCodeAnomalie = null)
    {
        // validation for constraint: string
        if (!is_null($sCodeAnomalie) && !is_string($sCodeAnomalie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCodeAnomalie)), __LINE__);
        }
        $this->sCodeAnomalie = $sCodeAnomalie;
        return $this;
    }
    /**
     * Get sMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSMessage()
    {
        return isset($this->sMessage) ? $this->sMessage : null;
    }
    /**
     * Set sMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sMessage
     * @return \StructType\ArAnomalie
     */
    public function setSMessage($sMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sMessage) && !is_string($sMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMessage)), __LINE__);
        }
        if (is_null($sMessage) || (is_array($sMessage) && empty($sMessage))) {
            unset($this->sMessage);
        } else {
            $this->sMessage = $sMessage;
        }
        return $this;
    }
    /**
     * Get sMessageEtendu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSMessageEtendu()
    {
        return isset($this->sMessageEtendu) ? $this->sMessageEtendu : null;
    }
    /**
     * Set sMessageEtendu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sMessageEtendu
     * @return \StructType\ArAnomalie
     */
    public function setSMessageEtendu($sMessageEtendu = null)
    {
        // validation for constraint: string
        if (!is_null($sMessageEtendu) && !is_string($sMessageEtendu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMessageEtendu)), __LINE__);
        }
        if (is_null($sMessageEtendu) || (is_array($sMessageEtendu) && empty($sMessageEtendu))) {
            unset($this->sMessageEtendu);
        } else {
            $this->sMessageEtendu = $sMessageEtendu;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArAnomalie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
