<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lire ServiceType
 * @subpackage Services
 */
class Lire extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lireSites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LireSites $parameters
     * @return \StructType\LireSitesResponse|bool
     */
    public function lireSites(\StructType\LireSites $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->lireSites($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named lireOrganigrammesSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LireOrganigrammesSite $parameters
     * @return \StructType\LireOrganigrammesSiteResponse|bool
     */
    public function lireOrganigrammesSite(\StructType\LireOrganigrammesSite $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->lireOrganigrammesSite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named lire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Lire $parameters
     * @return \StructType\LireResponse|bool
     */
    public function lire(\StructType\Lire $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->lire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named lireSitesRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LireSitesRegion $parameters
     * @return \StructType\LireSitesRegionResponse|bool
     */
    public function lireSitesRegion(\StructType\LireSitesRegion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->lireSitesRegion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named lireRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LireRegions $parameters
     * @return \StructType\LireRegionsResponse|bool
     */
    public function lireRegions(\StructType\LireRegions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->lireRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LireOrganigrammesSiteResponse|\StructType\LireRegionsResponse|\StructType\LireResponse|\StructType\LireSitesRegionResponse|\StructType\LireSitesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
