<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Lire ServiceType
 */
$lire = new \ServiceType\Lire($options);
/**
 * Sample call for lireSites operation/method
 */
if ($lire->lireSites(new \StructType\LireSites()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Sample call for lireOrganigrammesSite operation/method
 */
if ($lire->lireOrganigrammesSite(new \StructType\LireOrganigrammesSite()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Sample call for lire operation/method
 */
if ($lire->lire(new \StructType\Lire()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Sample call for lireSitesRegion operation/method
 */
if ($lire->lireSitesRegion(new \StructType\LireSitesRegion()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Sample call for lireRegions operation/method
 */
if ($lire->lireRegions(new \StructType\LireRegions()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Samples for Rechercher ServiceType
 */
$rechercher = new \ServiceType\Rechercher($options);
/**
 * Sample call for rechercher operation/method
 */
if ($rechercher->rechercher(new \StructType\Rechercher()) !== false) {
    print_r($rechercher->getResult());
} else {
    print_r($rechercher->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for ping operation/method
 */
if ($ping->ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
