<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UOM StructType
 * @subpackage Structs
 */
class UOM extends AbstractStructBase
{
    /**
     * The sNom
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sNom;
    /**
     * The sUnite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sUnite;
    /**
     * The asValeurs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $asValeurs;
    /**
     * Constructor method for UOM
     * @uses UOM::setSNom()
     * @uses UOM::setSUnite()
     * @uses UOM::setAsValeurs()
     * @param string $sNom
     * @param string $sUnite
     * @param string[] $asValeurs
     */
    public function __construct($sNom = null, $sUnite = null, array $asValeurs = array())
    {
        $this
            ->setSNom($sNom)
            ->setSUnite($sUnite)
            ->setAsValeurs($asValeurs);
    }
    /**
     * Get sNom value
     * @return string|null
     */
    public function getSNom()
    {
        return $this->sNom;
    }
    /**
     * Set sNom value
     * @param string $sNom
     * @return \StructType\UOM
     */
    public function setSNom($sNom = null)
    {
        // validation for constraint: string
        if (!is_null($sNom) && !is_string($sNom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sNom)), __LINE__);
        }
        $this->sNom = $sNom;
        return $this;
    }
    /**
     * Get sUnite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUnite()
    {
        return isset($this->sUnite) ? $this->sUnite : null;
    }
    /**
     * Set sUnite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUnite
     * @return \StructType\UOM
     */
    public function setSUnite($sUnite = null)
    {
        // validation for constraint: string
        if (!is_null($sUnite) && !is_string($sUnite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUnite)), __LINE__);
        }
        if (is_null($sUnite) || (is_array($sUnite) && empty($sUnite))) {
            unset($this->sUnite);
        } else {
            $this->sUnite = $sUnite;
        }
        return $this;
    }
    /**
     * Get asValeurs value
     * @return string[]|null
     */
    public function getAsValeurs()
    {
        return $this->asValeurs;
    }
    /**
     * Set asValeurs value
     * @throws \InvalidArgumentException
     * @param string[] $asValeurs
     * @return \StructType\UOM
     */
    public function setAsValeurs(array $asValeurs = array())
    {
        foreach ($asValeurs as $uOMAsValeursItem) {
            // validation for constraint: itemType
            if (!is_string($uOMAsValeursItem)) {
                throw new \InvalidArgumentException(sprintf('The asValeurs property can only contain items of string, "%s" given', is_object($uOMAsValeursItem) ? get_class($uOMAsValeursItem) : gettype($uOMAsValeursItem)), __LINE__);
            }
        }
        $this->asValeurs = $asValeurs;
        return $this;
    }
    /**
     * Add item to asValeurs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UOM
     */
    public function addToAsValeurs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The asValeurs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->asValeurs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UOM
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
