<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequeteLireRegions StructType
 * @subpackage Structs
 */
class RequeteLireRegions extends AbstractStructBase
{
    /**
     * The rContexte
     * @var \StructType\Contexte
     */
    public $rContexte;
    /**
     * The rDonnees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RDonnees5
     */
    public $rDonnees;
    /**
     * Constructor method for RequeteLireRegions
     * @uses RequeteLireRegions::setRContexte()
     * @uses RequeteLireRegions::setRDonnees()
     * @param \StructType\Contexte $rContexte
     * @param \StructType\RDonnees5 $rDonnees
     */
    public function __construct(\StructType\Contexte $rContexte = null, \StructType\RDonnees5 $rDonnees = null)
    {
        $this
            ->setRContexte($rContexte)
            ->setRDonnees($rDonnees);
    }
    /**
     * Get rContexte value
     * @return \StructType\Contexte|null
     */
    public function getRContexte()
    {
        return $this->rContexte;
    }
    /**
     * Set rContexte value
     * @param \StructType\Contexte $rContexte
     * @return \StructType\RequeteLireRegions
     */
    public function setRContexte(\StructType\Contexte $rContexte = null)
    {
        $this->rContexte = $rContexte;
        return $this;
    }
    /**
     * Get rDonnees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RDonnees5|null
     */
    public function getRDonnees()
    {
        return isset($this->rDonnees) ? $this->rDonnees : null;
    }
    /**
     * Set rDonnees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RDonnees5 $rDonnees
     * @return \StructType\RequeteLireRegions
     */
    public function setRDonnees(\StructType\RDonnees5 $rDonnees = null)
    {
        if (is_null($rDonnees) || (is_array($rDonnees) && empty($rDonnees))) {
            unset($this->rDonnees);
        } else {
            $this->rDonnees = $rDonnees;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequeteLireRegions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
