<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Exception StructType
 * @subpackage Structs
 */
class Exception extends AbstractStructBase
{
    /**
     * The sCodeDErreur
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sCodeDErreur;
    /**
     * The sMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sMessage;
    /**
     * The bEstTraitee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bEstTraitee;
    /**
     * The arAnomalie
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArAnomalie[]
     */
    public $arAnomalie;
    /**
     * Constructor method for Exception
     * @uses Exception::setSCodeDErreur()
     * @uses Exception::setSMessage()
     * @uses Exception::setBEstTraitee()
     * @uses Exception::setArAnomalie()
     * @param string $sCodeDErreur
     * @param string $sMessage
     * @param string $bEstTraitee
     * @param \StructType\ArAnomalie[] $arAnomalie
     */
    public function __construct($sCodeDErreur = null, $sMessage = null, $bEstTraitee = null, array $arAnomalie = array())
    {
        $this
            ->setSCodeDErreur($sCodeDErreur)
            ->setSMessage($sMessage)
            ->setBEstTraitee($bEstTraitee)
            ->setArAnomalie($arAnomalie);
    }
    /**
     * Get sCodeDErreur value
     * @return string|null
     */
    public function getSCodeDErreur()
    {
        return $this->sCodeDErreur;
    }
    /**
     * Set sCodeDErreur value
     * @param string $sCodeDErreur
     * @return \StructType\Exception
     */
    public function setSCodeDErreur($sCodeDErreur = null)
    {
        // validation for constraint: string
        if (!is_null($sCodeDErreur) && !is_string($sCodeDErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCodeDErreur)), __LINE__);
        }
        $this->sCodeDErreur = $sCodeDErreur;
        return $this;
    }
    /**
     * Get sMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSMessage()
    {
        return isset($this->sMessage) ? $this->sMessage : null;
    }
    /**
     * Set sMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sMessage
     * @return \StructType\Exception
     */
    public function setSMessage($sMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sMessage) && !is_string($sMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMessage)), __LINE__);
        }
        if (is_null($sMessage) || (is_array($sMessage) && empty($sMessage))) {
            unset($this->sMessage);
        } else {
            $this->sMessage = $sMessage;
        }
        return $this;
    }
    /**
     * Get bEstTraitee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBEstTraitee()
    {
        return isset($this->bEstTraitee) ? $this->bEstTraitee : null;
    }
    /**
     * Set bEstTraitee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bEstTraitee
     * @return \StructType\Exception
     */
    public function setBEstTraitee($bEstTraitee = null)
    {
        // validation for constraint: string
        if (!is_null($bEstTraitee) && !is_string($bEstTraitee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bEstTraitee)), __LINE__);
        }
        if (is_null($bEstTraitee) || (is_array($bEstTraitee) && empty($bEstTraitee))) {
            unset($this->bEstTraitee);
        } else {
            $this->bEstTraitee = $bEstTraitee;
        }
        return $this;
    }
    /**
     * Get arAnomalie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArAnomalie[]|null
     */
    public function getArAnomalie()
    {
        return isset($this->arAnomalie) ? $this->arAnomalie : null;
    }
    /**
     * Set arAnomalie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArAnomalie[] $arAnomalie
     * @return \StructType\Exception
     */
    public function setArAnomalie(array $arAnomalie = array())
    {
        foreach ($arAnomalie as $exceptionArAnomalieItem) {
            // validation for constraint: itemType
            if (!$exceptionArAnomalieItem instanceof \StructType\ArAnomalie) {
                throw new \InvalidArgumentException(sprintf('The arAnomalie property can only contain items of \StructType\ArAnomalie, "%s" given', is_object($exceptionArAnomalieItem) ? get_class($exceptionArAnomalieItem) : gettype($exceptionArAnomalieItem)), __LINE__);
            }
        }
        if (is_null($arAnomalie) || (is_array($arAnomalie) && empty($arAnomalie))) {
            unset($this->arAnomalie);
        } else {
            $this->arAnomalie = $arAnomalie;
        }
        return $this;
    }
    /**
     * Add item to arAnomalie value
     * @throws \InvalidArgumentException
     * @param \StructType\ArAnomalie $item
     * @return \StructType\Exception
     */
    public function addToArAnomalie(\StructType\ArAnomalie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArAnomalie) {
            throw new \InvalidArgumentException(sprintf('The arAnomalie property can only contain items of \StructType\ArAnomalie, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->arAnomalie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Exception
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
