<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contexte StructType
 * @subpackage Structs
 */
class Contexte extends AbstractStructBase
{
    /**
     * The sIDDAppel
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sIDDAppel;
    /**
     * The sIDDeMessage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sIDDeMessage;
    /**
     * The sIDMetierDuConsommateur
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sIDMetierDuConsommateur;
    /**
     * The sVersionDuContexte
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sVersionDuContexte;
    /**
     * The sService
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sService;
    /**
     * The iVersionDuService
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $iVersionDuService;
    /**
     * The sOperation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sOperation;
    /**
     * The sCanal
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sCanal;
    /**
     * The sCodeDUsage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sCodeDUsage;
    /**
     * The bCaptureDErreur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bCaptureDErreur;
    /**
     * The aExtensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaireClefValeur[]
     */
    public $aExtensions;
    /**
     * The aUnitesDOeuvreMetier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UOM[]
     */
    public $aUnitesDOeuvreMetier;
    /**
     * Constructor method for Contexte
     * @uses Contexte::setSIDDAppel()
     * @uses Contexte::setSIDDeMessage()
     * @uses Contexte::setSIDMetierDuConsommateur()
     * @uses Contexte::setSVersionDuContexte()
     * @uses Contexte::setSService()
     * @uses Contexte::setIVersionDuService()
     * @uses Contexte::setSOperation()
     * @uses Contexte::setSCanal()
     * @uses Contexte::setSCodeDUsage()
     * @uses Contexte::setBCaptureDErreur()
     * @uses Contexte::setAExtensions()
     * @uses Contexte::setAUnitesDOeuvreMetier()
     * @param string $sIDDAppel
     * @param string $sIDDeMessage
     * @param string $sIDMetierDuConsommateur
     * @param string $sVersionDuContexte
     * @param string $sService
     * @param string $iVersionDuService
     * @param string $sOperation
     * @param string $sCanal
     * @param string $sCodeDUsage
     * @param string $bCaptureDErreur
     * @param \StructType\PaireClefValeur[] $aExtensions
     * @param \StructType\UOM[] $aUnitesDOeuvreMetier
     */
    public function __construct($sIDDAppel = null, $sIDDeMessage = null, $sIDMetierDuConsommateur = null, $sVersionDuContexte = null, $sService = null, $iVersionDuService = null, $sOperation = null, $sCanal = null, $sCodeDUsage = null, $bCaptureDErreur = null, array $aExtensions = array(), array $aUnitesDOeuvreMetier = array())
    {
        $this
            ->setSIDDAppel($sIDDAppel)
            ->setSIDDeMessage($sIDDeMessage)
            ->setSIDMetierDuConsommateur($sIDMetierDuConsommateur)
            ->setSVersionDuContexte($sVersionDuContexte)
            ->setSService($sService)
            ->setIVersionDuService($iVersionDuService)
            ->setSOperation($sOperation)
            ->setSCanal($sCanal)
            ->setSCodeDUsage($sCodeDUsage)
            ->setBCaptureDErreur($bCaptureDErreur)
            ->setAExtensions($aExtensions)
            ->setAUnitesDOeuvreMetier($aUnitesDOeuvreMetier);
    }
    /**
     * Get sIDDAppel value
     * @return string|null
     */
    public function getSIDDAppel()
    {
        return $this->sIDDAppel;
    }
    /**
     * Set sIDDAppel value
     * @param string $sIDDAppel
     * @return \StructType\Contexte
     */
    public function setSIDDAppel($sIDDAppel = null)
    {
        // validation for constraint: string
        if (!is_null($sIDDAppel) && !is_string($sIDDAppel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIDDAppel)), __LINE__);
        }
        $this->sIDDAppel = $sIDDAppel;
        return $this;
    }
    /**
     * Get sIDDeMessage value
     * @return string|null
     */
    public function getSIDDeMessage()
    {
        return $this->sIDDeMessage;
    }
    /**
     * Set sIDDeMessage value
     * @param string $sIDDeMessage
     * @return \StructType\Contexte
     */
    public function setSIDDeMessage($sIDDeMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sIDDeMessage) && !is_string($sIDDeMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIDDeMessage)), __LINE__);
        }
        $this->sIDDeMessage = $sIDDeMessage;
        return $this;
    }
    /**
     * Get sIDMetierDuConsommateur value
     * @return string|null
     */
    public function getSIDMetierDuConsommateur()
    {
        return $this->sIDMetierDuConsommateur;
    }
    /**
     * Set sIDMetierDuConsommateur value
     * @param string $sIDMetierDuConsommateur
     * @return \StructType\Contexte
     */
    public function setSIDMetierDuConsommateur($sIDMetierDuConsommateur = null)
    {
        // validation for constraint: string
        if (!is_null($sIDMetierDuConsommateur) && !is_string($sIDMetierDuConsommateur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIDMetierDuConsommateur)), __LINE__);
        }
        $this->sIDMetierDuConsommateur = $sIDMetierDuConsommateur;
        return $this;
    }
    /**
     * Get sVersionDuContexte value
     * @return string|null
     */
    public function getSVersionDuContexte()
    {
        return $this->sVersionDuContexte;
    }
    /**
     * Set sVersionDuContexte value
     * @param string $sVersionDuContexte
     * @return \StructType\Contexte
     */
    public function setSVersionDuContexte($sVersionDuContexte = null)
    {
        // validation for constraint: string
        if (!is_null($sVersionDuContexte) && !is_string($sVersionDuContexte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sVersionDuContexte)), __LINE__);
        }
        $this->sVersionDuContexte = $sVersionDuContexte;
        return $this;
    }
    /**
     * Get sService value
     * @return string|null
     */
    public function getSService()
    {
        return $this->sService;
    }
    /**
     * Set sService value
     * @param string $sService
     * @return \StructType\Contexte
     */
    public function setSService($sService = null)
    {
        // validation for constraint: string
        if (!is_null($sService) && !is_string($sService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sService)), __LINE__);
        }
        $this->sService = $sService;
        return $this;
    }
    /**
     * Get iVersionDuService value
     * @return string|null
     */
    public function getIVersionDuService()
    {
        return $this->iVersionDuService;
    }
    /**
     * Set iVersionDuService value
     * @param string $iVersionDuService
     * @return \StructType\Contexte
     */
    public function setIVersionDuService($iVersionDuService = null)
    {
        // validation for constraint: string
        if (!is_null($iVersionDuService) && !is_string($iVersionDuService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iVersionDuService)), __LINE__);
        }
        $this->iVersionDuService = $iVersionDuService;
        return $this;
    }
    /**
     * Get sOperation value
     * @return string|null
     */
    public function getSOperation()
    {
        return $this->sOperation;
    }
    /**
     * Set sOperation value
     * @param string $sOperation
     * @return \StructType\Contexte
     */
    public function setSOperation($sOperation = null)
    {
        // validation for constraint: string
        if (!is_null($sOperation) && !is_string($sOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sOperation)), __LINE__);
        }
        $this->sOperation = $sOperation;
        return $this;
    }
    /**
     * Get sCanal value
     * @return string|null
     */
    public function getSCanal()
    {
        return $this->sCanal;
    }
    /**
     * Set sCanal value
     * @param string $sCanal
     * @return \StructType\Contexte
     */
    public function setSCanal($sCanal = null)
    {
        // validation for constraint: string
        if (!is_null($sCanal) && !is_string($sCanal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCanal)), __LINE__);
        }
        $this->sCanal = $sCanal;
        return $this;
    }
    /**
     * Get sCodeDUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSCodeDUsage()
    {
        return isset($this->sCodeDUsage) ? $this->sCodeDUsage : null;
    }
    /**
     * Set sCodeDUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sCodeDUsage
     * @return \StructType\Contexte
     */
    public function setSCodeDUsage($sCodeDUsage = null)
    {
        // validation for constraint: string
        if (!is_null($sCodeDUsage) && !is_string($sCodeDUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCodeDUsage)), __LINE__);
        }
        if (is_null($sCodeDUsage) || (is_array($sCodeDUsage) && empty($sCodeDUsage))) {
            unset($this->sCodeDUsage);
        } else {
            $this->sCodeDUsage = $sCodeDUsage;
        }
        return $this;
    }
    /**
     * Get bCaptureDErreur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBCaptureDErreur()
    {
        return isset($this->bCaptureDErreur) ? $this->bCaptureDErreur : null;
    }
    /**
     * Set bCaptureDErreur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bCaptureDErreur
     * @return \StructType\Contexte
     */
    public function setBCaptureDErreur($bCaptureDErreur = null)
    {
        // validation for constraint: string
        if (!is_null($bCaptureDErreur) && !is_string($bCaptureDErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bCaptureDErreur)), __LINE__);
        }
        if (is_null($bCaptureDErreur) || (is_array($bCaptureDErreur) && empty($bCaptureDErreur))) {
            unset($this->bCaptureDErreur);
        } else {
            $this->bCaptureDErreur = $bCaptureDErreur;
        }
        return $this;
    }
    /**
     * Get aExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaireClefValeur[]|null
     */
    public function getAExtensions()
    {
        return isset($this->aExtensions) ? $this->aExtensions : null;
    }
    /**
     * Set aExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaireClefValeur[] $aExtensions
     * @return \StructType\Contexte
     */
    public function setAExtensions(array $aExtensions = array())
    {
        foreach ($aExtensions as $contexteAExtensionsItem) {
            // validation for constraint: itemType
            if (!$contexteAExtensionsItem instanceof \StructType\PaireClefValeur) {
                throw new \InvalidArgumentException(sprintf('The aExtensions property can only contain items of \StructType\PaireClefValeur, "%s" given', is_object($contexteAExtensionsItem) ? get_class($contexteAExtensionsItem) : gettype($contexteAExtensionsItem)), __LINE__);
            }
        }
        if (is_null($aExtensions) || (is_array($aExtensions) && empty($aExtensions))) {
            unset($this->aExtensions);
        } else {
            $this->aExtensions = $aExtensions;
        }
        return $this;
    }
    /**
     * Add item to aExtensions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaireClefValeur $item
     * @return \StructType\Contexte
     */
    public function addToAExtensions(\StructType\PaireClefValeur $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaireClefValeur) {
            throw new \InvalidArgumentException(sprintf('The aExtensions property can only contain items of \StructType\PaireClefValeur, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->aExtensions[] = $item;
        return $this;
    }
    /**
     * Get aUnitesDOeuvreMetier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UOM[]|null
     */
    public function getAUnitesDOeuvreMetier()
    {
        return isset($this->aUnitesDOeuvreMetier) ? $this->aUnitesDOeuvreMetier : null;
    }
    /**
     * Set aUnitesDOeuvreMetier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UOM[] $aUnitesDOeuvreMetier
     * @return \StructType\Contexte
     */
    public function setAUnitesDOeuvreMetier(array $aUnitesDOeuvreMetier = array())
    {
        foreach ($aUnitesDOeuvreMetier as $contexteAUnitesDOeuvreMetierItem) {
            // validation for constraint: itemType
            if (!$contexteAUnitesDOeuvreMetierItem instanceof \StructType\UOM) {
                throw new \InvalidArgumentException(sprintf('The aUnitesDOeuvreMetier property can only contain items of \StructType\UOM, "%s" given', is_object($contexteAUnitesDOeuvreMetierItem) ? get_class($contexteAUnitesDOeuvreMetierItem) : gettype($contexteAUnitesDOeuvreMetierItem)), __LINE__);
            }
        }
        if (is_null($aUnitesDOeuvreMetier) || (is_array($aUnitesDOeuvreMetier) && empty($aUnitesDOeuvreMetier))) {
            unset($this->aUnitesDOeuvreMetier);
        } else {
            $this->aUnitesDOeuvreMetier = $aUnitesDOeuvreMetier;
        }
        return $this;
    }
    /**
     * Add item to aUnitesDOeuvreMetier value
     * @throws \InvalidArgumentException
     * @param \StructType\UOM $item
     * @return \StructType\Contexte
     */
    public function addToAUnitesDOeuvreMetier(\StructType\UOM $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UOM) {
            throw new \InvalidArgumentException(sprintf('The aUnitesDOeuvreMetier property can only contain items of \StructType\UOM, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->aUnitesDOeuvreMetier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contexte
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
