<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new Retrieve($options);
/**
 * Sample call for retrieveSignatureProofOfDeliveryLetter operation/method
 */
if ($retrieve->retrieveSignatureProofOfDeliveryLetter(new SignatureProofOfDeliveryLetterRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Track ServiceType
 */
$track = new Track($options);
/**
 * Sample call for track operation/method
 */
if ($track->track(new TrackRequest()) !== false) {
    print_r($track->getResult());
} else {
    print_r($track->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new Send($options);
/**
 * Sample call for sendSignatureProofOfDeliveryFax operation/method
 */
if ($send->sendSignatureProofOfDeliveryFax(new SignatureProofOfDeliveryFaxRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendNotifications operation/method
 */
if ($send->sendNotifications(new SendNotificationsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
