<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Detailed tracking information about a particular package.
 * @subpackage Structs
 */
class TrackDetail extends AbstractStructBase
{
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - documentation: To report soft error on an individual track detail.
     * - minOccurs: 0
     * @var Notification
     */
    public $Notification;
    /**
     * The TrackingNumber
     * Meta informations extracted from the WSDL
     * - documentation: The FedEx package identifier.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var StringBarcode
     */
    public $Barcode;
    /**
     * The TrackingNumberUniqueIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: When duplicate tracking numbers exist this data is returned with summary information for each of the duplicates. The summary information is used to determine which of the duplicates the intended tracking number is. This identifier is
     * used on a subsequent track request to retrieve the tracking data for the desired tracking number.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumberUniqueIdentifier;
    /**
     * The StatusDetail
     * Meta informations extracted from the WSDL
     * - documentation: Specifies details about the status of the shipment being tracked.
     * - minOccurs: 0
     * @var TrackStatusDetail
     */
    public $StatusDetail;
    /**
     * The CustomerExceptionRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var CustomerExceptionRequestDetail[]
     */
    public $CustomerExceptionRequests;
    /**
     * The Reconciliation
     * Meta informations extracted from the WSDL
     * - documentation: Used to report the status of a piece of a multiple piece shipment which is no longer traveling with the rest of the packages in the shipment or has not been accounted for.
     * - minOccurs: 0
     * @var TrackReconciliation
     */
    public $Reconciliation;
    /**
     * The ServiceCommitMessage
     * Meta informations extracted from the WSDL
     * - documentation: Used to convey information such as. 1. FedEx has received information about a package but has not yet taken possession of it. 2. FedEx has handed the package off to a third party for final delivery. 3. The package delivery has been
     * cancelled
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCommitMessage;
    /**
     * The DestinationServiceArea
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationServiceArea;
    /**
     * The DestinationServiceAreaDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationServiceAreaDescription;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a FedEx operating company (transportation).
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The OperatingCompany
     * Meta informations extracted from the WSDL
     * - documentation: Identifies operating transportation company that is the specific to the carrier code.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCompany;
    /**
     * The OperatingCompanyOrCarrierDescription
     * Meta informations extracted from the WSDL
     * - documentation: Specifies a detailed description about the carrier or the operating company.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCompanyOrCarrierDescription;
    /**
     * The CartageAgentCompanyName
     * Meta informations extracted from the WSDL
     * - documentation: If the package was interlined to a cartage agent, this is the name of the cartage agent. (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $CartageAgentCompanyName;
    /**
     * The ProductionLocationContactAndAddress
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the FXO production centre contact and address.
     * - minOccurs: 0
     * @var ContactAndAddress
     */
    public $ProductionLocationContactAndAddress;
    /**
     * The OtherIdentifiers
     * Meta informations extracted from the WSDL
     * - documentation: Other related identifiers for this package such as reference numbers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackOtherIdentifierDetail[]
     */
    public $OtherIdentifiers;
    /**
     * The FormId
     * Meta informations extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $FormId;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - documentation: Specifies details about service such as service description and type.
     * - minOccurs: 0
     * @var TrackServiceDescriptionDetail
     */
    public $Service;
    /**
     * The PackageWeight
     * Meta informations extracted from the WSDL
     * - documentation: The weight of this package.
     * - minOccurs: 0
     * @var Weight
     */
    public $PackageWeight;
    /**
     * The PackageDimensions
     * Meta informations extracted from the WSDL
     * - documentation: Physical dimensions of the package.
     * - minOccurs: 0
     * @var Dimensions
     */
    public $PackageDimensions;
    /**
     * The PackageDimensionalWeight
     * Meta informations extracted from the WSDL
     * - documentation: The dimensional weight of the package.
     * - minOccurs: 0
     * @var Weight
     */
    public $PackageDimensionalWeight;
    /**
     * The ShipmentWeight
     * Meta informations extracted from the WSDL
     * - documentation: The weight of the entire shipment.
     * - minOccurs: 0
     * @var Weight
     */
    public $ShipmentWeight;
    /**
     * The Packaging
     * Meta informations extracted from the WSDL
     * - documentation: Retained for legacy compatibility only.
     * - minOccurs: 0
     * @var string
     */
    public $Packaging;
    /**
     * The PackagingType
     * Meta informations extracted from the WSDL
     * - documentation: Strict representation of the Packaging type (e.g. FEDEX_BOX, YOUR_PACKAGING).
     * - minOccurs: 0
     * @var string
     */
    public $PackagingType;
    /**
     * The PackageSequenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: The sequence number of this package in a shipment. This would be 2 if it was package number 2 of 4.
     * - minOccurs: 0
     * @var int
     */
    public $PackageSequenceNumber;
    /**
     * The PackageCount
     * Meta informations extracted from the WSDL
     * - documentation: The number of packages in this shipment.
     * - minOccurs: 0
     * @var int
     */
    public $PackageCount;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the details about the SPOC details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackChargeDetail[]
     */
    public $Charges;
    /**
     * The NickName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NickName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Attributes;
    /**
     * The ShipmentContents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ContentRecord[]
     */
    public $ShipmentContents;
    /**
     * The PackageContents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PackageContents;
    /**
     * The ClearanceLocationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClearanceLocationCode;
    /**
     * The Commodities
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var Commodity[]
     */
    public $Commodities;
    /**
     * The ReturnDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var TrackReturnDetail
     */
    public $ReturnDetail;
    /**
     * The CustomsOptionDetails
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the reason for return.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var CustomsOptionDetail[]
     */
    public $CustomsOptionDetails;
    /**
     * The AdvanceNotificationDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var TrackAdvanceNotificationDetail
     */
    public $AdvanceNotificationDetail;
    /**
     * The SpecialHandlings
     * Meta informations extracted from the WSDL
     * - documentation: List of special handlings that applied to this package. (Returned for CSR SL only.)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackSpecialHandling[]
     */
    public $SpecialHandlings;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var Contact
     */
    public $Shipper;
    /**
     * The PossessionStatus
     * Meta informations extracted from the WSDL
     * - documentation: Indicates last-known possession of package (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $PossessionStatus;
    /**
     * The ShipperAddress
     * Meta informations extracted from the WSDL
     * - documentation: The address information for the shipper.
     * - minOccurs: 0
     * @var Address
     */
    public $ShipperAddress;
    /**
     * The OriginLocationAddress
     * Meta informations extracted from the WSDL
     * - documentation: The address of the FedEx pickup location/facility.
     * - minOccurs: 0
     * @var Address
     */
    public $OriginLocationAddress;
    /**
     * The OriginStationId
     * Meta informations extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $OriginStationId;
    /**
     * The EstimatedPickupTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Estimated package pickup time for shipments that haven't been picked up.
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedPickupTimestamp;
    /**
     * The ShipTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Time package was shipped/tendered over to FedEx. Time portion will be populated if available, otherwise will be set to midnight.
     * - minOccurs: 0
     * @var string
     */
    public $ShipTimestamp;
    /**
     * The TotalTransitDistance
     * Meta informations extracted from the WSDL
     * - documentation: The distance from the origin to the destination. Returned for Custom Critical shipments.
     * - minOccurs: 0
     * @var Distance
     */
    public $TotalTransitDistance;
    /**
     * The DistanceToDestination
     * Meta informations extracted from the WSDL
     * - documentation: Total distance package still has to travel. Returned for Custom Critical shipments.
     * - minOccurs: 0
     * @var Distance
     */
    public $DistanceToDestination;
    /**
     * The SpecialInstructions
     * Meta informations extracted from the WSDL
     * - documentation: Provides additional details about package delivery.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackSpecialInstruction[]
     */
    public $SpecialInstructions;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var Contact
     */
    public $Recipient;
    /**
     * The LastUpdatedDestinationAddress
     * Meta informations extracted from the WSDL
     * - documentation: This is the latest updated destination address.
     * - minOccurs: 0
     * @var Address
     */
    public $LastUpdatedDestinationAddress;
    /**
     * The DestinationAddress
     * Meta informations extracted from the WSDL
     * - documentation: The address this package is to be (or has been) delivered.
     * - minOccurs: 0
     * @var Address
     */
    public $DestinationAddress;
    /**
     * The HoldAtLocationContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var Contact
     */
    public $HoldAtLocationContact;
    /**
     * The HoldAtLocationAddress
     * Meta informations extracted from the WSDL
     * - documentation: The address this package is requested to placed on hold.
     * - minOccurs: 0
     * @var Address
     */
    public $HoldAtLocationAddress;
    /**
     * The DestinationStationId
     * Meta informations extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $DestinationStationId;
    /**
     * The DestinationLocationAddress
     * Meta informations extracted from the WSDL
     * - documentation: The address of the FedEx delivery location/facility.
     * - minOccurs: 0
     * @var Address
     */
    public $DestinationLocationAddress;
    /**
     * The DestinationLocationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationLocationType;
    /**
     * The DestinationLocationTimeZoneOffset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationLocationTimeZoneOffset;
    /**
     * The CommitmentTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Date and time the package should be (or should have been) delivered. (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $CommitmentTimestamp;
    /**
     * The AppointmentDeliveryTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Date and time the package would be delivered if the package has appointment delivery as a special service.
     * - minOccurs: 0
     * @var string
     */
    public $AppointmentDeliveryTimestamp;
    /**
     * The EstimatedDeliveryTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Projected package delivery time based on ship time stamp, service and destination. Not populated if delivery has already occurred.
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryTimestamp;
    /**
     * The ActualDeliveryTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: The time the package was actually delivered.
     * - minOccurs: 0
     * @var string
     */
    public $ActualDeliveryTimestamp;
    /**
     * The ActualDeliveryAddress
     * Meta informations extracted from the WSDL
     * - documentation: Actual address where package was delivered. Differs from destinationAddress, which indicates where the package was to be delivered; This field tells where delivery actually occurred (next door, at station, etc.)
     * - minOccurs: 0
     * @var Address
     */
    public $ActualDeliveryAddress;
    /**
     * The OfficeOrderDeliveryMethod
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the method of office order delivery.
     * - minOccurs: 0
     * @var string
     */
    public $OfficeOrderDeliveryMethod;
    /**
     * The DeliveryLocationType
     * Meta informations extracted from the WSDL
     * - documentation: Strict text indicating the delivery location at the delivered to address.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryLocationType;
    /**
     * The DeliveryLocationDescription
     * Meta informations extracted from the WSDL
     * - documentation: User/screen friendly representation of the DeliveryLocationType (delivery location at the delivered to address). Can be returned in localized text.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryLocationDescription;
    /**
     * The DeliveryAttempts
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the number of delivery attempts made to deliver the shipment.
     * - minOccurs: 0
     * @var int
     */
    public $DeliveryAttempts;
    /**
     * The DeliverySignatureName
     * Meta informations extracted from the WSDL
     * - documentation: This is either the name of the person that signed for the package or "Signature not requested" or "Signature on file".
     * - minOccurs: 0
     * @var string
     */
    public $DeliverySignatureName;
    /**
     * The PieceCountVerificationDetails
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the details about the count of the packages delivered at the delivery location and the count of the packages at the origin.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PieceCountVerificationDetail[]
     */
    public $PieceCountVerificationDetails;
    /**
     * The TotalUniqueAddressCountInConsolidation
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the total number of unique addresses on the CRNs in a consolidation.
     * - minOccurs: 0
     * @var int
     */
    public $TotalUniqueAddressCountInConsolidation;
    /**
     * The AvailableImages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AvailableImages;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var SignatureImageDetail
     */
    public $Signature;
    /**
     * The NotificationEventsAvailable
     * Meta informations extracted from the WSDL
     * - documentation: The types of email notifications that are available for the package.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NotificationEventsAvailable;
    /**
     * The SplitShipmentParts
     * Meta informations extracted from the WSDL
     * - documentation: Returned for cargo shipments only when they are currently split across vehicles.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackSplitShipmentPart[]
     */
    public $SplitShipmentParts;
    /**
     * The DeliveryOptionEligibilityDetails
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the details about the eligibility for different delivery options.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DeliveryOptionEligibilityDetail[]
     */
    public $DeliveryOptionEligibilityDetails;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - documentation: Event information for a tracking number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TrackEvent[]
     */
    public $Events;
    /**
     * Constructor method for TrackDetail
     * @uses TrackDetail::setNotification()
     * @uses TrackDetail::setTrackingNumber()
     * @uses TrackDetail::setBarcode()
     * @uses TrackDetail::setTrackingNumberUniqueIdentifier()
     * @uses TrackDetail::setStatusDetail()
     * @uses TrackDetail::setCustomerExceptionRequests()
     * @uses TrackDetail::setReconciliation()
     * @uses TrackDetail::setServiceCommitMessage()
     * @uses TrackDetail::setDestinationServiceArea()
     * @uses TrackDetail::setDestinationServiceAreaDescription()
     * @uses TrackDetail::setCarrierCode()
     * @uses TrackDetail::setOperatingCompany()
     * @uses TrackDetail::setOperatingCompanyOrCarrierDescription()
     * @uses TrackDetail::setCartageAgentCompanyName()
     * @uses TrackDetail::setProductionLocationContactAndAddress()
     * @uses TrackDetail::setOtherIdentifiers()
     * @uses TrackDetail::setFormId()
     * @uses TrackDetail::setService()
     * @uses TrackDetail::setPackageWeight()
     * @uses TrackDetail::setPackageDimensions()
     * @uses TrackDetail::setPackageDimensionalWeight()
     * @uses TrackDetail::setShipmentWeight()
     * @uses TrackDetail::setPackaging()
     * @uses TrackDetail::setPackagingType()
     * @uses TrackDetail::setPackageSequenceNumber()
     * @uses TrackDetail::setPackageCount()
     * @uses TrackDetail::setCharges()
     * @uses TrackDetail::setNickName()
     * @uses TrackDetail::setNotes()
     * @uses TrackDetail::setAttributes()
     * @uses TrackDetail::setShipmentContents()
     * @uses TrackDetail::setPackageContents()
     * @uses TrackDetail::setClearanceLocationCode()
     * @uses TrackDetail::setCommodities()
     * @uses TrackDetail::setReturnDetail()
     * @uses TrackDetail::setCustomsOptionDetails()
     * @uses TrackDetail::setAdvanceNotificationDetail()
     * @uses TrackDetail::setSpecialHandlings()
     * @uses TrackDetail::setShipper()
     * @uses TrackDetail::setPossessionStatus()
     * @uses TrackDetail::setShipperAddress()
     * @uses TrackDetail::setOriginLocationAddress()
     * @uses TrackDetail::setOriginStationId()
     * @uses TrackDetail::setEstimatedPickupTimestamp()
     * @uses TrackDetail::setShipTimestamp()
     * @uses TrackDetail::setTotalTransitDistance()
     * @uses TrackDetail::setDistanceToDestination()
     * @uses TrackDetail::setSpecialInstructions()
     * @uses TrackDetail::setRecipient()
     * @uses TrackDetail::setLastUpdatedDestinationAddress()
     * @uses TrackDetail::setDestinationAddress()
     * @uses TrackDetail::setHoldAtLocationContact()
     * @uses TrackDetail::setHoldAtLocationAddress()
     * @uses TrackDetail::setDestinationStationId()
     * @uses TrackDetail::setDestinationLocationAddress()
     * @uses TrackDetail::setDestinationLocationType()
     * @uses TrackDetail::setDestinationLocationTimeZoneOffset()
     * @uses TrackDetail::setCommitmentTimestamp()
     * @uses TrackDetail::setAppointmentDeliveryTimestamp()
     * @uses TrackDetail::setEstimatedDeliveryTimestamp()
     * @uses TrackDetail::setActualDeliveryTimestamp()
     * @uses TrackDetail::setActualDeliveryAddress()
     * @uses TrackDetail::setOfficeOrderDeliveryMethod()
     * @uses TrackDetail::setDeliveryLocationType()
     * @uses TrackDetail::setDeliveryLocationDescription()
     * @uses TrackDetail::setDeliveryAttempts()
     * @uses TrackDetail::setDeliverySignatureName()
     * @uses TrackDetail::setPieceCountVerificationDetails()
     * @uses TrackDetail::setTotalUniqueAddressCountInConsolidation()
     * @uses TrackDetail::setAvailableImages()
     * @uses TrackDetail::setSignature()
     * @uses TrackDetail::setNotificationEventsAvailable()
     * @uses TrackDetail::setSplitShipmentParts()
     * @uses TrackDetail::setDeliveryOptionEligibilityDetails()
     * @uses TrackDetail::setEvents()
     * @param Notification $notification
     * @param string $trackingNumber
     * @param StringBarcode $barcode
     * @param string $trackingNumberUniqueIdentifier
     * @param TrackStatusDetail $statusDetail
     * @param CustomerExceptionRequestDetail[] $customerExceptionRequests
     * @param TrackReconciliation $reconciliation
     * @param string $serviceCommitMessage
     * @param string $destinationServiceArea
     * @param string $destinationServiceAreaDescription
     * @param string $carrierCode
     * @param string $operatingCompany
     * @param string $operatingCompanyOrCarrierDescription
     * @param string $cartageAgentCompanyName
     * @param ContactAndAddress $productionLocationContactAndAddress
     * @param TrackOtherIdentifierDetail[] $otherIdentifiers
     * @param string $formId
     * @param TrackServiceDescriptionDetail $service
     * @param Weight $packageWeight
     * @param Dimensions $packageDimensions
     * @param Weight $packageDimensionalWeight
     * @param Weight $shipmentWeight
     * @param string $packaging
     * @param string $packagingType
     * @param int $packageSequenceNumber
     * @param int $packageCount
     * @param TrackChargeDetail[] $charges
     * @param string $nickName
     * @param string $notes
     * @param string[] $attributes
     * @param ContentRecord[] $shipmentContents
     * @param string[] $packageContents
     * @param string $clearanceLocationCode
     * @param Commodity[] $commodities
     * @param TrackReturnDetail $returnDetail
     * @param CustomsOptionDetail[] $customsOptionDetails
     * @param TrackAdvanceNotificationDetail $advanceNotificationDetail
     * @param TrackSpecialHandling[] $specialHandlings
     * @param Contact $shipper
     * @param string $possessionStatus
     * @param Address $shipperAddress
     * @param Address $originLocationAddress
     * @param string $originStationId
     * @param string $estimatedPickupTimestamp
     * @param string $shipTimestamp
     * @param Distance $totalTransitDistance
     * @param Distance $distanceToDestination
     * @param TrackSpecialInstruction[] $specialInstructions
     * @param Contact $recipient
     * @param Address $lastUpdatedDestinationAddress
     * @param Address $destinationAddress
     * @param Contact $holdAtLocationContact
     * @param Address $holdAtLocationAddress
     * @param string $destinationStationId
     * @param Address $destinationLocationAddress
     * @param string $destinationLocationType
     * @param string $destinationLocationTimeZoneOffset
     * @param string $commitmentTimestamp
     * @param string $appointmentDeliveryTimestamp
     * @param string $estimatedDeliveryTimestamp
     * @param string $actualDeliveryTimestamp
     * @param Address $actualDeliveryAddress
     * @param string $officeOrderDeliveryMethod
     * @param string $deliveryLocationType
     * @param string $deliveryLocationDescription
     * @param int $deliveryAttempts
     * @param string $deliverySignatureName
     * @param PieceCountVerificationDetail[] $pieceCountVerificationDetails
     * @param int $totalUniqueAddressCountInConsolidation
     * @param string[] $availableImages
     * @param SignatureImageDetail $signature
     * @param string[] $notificationEventsAvailable
     * @param TrackSplitShipmentPart[] $splitShipmentParts
     * @param DeliveryOptionEligibilityDetail[] $deliveryOptionEligibilityDetails
     * @param TrackEvent[] $events
     */
    public function __construct(Notification $notification = null, $trackingNumber = null, StringBarcode $barcode = null, $trackingNumberUniqueIdentifier = null, TrackStatusDetail $statusDetail = null, array $customerExceptionRequests = array(), TrackReconciliation $reconciliation = null, $serviceCommitMessage = null, $destinationServiceArea = null, $destinationServiceAreaDescription = null, $carrierCode = null, $operatingCompany = null, $operatingCompanyOrCarrierDescription = null, $cartageAgentCompanyName = null, ContactAndAddress $productionLocationContactAndAddress = null, array $otherIdentifiers = array(), $formId = null, TrackServiceDescriptionDetail $service = null, Weight $packageWeight = null, Dimensions $packageDimensions = null, Weight $packageDimensionalWeight = null, Weight $shipmentWeight = null, $packaging = null, $packagingType = null, $packageSequenceNumber = null, $packageCount = null, array $charges = array(), $nickName = null, $notes = null, array $attributes = array(), array $shipmentContents = array(), array $packageContents = array(), $clearanceLocationCode = null, array $commodities = array(), TrackReturnDetail $returnDetail = null, array $customsOptionDetails = array(), TrackAdvanceNotificationDetail $advanceNotificationDetail = null, array $specialHandlings = array(), Contact $shipper = null, $possessionStatus = null, Address $shipperAddress = null, Address $originLocationAddress = null, $originStationId = null, $estimatedPickupTimestamp = null, $shipTimestamp = null, Distance $totalTransitDistance = null, Distance $distanceToDestination = null, array $specialInstructions = array(), Contact $recipient = null, Address $lastUpdatedDestinationAddress = null, Address $destinationAddress = null, Contact $holdAtLocationContact = null, Address $holdAtLocationAddress = null, $destinationStationId = null, Address $destinationLocationAddress = null, $destinationLocationType = null, $destinationLocationTimeZoneOffset = null, $commitmentTimestamp = null, $appointmentDeliveryTimestamp = null, $estimatedDeliveryTimestamp = null, $actualDeliveryTimestamp = null, Address $actualDeliveryAddress = null, $officeOrderDeliveryMethod = null, $deliveryLocationType = null, $deliveryLocationDescription = null, $deliveryAttempts = null, $deliverySignatureName = null, array $pieceCountVerificationDetails = array(), $totalUniqueAddressCountInConsolidation = null, array $availableImages = array(), SignatureImageDetail $signature = null, array $notificationEventsAvailable = array(), array $splitShipmentParts = array(), array $deliveryOptionEligibilityDetails = array(), array $events = array())
    {
        $this
            ->setNotification($notification)
            ->setTrackingNumber($trackingNumber)
            ->setBarcode($barcode)
            ->setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier)
            ->setStatusDetail($statusDetail)
            ->setCustomerExceptionRequests($customerExceptionRequests)
            ->setReconciliation($reconciliation)
            ->setServiceCommitMessage($serviceCommitMessage)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setDestinationServiceAreaDescription($destinationServiceAreaDescription)
            ->setCarrierCode($carrierCode)
            ->setOperatingCompany($operatingCompany)
            ->setOperatingCompanyOrCarrierDescription($operatingCompanyOrCarrierDescription)
            ->setCartageAgentCompanyName($cartageAgentCompanyName)
            ->setProductionLocationContactAndAddress($productionLocationContactAndAddress)
            ->setOtherIdentifiers($otherIdentifiers)
            ->setFormId($formId)
            ->setService($service)
            ->setPackageWeight($packageWeight)
            ->setPackageDimensions($packageDimensions)
            ->setPackageDimensionalWeight($packageDimensionalWeight)
            ->setShipmentWeight($shipmentWeight)
            ->setPackaging($packaging)
            ->setPackagingType($packagingType)
            ->setPackageSequenceNumber($packageSequenceNumber)
            ->setPackageCount($packageCount)
            ->setCharges($charges)
            ->setNickName($nickName)
            ->setNotes($notes)
            ->setAttributes($attributes)
            ->setShipmentContents($shipmentContents)
            ->setPackageContents($packageContents)
            ->setClearanceLocationCode($clearanceLocationCode)
            ->setCommodities($commodities)
            ->setReturnDetail($returnDetail)
            ->setCustomsOptionDetails($customsOptionDetails)
            ->setAdvanceNotificationDetail($advanceNotificationDetail)
            ->setSpecialHandlings($specialHandlings)
            ->setShipper($shipper)
            ->setPossessionStatus($possessionStatus)
            ->setShipperAddress($shipperAddress)
            ->setOriginLocationAddress($originLocationAddress)
            ->setOriginStationId($originStationId)
            ->setEstimatedPickupTimestamp($estimatedPickupTimestamp)
            ->setShipTimestamp($shipTimestamp)
            ->setTotalTransitDistance($totalTransitDistance)
            ->setDistanceToDestination($distanceToDestination)
            ->setSpecialInstructions($specialInstructions)
            ->setRecipient($recipient)
            ->setLastUpdatedDestinationAddress($lastUpdatedDestinationAddress)
            ->setDestinationAddress($destinationAddress)
            ->setHoldAtLocationContact($holdAtLocationContact)
            ->setHoldAtLocationAddress($holdAtLocationAddress)
            ->setDestinationStationId($destinationStationId)
            ->setDestinationLocationAddress($destinationLocationAddress)
            ->setDestinationLocationType($destinationLocationType)
            ->setDestinationLocationTimeZoneOffset($destinationLocationTimeZoneOffset)
            ->setCommitmentTimestamp($commitmentTimestamp)
            ->setAppointmentDeliveryTimestamp($appointmentDeliveryTimestamp)
            ->setEstimatedDeliveryTimestamp($estimatedDeliveryTimestamp)
            ->setActualDeliveryTimestamp($actualDeliveryTimestamp)
            ->setActualDeliveryAddress($actualDeliveryAddress)
            ->setOfficeOrderDeliveryMethod($officeOrderDeliveryMethod)
            ->setDeliveryLocationType($deliveryLocationType)
            ->setDeliveryLocationDescription($deliveryLocationDescription)
            ->setDeliveryAttempts($deliveryAttempts)
            ->setDeliverySignatureName($deliverySignatureName)
            ->setPieceCountVerificationDetails($pieceCountVerificationDetails)
            ->setTotalUniqueAddressCountInConsolidation($totalUniqueAddressCountInConsolidation)
            ->setAvailableImages($availableImages)
            ->setSignature($signature)
            ->setNotificationEventsAvailable($notificationEventsAvailable)
            ->setSplitShipmentParts($splitShipmentParts)
            ->setDeliveryOptionEligibilityDetails($deliveryOptionEligibilityDetails)
            ->setEvents($events);
    }
    /**
     * Get Notification value
     * @return Notification|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param Notification $notification
     * @return TrackDetail
     */
    public function setNotification(Notification $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return TrackDetail
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get Barcode value
     * @return StringBarcode|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param StringBarcode $barcode
     * @return TrackDetail
     */
    public function setBarcode(StringBarcode $barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get TrackingNumberUniqueIdentifier value
     * @return string|null
     */
    public function getTrackingNumberUniqueIdentifier()
    {
        return $this->TrackingNumberUniqueIdentifier;
    }
    /**
     * Set TrackingNumberUniqueIdentifier value
     * @param string $trackingNumberUniqueIdentifier
     * @return TrackDetail
     */
    public function setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberUniqueIdentifier) && !is_string($trackingNumberUniqueIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumberUniqueIdentifier)), __LINE__);
        }
        $this->TrackingNumberUniqueIdentifier = $trackingNumberUniqueIdentifier;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return TrackStatusDetail|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param TrackStatusDetail $statusDetail
     * @return TrackDetail
     */
    public function setStatusDetail(TrackStatusDetail $statusDetail = null)
    {
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Get CustomerExceptionRequests value
     * @return CustomerExceptionRequestDetail[]|null
     */
    public function getCustomerExceptionRequests()
    {
        return $this->CustomerExceptionRequests;
    }
    /**
     * Set CustomerExceptionRequests value
     * @throws \InvalidArgumentException
     * @param CustomerExceptionRequestDetail[] $customerExceptionRequests
     * @return TrackDetail
     */
    public function setCustomerExceptionRequests(array $customerExceptionRequests = array())
    {
        foreach ($customerExceptionRequests as $trackDetailCustomerExceptionRequestsItem) {
            // validation for constraint: itemType
            if (!$trackDetailCustomerExceptionRequestsItem instanceof CustomerExceptionRequestDetail) {
                throw new \InvalidArgumentException(sprintf('The CustomerExceptionRequests property can only contain items of CustomerExceptionRequestDetail, "%s" given', is_object($trackDetailCustomerExceptionRequestsItem) ? get_class($trackDetailCustomerExceptionRequestsItem) : gettype($trackDetailCustomerExceptionRequestsItem)), __LINE__);
            }
        }
        $this->CustomerExceptionRequests = $customerExceptionRequests;
        return $this;
    }
    /**
     * Add item to CustomerExceptionRequests value
     * @throws \InvalidArgumentException
     * @param CustomerExceptionRequestDetail $item
     * @return TrackDetail
     */
    public function addToCustomerExceptionRequests(CustomerExceptionRequestDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CustomerExceptionRequestDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomerExceptionRequests property can only contain items of CustomerExceptionRequestDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerExceptionRequests[] = $item;
        return $this;
    }
    /**
     * Get Reconciliation value
     * @return TrackReconciliation|null
     */
    public function getReconciliation()
    {
        return $this->Reconciliation;
    }
    /**
     * Set Reconciliation value
     * @param TrackReconciliation $reconciliation
     * @return TrackDetail
     */
    public function setReconciliation(TrackReconciliation $reconciliation = null)
    {
        $this->Reconciliation = $reconciliation;
        return $this;
    }
    /**
     * Get ServiceCommitMessage value
     * @return string|null
     */
    public function getServiceCommitMessage()
    {
        return $this->ServiceCommitMessage;
    }
    /**
     * Set ServiceCommitMessage value
     * @param string $serviceCommitMessage
     * @return TrackDetail
     */
    public function setServiceCommitMessage($serviceCommitMessage = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCommitMessage) && !is_string($serviceCommitMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceCommitMessage)), __LINE__);
        }
        $this->ServiceCommitMessage = $serviceCommitMessage;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return string|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param string $destinationServiceArea
     * @return TrackDetail
     */
    public function setDestinationServiceArea($destinationServiceArea = null)
    {
        // validation for constraint: string
        if (!is_null($destinationServiceArea) && !is_string($destinationServiceArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationServiceArea)), __LINE__);
        }
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceAreaDescription value
     * @return string|null
     */
    public function getDestinationServiceAreaDescription()
    {
        return $this->DestinationServiceAreaDescription;
    }
    /**
     * Set DestinationServiceAreaDescription value
     * @param string $destinationServiceAreaDescription
     * @return TrackDetail
     */
    public function setDestinationServiceAreaDescription($destinationServiceAreaDescription = null)
    {
        // validation for constraint: string
        if (!is_null($destinationServiceAreaDescription) && !is_string($destinationServiceAreaDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationServiceAreaDescription)), __LINE__);
        }
        $this->DestinationServiceAreaDescription = $destinationServiceAreaDescription;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @uses CarrierCodeType::valueIsValid()
     * @uses CarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrierCode
     * @return TrackDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: enumeration
        if (!CarrierCodeType::valueIsValid($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $carrierCode, implode(', ', CarrierCodeType::getValidValues())), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return string|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @uses OperatingCompanyType::valueIsValid()
     * @uses OperatingCompanyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatingCompany
     * @return TrackDetail
     */
    public function setOperatingCompany($operatingCompany = null)
    {
        // validation for constraint: enumeration
        if (!OperatingCompanyType::valueIsValid($operatingCompany)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operatingCompany, implode(', ', OperatingCompanyType::getValidValues())), __LINE__);
        }
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get OperatingCompanyOrCarrierDescription value
     * @return string|null
     */
    public function getOperatingCompanyOrCarrierDescription()
    {
        return $this->OperatingCompanyOrCarrierDescription;
    }
    /**
     * Set OperatingCompanyOrCarrierDescription value
     * @param string $operatingCompanyOrCarrierDescription
     * @return TrackDetail
     */
    public function setOperatingCompanyOrCarrierDescription($operatingCompanyOrCarrierDescription = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCompanyOrCarrierDescription) && !is_string($operatingCompanyOrCarrierDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingCompanyOrCarrierDescription)), __LINE__);
        }
        $this->OperatingCompanyOrCarrierDescription = $operatingCompanyOrCarrierDescription;
        return $this;
    }
    /**
     * Get CartageAgentCompanyName value
     * @return string|null
     */
    public function getCartageAgentCompanyName()
    {
        return $this->CartageAgentCompanyName;
    }
    /**
     * Set CartageAgentCompanyName value
     * @param string $cartageAgentCompanyName
     * @return TrackDetail
     */
    public function setCartageAgentCompanyName($cartageAgentCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($cartageAgentCompanyName) && !is_string($cartageAgentCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cartageAgentCompanyName)), __LINE__);
        }
        $this->CartageAgentCompanyName = $cartageAgentCompanyName;
        return $this;
    }
    /**
     * Get ProductionLocationContactAndAddress value
     * @return ContactAndAddress|null
     */
    public function getProductionLocationContactAndAddress()
    {
        return $this->ProductionLocationContactAndAddress;
    }
    /**
     * Set ProductionLocationContactAndAddress value
     * @param ContactAndAddress $productionLocationContactAndAddress
     * @return TrackDetail
     */
    public function setProductionLocationContactAndAddress(ContactAndAddress $productionLocationContactAndAddress = null)
    {
        $this->ProductionLocationContactAndAddress = $productionLocationContactAndAddress;
        return $this;
    }
    /**
     * Get OtherIdentifiers value
     * @return TrackOtherIdentifierDetail[]|null
     */
    public function getOtherIdentifiers()
    {
        return $this->OtherIdentifiers;
    }
    /**
     * Set OtherIdentifiers value
     * @throws \InvalidArgumentException
     * @param TrackOtherIdentifierDetail[] $otherIdentifiers
     * @return TrackDetail
     */
    public function setOtherIdentifiers(array $otherIdentifiers = array())
    {
        foreach ($otherIdentifiers as $trackDetailOtherIdentifiersItem) {
            // validation for constraint: itemType
            if (!$trackDetailOtherIdentifiersItem instanceof TrackOtherIdentifierDetail) {
                throw new \InvalidArgumentException(sprintf('The OtherIdentifiers property can only contain items of TrackOtherIdentifierDetail, "%s" given', is_object($trackDetailOtherIdentifiersItem) ? get_class($trackDetailOtherIdentifiersItem) : gettype($trackDetailOtherIdentifiersItem)), __LINE__);
            }
        }
        $this->OtherIdentifiers = $otherIdentifiers;
        return $this;
    }
    /**
     * Add item to OtherIdentifiers value
     * @throws \InvalidArgumentException
     * @param TrackOtherIdentifierDetail $item
     * @return TrackDetail
     */
    public function addToOtherIdentifiers(TrackOtherIdentifierDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackOtherIdentifierDetail) {
            throw new \InvalidArgumentException(sprintf('The OtherIdentifiers property can only contain items of TrackOtherIdentifierDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherIdentifiers[] = $item;
        return $this;
    }
    /**
     * Get FormId value
     * @return string|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param string $formId
     * @return TrackDetail
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: string
        if (!is_null($formId) && !is_string($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get Service value
     * @return TrackServiceDescriptionDetail|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param TrackServiceDescriptionDetail $service
     * @return TrackDetail
     */
    public function setService(TrackServiceDescriptionDetail $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return Weight|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param Weight $packageWeight
     * @return TrackDetail
     */
    public function setPackageWeight(Weight $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get PackageDimensions value
     * @return Dimensions|null
     */
    public function getPackageDimensions()
    {
        return $this->PackageDimensions;
    }
    /**
     * Set PackageDimensions value
     * @param Dimensions $packageDimensions
     * @return TrackDetail
     */
    public function setPackageDimensions(Dimensions $packageDimensions = null)
    {
        $this->PackageDimensions = $packageDimensions;
        return $this;
    }
    /**
     * Get PackageDimensionalWeight value
     * @return Weight|null
     */
    public function getPackageDimensionalWeight()
    {
        return $this->PackageDimensionalWeight;
    }
    /**
     * Set PackageDimensionalWeight value
     * @param Weight $packageDimensionalWeight
     * @return TrackDetail
     */
    public function setPackageDimensionalWeight(Weight $packageDimensionalWeight = null)
    {
        $this->PackageDimensionalWeight = $packageDimensionalWeight;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return Weight|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param Weight $shipmentWeight
     * @return TrackDetail
     */
    public function setShipmentWeight(Weight $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get Packaging value
     * @return string|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param string $packaging
     * @return TrackDetail
     */
    public function setPackaging($packaging = null)
    {
        // validation for constraint: string
        if (!is_null($packaging) && !is_string($packaging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packaging)), __LINE__);
        }
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get PackagingType value
     * @return string|null
     */
    public function getPackagingType()
    {
        return $this->PackagingType;
    }
    /**
     * Set PackagingType value
     * @uses PackagingType::valueIsValid()
     * @uses PackagingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packagingType
     * @return TrackDetail
     */
    public function setPackagingType($packagingType = null)
    {
        // validation for constraint: enumeration
        if (!PackagingType::valueIsValid($packagingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packagingType, implode(', ', PackagingType::getValidValues())), __LINE__);
        }
        $this->PackagingType = $packagingType;
        return $this;
    }
    /**
     * Get PackageSequenceNumber value
     * @return int|null
     */
    public function getPackageSequenceNumber()
    {
        return $this->PackageSequenceNumber;
    }
    /**
     * Set PackageSequenceNumber value
     * @param int $packageSequenceNumber
     * @return TrackDetail
     */
    public function setPackageSequenceNumber($packageSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($packageSequenceNumber) && !is_numeric($packageSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSequenceNumber)), __LINE__);
        }
        $this->PackageSequenceNumber = $packageSequenceNumber;
        return $this;
    }
    /**
     * Get PackageCount value
     * @return int|null
     */
    public function getPackageCount()
    {
        return $this->PackageCount;
    }
    /**
     * Set PackageCount value
     * @param int $packageCount
     * @return TrackDetail
     */
    public function setPackageCount($packageCount = null)
    {
        // validation for constraint: int
        if (!is_null($packageCount) && !is_numeric($packageCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageCount)), __LINE__);
        }
        $this->PackageCount = $packageCount;
        return $this;
    }
    /**
     * Get Charges value
     * @return TrackChargeDetail[]|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @throws \InvalidArgumentException
     * @param TrackChargeDetail[] $charges
     * @return TrackDetail
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $trackDetailChargesItem) {
            // validation for constraint: itemType
            if (!$trackDetailChargesItem instanceof TrackChargeDetail) {
                throw new \InvalidArgumentException(sprintf('The Charges property can only contain items of TrackChargeDetail, "%s" given', is_object($trackDetailChargesItem) ? get_class($trackDetailChargesItem) : gettype($trackDetailChargesItem)), __LINE__);
            }
        }
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Add item to Charges value
     * @throws \InvalidArgumentException
     * @param TrackChargeDetail $item
     * @return TrackDetail
     */
    public function addToCharges(TrackChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The Charges property can only contain items of TrackChargeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Charges[] = $item;
        return $this;
    }
    /**
     * Get NickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->NickName;
    }
    /**
     * Set NickName value
     * @param string $nickName
     * @return TrackDetail
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nickName)), __LINE__);
        }
        $this->NickName = $nickName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return TrackDetail
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Attributes value
     * @return string[]|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @uses TrackDetailAttributeType::valueIsValid()
     * @uses TrackDetailAttributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $attributes
     * @return TrackDetail
     */
    public function setAttributes(array $attributes = array())
    {
        $invalidValues = array();
        foreach ($attributes as $trackDetailAttributesItem) {
            if (!TrackDetailAttributeType::valueIsValid($trackDetailAttributesItem)) {
                $invalidValues[] = var_export($trackDetailAttributesItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', TrackDetailAttributeType::getValidValues())), __LINE__);
        }
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Add item to Attributes value
     * @uses TrackDetailAttributeType::valueIsValid()
     * @uses TrackDetailAttributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return TrackDetail
     */
    public function addToAttributes($item)
    {
        // validation for constraint: enumeration
        if (!TrackDetailAttributeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', TrackDetailAttributeType::getValidValues())), __LINE__);
        }
        $this->Attributes[] = $item;
        return $this;
    }
    /**
     * Get ShipmentContents value
     * @return ContentRecord[]|null
     */
    public function getShipmentContents()
    {
        return $this->ShipmentContents;
    }
    /**
     * Set ShipmentContents value
     * @throws \InvalidArgumentException
     * @param ContentRecord[] $shipmentContents
     * @return TrackDetail
     */
    public function setShipmentContents(array $shipmentContents = array())
    {
        foreach ($shipmentContents as $trackDetailShipmentContentsItem) {
            // validation for constraint: itemType
            if (!$trackDetailShipmentContentsItem instanceof ContentRecord) {
                throw new \InvalidArgumentException(sprintf('The ShipmentContents property can only contain items of ContentRecord, "%s" given', is_object($trackDetailShipmentContentsItem) ? get_class($trackDetailShipmentContentsItem) : gettype($trackDetailShipmentContentsItem)), __LINE__);
            }
        }
        $this->ShipmentContents = $shipmentContents;
        return $this;
    }
    /**
     * Add item to ShipmentContents value
     * @throws \InvalidArgumentException
     * @param ContentRecord $item
     * @return TrackDetail
     */
    public function addToShipmentContents(ContentRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ContentRecord) {
            throw new \InvalidArgumentException(sprintf('The ShipmentContents property can only contain items of ContentRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentContents[] = $item;
        return $this;
    }
    /**
     * Get PackageContents value
     * @return string[]|null
     */
    public function getPackageContents()
    {
        return $this->PackageContents;
    }
    /**
     * Set PackageContents value
     * @throws \InvalidArgumentException
     * @param string[] $packageContents
     * @return TrackDetail
     */
    public function setPackageContents(array $packageContents = array())
    {
        foreach ($packageContents as $trackDetailPackageContentsItem) {
            // validation for constraint: itemType
            if (!is_string($trackDetailPackageContentsItem)) {
                throw new \InvalidArgumentException(sprintf('The PackageContents property can only contain items of string, "%s" given', is_object($trackDetailPackageContentsItem) ? get_class($trackDetailPackageContentsItem) : gettype($trackDetailPackageContentsItem)), __LINE__);
            }
        }
        $this->PackageContents = $packageContents;
        return $this;
    }
    /**
     * Add item to PackageContents value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return TrackDetail
     */
    public function addToPackageContents($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PackageContents property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PackageContents[] = $item;
        return $this;
    }
    /**
     * Get ClearanceLocationCode value
     * @return string|null
     */
    public function getClearanceLocationCode()
    {
        return $this->ClearanceLocationCode;
    }
    /**
     * Set ClearanceLocationCode value
     * @param string $clearanceLocationCode
     * @return TrackDetail
     */
    public function setClearanceLocationCode($clearanceLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($clearanceLocationCode) && !is_string($clearanceLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clearanceLocationCode)), __LINE__);
        }
        $this->ClearanceLocationCode = $clearanceLocationCode;
        return $this;
    }
    /**
     * Get Commodities value
     * @return Commodity[]|null
     */
    public function getCommodities()
    {
        return $this->Commodities;
    }
    /**
     * Set Commodities value
     * @throws \InvalidArgumentException
     * @param Commodity[] $commodities
     * @return TrackDetail
     */
    public function setCommodities(array $commodities = array())
    {
        foreach ($commodities as $trackDetailCommoditiesItem) {
            // validation for constraint: itemType
            if (!$trackDetailCommoditiesItem instanceof Commodity) {
                throw new \InvalidArgumentException(sprintf('The Commodities property can only contain items of Commodity, "%s" given', is_object($trackDetailCommoditiesItem) ? get_class($trackDetailCommoditiesItem) : gettype($trackDetailCommoditiesItem)), __LINE__);
            }
        }
        $this->Commodities = $commodities;
        return $this;
    }
    /**
     * Add item to Commodities value
     * @throws \InvalidArgumentException
     * @param Commodity $item
     * @return TrackDetail
     */
    public function addToCommodities(Commodity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Commodity) {
            throw new \InvalidArgumentException(sprintf('The Commodities property can only contain items of Commodity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Commodities[] = $item;
        return $this;
    }
    /**
     * Get ReturnDetail value
     * @return TrackReturnDetail|null
     */
    public function getReturnDetail()
    {
        return $this->ReturnDetail;
    }
    /**
     * Set ReturnDetail value
     * @param TrackReturnDetail $returnDetail
     * @return TrackDetail
     */
    public function setReturnDetail(TrackReturnDetail $returnDetail = null)
    {
        $this->ReturnDetail = $returnDetail;
        return $this;
    }
    /**
     * Get CustomsOptionDetails value
     * @return CustomsOptionDetail[]|null
     */
    public function getCustomsOptionDetails()
    {
        return $this->CustomsOptionDetails;
    }
    /**
     * Set CustomsOptionDetails value
     * @throws \InvalidArgumentException
     * @param CustomsOptionDetail[] $customsOptionDetails
     * @return TrackDetail
     */
    public function setCustomsOptionDetails(array $customsOptionDetails = array())
    {
        foreach ($customsOptionDetails as $trackDetailCustomsOptionDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailCustomsOptionDetailsItem instanceof CustomsOptionDetail) {
                throw new \InvalidArgumentException(sprintf('The CustomsOptionDetails property can only contain items of CustomsOptionDetail, "%s" given', is_object($trackDetailCustomsOptionDetailsItem) ? get_class($trackDetailCustomsOptionDetailsItem) : gettype($trackDetailCustomsOptionDetailsItem)), __LINE__);
            }
        }
        $this->CustomsOptionDetails = $customsOptionDetails;
        return $this;
    }
    /**
     * Add item to CustomsOptionDetails value
     * @throws \InvalidArgumentException
     * @param CustomsOptionDetail $item
     * @return TrackDetail
     */
    public function addToCustomsOptionDetails(CustomsOptionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CustomsOptionDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomsOptionDetails property can only contain items of CustomsOptionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomsOptionDetails[] = $item;
        return $this;
    }
    /**
     * Get AdvanceNotificationDetail value
     * @return TrackAdvanceNotificationDetail|null
     */
    public function getAdvanceNotificationDetail()
    {
        return $this->AdvanceNotificationDetail;
    }
    /**
     * Set AdvanceNotificationDetail value
     * @param TrackAdvanceNotificationDetail $advanceNotificationDetail
     * @return TrackDetail
     */
    public function setAdvanceNotificationDetail(TrackAdvanceNotificationDetail $advanceNotificationDetail = null)
    {
        $this->AdvanceNotificationDetail = $advanceNotificationDetail;
        return $this;
    }
    /**
     * Get SpecialHandlings value
     * @return TrackSpecialHandling[]|null
     */
    public function getSpecialHandlings()
    {
        return $this->SpecialHandlings;
    }
    /**
     * Set SpecialHandlings value
     * @throws \InvalidArgumentException
     * @param TrackSpecialHandling[] $specialHandlings
     * @return TrackDetail
     */
    public function setSpecialHandlings(array $specialHandlings = array())
    {
        foreach ($specialHandlings as $trackDetailSpecialHandlingsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSpecialHandlingsItem instanceof TrackSpecialHandling) {
                throw new \InvalidArgumentException(sprintf('The SpecialHandlings property can only contain items of TrackSpecialHandling, "%s" given', is_object($trackDetailSpecialHandlingsItem) ? get_class($trackDetailSpecialHandlingsItem) : gettype($trackDetailSpecialHandlingsItem)), __LINE__);
            }
        }
        $this->SpecialHandlings = $specialHandlings;
        return $this;
    }
    /**
     * Add item to SpecialHandlings value
     * @throws \InvalidArgumentException
     * @param TrackSpecialHandling $item
     * @return TrackDetail
     */
    public function addToSpecialHandlings(TrackSpecialHandling $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackSpecialHandling) {
            throw new \InvalidArgumentException(sprintf('The SpecialHandlings property can only contain items of TrackSpecialHandling, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialHandlings[] = $item;
        return $this;
    }
    /**
     * Get Shipper value
     * @return Contact|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param Contact $shipper
     * @return TrackDetail
     */
    public function setShipper(Contact $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get PossessionStatus value
     * @return string|null
     */
    public function getPossessionStatus()
    {
        return $this->PossessionStatus;
    }
    /**
     * Set PossessionStatus value
     * @uses TrackPossessionStatusType::valueIsValid()
     * @uses TrackPossessionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $possessionStatus
     * @return TrackDetail
     */
    public function setPossessionStatus($possessionStatus = null)
    {
        // validation for constraint: enumeration
        if (!TrackPossessionStatusType::valueIsValid($possessionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $possessionStatus, implode(', ', TrackPossessionStatusType::getValidValues())), __LINE__);
        }
        $this->PossessionStatus = $possessionStatus;
        return $this;
    }
    /**
     * Get ShipperAddress value
     * @return Address|null
     */
    public function getShipperAddress()
    {
        return $this->ShipperAddress;
    }
    /**
     * Set ShipperAddress value
     * @param Address $shipperAddress
     * @return TrackDetail
     */
    public function setShipperAddress(Address $shipperAddress = null)
    {
        $this->ShipperAddress = $shipperAddress;
        return $this;
    }
    /**
     * Get OriginLocationAddress value
     * @return Address|null
     */
    public function getOriginLocationAddress()
    {
        return $this->OriginLocationAddress;
    }
    /**
     * Set OriginLocationAddress value
     * @param Address $originLocationAddress
     * @return TrackDetail
     */
    public function setOriginLocationAddress(Address $originLocationAddress = null)
    {
        $this->OriginLocationAddress = $originLocationAddress;
        return $this;
    }
    /**
     * Get OriginStationId value
     * @return string|null
     */
    public function getOriginStationId()
    {
        return $this->OriginStationId;
    }
    /**
     * Set OriginStationId value
     * @param string $originStationId
     * @return TrackDetail
     */
    public function setOriginStationId($originStationId = null)
    {
        // validation for constraint: string
        if (!is_null($originStationId) && !is_string($originStationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originStationId)), __LINE__);
        }
        $this->OriginStationId = $originStationId;
        return $this;
    }
    /**
     * Get EstimatedPickupTimestamp value
     * @return string|null
     */
    public function getEstimatedPickupTimestamp()
    {
        return $this->EstimatedPickupTimestamp;
    }
    /**
     * Set EstimatedPickupTimestamp value
     * @param string $estimatedPickupTimestamp
     * @return TrackDetail
     */
    public function setEstimatedPickupTimestamp($estimatedPickupTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedPickupTimestamp) && !is_string($estimatedPickupTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedPickupTimestamp)), __LINE__);
        }
        $this->EstimatedPickupTimestamp = $estimatedPickupTimestamp;
        return $this;
    }
    /**
     * Get ShipTimestamp value
     * @return string|null
     */
    public function getShipTimestamp()
    {
        return $this->ShipTimestamp;
    }
    /**
     * Set ShipTimestamp value
     * @param string $shipTimestamp
     * @return TrackDetail
     */
    public function setShipTimestamp($shipTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($shipTimestamp) && !is_string($shipTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipTimestamp)), __LINE__);
        }
        $this->ShipTimestamp = $shipTimestamp;
        return $this;
    }
    /**
     * Get TotalTransitDistance value
     * @return Distance|null
     */
    public function getTotalTransitDistance()
    {
        return $this->TotalTransitDistance;
    }
    /**
     * Set TotalTransitDistance value
     * @param Distance $totalTransitDistance
     * @return TrackDetail
     */
    public function setTotalTransitDistance(Distance $totalTransitDistance = null)
    {
        $this->TotalTransitDistance = $totalTransitDistance;
        return $this;
    }
    /**
     * Get DistanceToDestination value
     * @return Distance|null
     */
    public function getDistanceToDestination()
    {
        return $this->DistanceToDestination;
    }
    /**
     * Set DistanceToDestination value
     * @param Distance $distanceToDestination
     * @return TrackDetail
     */
    public function setDistanceToDestination(Distance $distanceToDestination = null)
    {
        $this->DistanceToDestination = $distanceToDestination;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return TrackSpecialInstruction[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * Set SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param TrackSpecialInstruction[] $specialInstructions
     * @return TrackDetail
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        foreach ($specialInstructions as $trackDetailSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSpecialInstructionsItem instanceof TrackSpecialInstruction) {
                throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of TrackSpecialInstruction, "%s" given', is_object($trackDetailSpecialInstructionsItem) ? get_class($trackDetailSpecialInstructionsItem) : gettype($trackDetailSpecialInstructionsItem)), __LINE__);
            }
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param TrackSpecialInstruction $item
     * @return TrackDetail
     */
    public function addToSpecialInstructions(TrackSpecialInstruction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackSpecialInstruction) {
            throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of TrackSpecialInstruction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get Recipient value
     * @return Contact|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param Contact $recipient
     * @return TrackDetail
     */
    public function setRecipient(Contact $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get LastUpdatedDestinationAddress value
     * @return Address|null
     */
    public function getLastUpdatedDestinationAddress()
    {
        return $this->LastUpdatedDestinationAddress;
    }
    /**
     * Set LastUpdatedDestinationAddress value
     * @param Address $lastUpdatedDestinationAddress
     * @return TrackDetail
     */
    public function setLastUpdatedDestinationAddress(Address $lastUpdatedDestinationAddress = null)
    {
        $this->LastUpdatedDestinationAddress = $lastUpdatedDestinationAddress;
        return $this;
    }
    /**
     * Get DestinationAddress value
     * @return Address|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param Address $destinationAddress
     * @return TrackDetail
     */
    public function setDestinationAddress(Address $destinationAddress = null)
    {
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get HoldAtLocationContact value
     * @return Contact|null
     */
    public function getHoldAtLocationContact()
    {
        return $this->HoldAtLocationContact;
    }
    /**
     * Set HoldAtLocationContact value
     * @param Contact $holdAtLocationContact
     * @return TrackDetail
     */
    public function setHoldAtLocationContact(Contact $holdAtLocationContact = null)
    {
        $this->HoldAtLocationContact = $holdAtLocationContact;
        return $this;
    }
    /**
     * Get HoldAtLocationAddress value
     * @return Address|null
     */
    public function getHoldAtLocationAddress()
    {
        return $this->HoldAtLocationAddress;
    }
    /**
     * Set HoldAtLocationAddress value
     * @param Address $holdAtLocationAddress
     * @return TrackDetail
     */
    public function setHoldAtLocationAddress(Address $holdAtLocationAddress = null)
    {
        $this->HoldAtLocationAddress = $holdAtLocationAddress;
        return $this;
    }
    /**
     * Get DestinationStationId value
     * @return string|null
     */
    public function getDestinationStationId()
    {
        return $this->DestinationStationId;
    }
    /**
     * Set DestinationStationId value
     * @param string $destinationStationId
     * @return TrackDetail
     */
    public function setDestinationStationId($destinationStationId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationStationId) && !is_string($destinationStationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationStationId)), __LINE__);
        }
        $this->DestinationStationId = $destinationStationId;
        return $this;
    }
    /**
     * Get DestinationLocationAddress value
     * @return Address|null
     */
    public function getDestinationLocationAddress()
    {
        return $this->DestinationLocationAddress;
    }
    /**
     * Set DestinationLocationAddress value
     * @param Address $destinationLocationAddress
     * @return TrackDetail
     */
    public function setDestinationLocationAddress(Address $destinationLocationAddress = null)
    {
        $this->DestinationLocationAddress = $destinationLocationAddress;
        return $this;
    }
    /**
     * Get DestinationLocationType value
     * @return string|null
     */
    public function getDestinationLocationType()
    {
        return $this->DestinationLocationType;
    }
    /**
     * Set DestinationLocationType value
     * @uses FedExLocationType::valueIsValid()
     * @uses FedExLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationLocationType
     * @return TrackDetail
     */
    public function setDestinationLocationType($destinationLocationType = null)
    {
        // validation for constraint: enumeration
        if (!FedExLocationType::valueIsValid($destinationLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $destinationLocationType, implode(', ', FedExLocationType::getValidValues())), __LINE__);
        }
        $this->DestinationLocationType = $destinationLocationType;
        return $this;
    }
    /**
     * Get DestinationLocationTimeZoneOffset value
     * @return string|null
     */
    public function getDestinationLocationTimeZoneOffset()
    {
        return $this->DestinationLocationTimeZoneOffset;
    }
    /**
     * Set DestinationLocationTimeZoneOffset value
     * @param string $destinationLocationTimeZoneOffset
     * @return TrackDetail
     */
    public function setDestinationLocationTimeZoneOffset($destinationLocationTimeZoneOffset = null)
    {
        // validation for constraint: string
        if (!is_null($destinationLocationTimeZoneOffset) && !is_string($destinationLocationTimeZoneOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationLocationTimeZoneOffset)), __LINE__);
        }
        $this->DestinationLocationTimeZoneOffset = $destinationLocationTimeZoneOffset;
        return $this;
    }
    /**
     * Get CommitmentTimestamp value
     * @return string|null
     */
    public function getCommitmentTimestamp()
    {
        return $this->CommitmentTimestamp;
    }
    /**
     * Set CommitmentTimestamp value
     * @param string $commitmentTimestamp
     * @return TrackDetail
     */
    public function setCommitmentTimestamp($commitmentTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($commitmentTimestamp) && !is_string($commitmentTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commitmentTimestamp)), __LINE__);
        }
        $this->CommitmentTimestamp = $commitmentTimestamp;
        return $this;
    }
    /**
     * Get AppointmentDeliveryTimestamp value
     * @return string|null
     */
    public function getAppointmentDeliveryTimestamp()
    {
        return $this->AppointmentDeliveryTimestamp;
    }
    /**
     * Set AppointmentDeliveryTimestamp value
     * @param string $appointmentDeliveryTimestamp
     * @return TrackDetail
     */
    public function setAppointmentDeliveryTimestamp($appointmentDeliveryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentDeliveryTimestamp) && !is_string($appointmentDeliveryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentDeliveryTimestamp)), __LINE__);
        }
        $this->AppointmentDeliveryTimestamp = $appointmentDeliveryTimestamp;
        return $this;
    }
    /**
     * Get EstimatedDeliveryTimestamp value
     * @return string|null
     */
    public function getEstimatedDeliveryTimestamp()
    {
        return $this->EstimatedDeliveryTimestamp;
    }
    /**
     * Set EstimatedDeliveryTimestamp value
     * @param string $estimatedDeliveryTimestamp
     * @return TrackDetail
     */
    public function setEstimatedDeliveryTimestamp($estimatedDeliveryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryTimestamp) && !is_string($estimatedDeliveryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDeliveryTimestamp)), __LINE__);
        }
        $this->EstimatedDeliveryTimestamp = $estimatedDeliveryTimestamp;
        return $this;
    }
    /**
     * Get ActualDeliveryTimestamp value
     * @return string|null
     */
    public function getActualDeliveryTimestamp()
    {
        return $this->ActualDeliveryTimestamp;
    }
    /**
     * Set ActualDeliveryTimestamp value
     * @param string $actualDeliveryTimestamp
     * @return TrackDetail
     */
    public function setActualDeliveryTimestamp($actualDeliveryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($actualDeliveryTimestamp) && !is_string($actualDeliveryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDeliveryTimestamp)), __LINE__);
        }
        $this->ActualDeliveryTimestamp = $actualDeliveryTimestamp;
        return $this;
    }
    /**
     * Get ActualDeliveryAddress value
     * @return Address|null
     */
    public function getActualDeliveryAddress()
    {
        return $this->ActualDeliveryAddress;
    }
    /**
     * Set ActualDeliveryAddress value
     * @param Address $actualDeliveryAddress
     * @return TrackDetail
     */
    public function setActualDeliveryAddress(Address $actualDeliveryAddress = null)
    {
        $this->ActualDeliveryAddress = $actualDeliveryAddress;
        return $this;
    }
    /**
     * Get OfficeOrderDeliveryMethod value
     * @return string|null
     */
    public function getOfficeOrderDeliveryMethod()
    {
        return $this->OfficeOrderDeliveryMethod;
    }
    /**
     * Set OfficeOrderDeliveryMethod value
     * @uses OfficeOrderDeliveryMethodType::valueIsValid()
     * @uses OfficeOrderDeliveryMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeOrderDeliveryMethod
     * @return TrackDetail
     */
    public function setOfficeOrderDeliveryMethod($officeOrderDeliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!OfficeOrderDeliveryMethodType::valueIsValid($officeOrderDeliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeOrderDeliveryMethod, implode(', ', OfficeOrderDeliveryMethodType::getValidValues())), __LINE__);
        }
        $this->OfficeOrderDeliveryMethod = $officeOrderDeliveryMethod;
        return $this;
    }
    /**
     * Get DeliveryLocationType value
     * @return string|null
     */
    public function getDeliveryLocationType()
    {
        return $this->DeliveryLocationType;
    }
    /**
     * Set DeliveryLocationType value
     * @uses TrackDeliveryLocationType::valueIsValid()
     * @uses TrackDeliveryLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryLocationType
     * @return TrackDetail
     */
    public function setDeliveryLocationType($deliveryLocationType = null)
    {
        // validation for constraint: enumeration
        if (!TrackDeliveryLocationType::valueIsValid($deliveryLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryLocationType, implode(', ', TrackDeliveryLocationType::getValidValues())), __LINE__);
        }
        $this->DeliveryLocationType = $deliveryLocationType;
        return $this;
    }
    /**
     * Get DeliveryLocationDescription value
     * @return string|null
     */
    public function getDeliveryLocationDescription()
    {
        return $this->DeliveryLocationDescription;
    }
    /**
     * Set DeliveryLocationDescription value
     * @param string $deliveryLocationDescription
     * @return TrackDetail
     */
    public function setDeliveryLocationDescription($deliveryLocationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryLocationDescription) && !is_string($deliveryLocationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryLocationDescription)), __LINE__);
        }
        $this->DeliveryLocationDescription = $deliveryLocationDescription;
        return $this;
    }
    /**
     * Get DeliveryAttempts value
     * @return int|null
     */
    public function getDeliveryAttempts()
    {
        return $this->DeliveryAttempts;
    }
    /**
     * Set DeliveryAttempts value
     * @param int $deliveryAttempts
     * @return TrackDetail
     */
    public function setDeliveryAttempts($deliveryAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryAttempts) && !is_numeric($deliveryAttempts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryAttempts)), __LINE__);
        }
        $this->DeliveryAttempts = $deliveryAttempts;
        return $this;
    }
    /**
     * Get DeliverySignatureName value
     * @return string|null
     */
    public function getDeliverySignatureName()
    {
        return $this->DeliverySignatureName;
    }
    /**
     * Set DeliverySignatureName value
     * @param string $deliverySignatureName
     * @return TrackDetail
     */
    public function setDeliverySignatureName($deliverySignatureName = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySignatureName) && !is_string($deliverySignatureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliverySignatureName)), __LINE__);
        }
        $this->DeliverySignatureName = $deliverySignatureName;
        return $this;
    }
    /**
     * Get PieceCountVerificationDetails value
     * @return PieceCountVerificationDetail[]|null
     */
    public function getPieceCountVerificationDetails()
    {
        return $this->PieceCountVerificationDetails;
    }
    /**
     * Set PieceCountVerificationDetails value
     * @throws \InvalidArgumentException
     * @param PieceCountVerificationDetail[] $pieceCountVerificationDetails
     * @return TrackDetail
     */
    public function setPieceCountVerificationDetails(array $pieceCountVerificationDetails = array())
    {
        foreach ($pieceCountVerificationDetails as $trackDetailPieceCountVerificationDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailPieceCountVerificationDetailsItem instanceof PieceCountVerificationDetail) {
                throw new \InvalidArgumentException(sprintf('The PieceCountVerificationDetails property can only contain items of PieceCountVerificationDetail, "%s" given', is_object($trackDetailPieceCountVerificationDetailsItem) ? get_class($trackDetailPieceCountVerificationDetailsItem) : gettype($trackDetailPieceCountVerificationDetailsItem)), __LINE__);
            }
        }
        $this->PieceCountVerificationDetails = $pieceCountVerificationDetails;
        return $this;
    }
    /**
     * Add item to PieceCountVerificationDetails value
     * @throws \InvalidArgumentException
     * @param PieceCountVerificationDetail $item
     * @return TrackDetail
     */
    public function addToPieceCountVerificationDetails(PieceCountVerificationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PieceCountVerificationDetail) {
            throw new \InvalidArgumentException(sprintf('The PieceCountVerificationDetails property can only contain items of PieceCountVerificationDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PieceCountVerificationDetails[] = $item;
        return $this;
    }
    /**
     * Get TotalUniqueAddressCountInConsolidation value
     * @return int|null
     */
    public function getTotalUniqueAddressCountInConsolidation()
    {
        return $this->TotalUniqueAddressCountInConsolidation;
    }
    /**
     * Set TotalUniqueAddressCountInConsolidation value
     * @param int $totalUniqueAddressCountInConsolidation
     * @return TrackDetail
     */
    public function setTotalUniqueAddressCountInConsolidation($totalUniqueAddressCountInConsolidation = null)
    {
        // validation for constraint: int
        if (!is_null($totalUniqueAddressCountInConsolidation) && !is_numeric($totalUniqueAddressCountInConsolidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalUniqueAddressCountInConsolidation)), __LINE__);
        }
        $this->TotalUniqueAddressCountInConsolidation = $totalUniqueAddressCountInConsolidation;
        return $this;
    }
    /**
     * Get AvailableImages value
     * @return string[]|null
     */
    public function getAvailableImages()
    {
        return $this->AvailableImages;
    }
    /**
     * Set AvailableImages value
     * @uses AvailableImageType::valueIsValid()
     * @uses AvailableImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $availableImages
     * @return TrackDetail
     */
    public function setAvailableImages(array $availableImages = array())
    {
        $invalidValues = array();
        foreach ($availableImages as $trackDetailAvailableImagesItem) {
            if (!AvailableImageType::valueIsValid($trackDetailAvailableImagesItem)) {
                $invalidValues[] = var_export($trackDetailAvailableImagesItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', AvailableImageType::getValidValues())), __LINE__);
        }
        $this->AvailableImages = $availableImages;
        return $this;
    }
    /**
     * Add item to AvailableImages value
     * @uses AvailableImageType::valueIsValid()
     * @uses AvailableImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return TrackDetail
     */
    public function addToAvailableImages($item)
    {
        // validation for constraint: enumeration
        if (!AvailableImageType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', AvailableImageType::getValidValues())), __LINE__);
        }
        $this->AvailableImages[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return SignatureImageDetail|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param SignatureImageDetail $signature
     * @return TrackDetail
     */
    public function setSignature(SignatureImageDetail $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get NotificationEventsAvailable value
     * @return string[]|null
     */
    public function getNotificationEventsAvailable()
    {
        return $this->NotificationEventsAvailable;
    }
    /**
     * Set NotificationEventsAvailable value
     * @uses EMailNotificationEventType::valueIsValid()
     * @uses EMailNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $notificationEventsAvailable
     * @return TrackDetail
     */
    public function setNotificationEventsAvailable(array $notificationEventsAvailable = array())
    {
        $invalidValues = array();
        foreach ($notificationEventsAvailable as $trackDetailNotificationEventsAvailableItem) {
            if (!EMailNotificationEventType::valueIsValid($trackDetailNotificationEventsAvailableItem)) {
                $invalidValues[] = var_export($trackDetailNotificationEventsAvailableItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', EMailNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsAvailable = $notificationEventsAvailable;
        return $this;
    }
    /**
     * Add item to NotificationEventsAvailable value
     * @uses EMailNotificationEventType::valueIsValid()
     * @uses EMailNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return TrackDetail
     */
    public function addToNotificationEventsAvailable($item)
    {
        // validation for constraint: enumeration
        if (!EMailNotificationEventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', EMailNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsAvailable[] = $item;
        return $this;
    }
    /**
     * Get SplitShipmentParts value
     * @return TrackSplitShipmentPart[]|null
     */
    public function getSplitShipmentParts()
    {
        return $this->SplitShipmentParts;
    }
    /**
     * Set SplitShipmentParts value
     * @throws \InvalidArgumentException
     * @param TrackSplitShipmentPart[] $splitShipmentParts
     * @return TrackDetail
     */
    public function setSplitShipmentParts(array $splitShipmentParts = array())
    {
        foreach ($splitShipmentParts as $trackDetailSplitShipmentPartsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSplitShipmentPartsItem instanceof TrackSplitShipmentPart) {
                throw new \InvalidArgumentException(sprintf('The SplitShipmentParts property can only contain items of TrackSplitShipmentPart, "%s" given', is_object($trackDetailSplitShipmentPartsItem) ? get_class($trackDetailSplitShipmentPartsItem) : gettype($trackDetailSplitShipmentPartsItem)), __LINE__);
            }
        }
        $this->SplitShipmentParts = $splitShipmentParts;
        return $this;
    }
    /**
     * Add item to SplitShipmentParts value
     * @throws \InvalidArgumentException
     * @param TrackSplitShipmentPart $item
     * @return TrackDetail
     */
    public function addToSplitShipmentParts(TrackSplitShipmentPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackSplitShipmentPart) {
            throw new \InvalidArgumentException(sprintf('The SplitShipmentParts property can only contain items of TrackSplitShipmentPart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SplitShipmentParts[] = $item;
        return $this;
    }
    /**
     * Get DeliveryOptionEligibilityDetails value
     * @return DeliveryOptionEligibilityDetail[]|null
     */
    public function getDeliveryOptionEligibilityDetails()
    {
        return $this->DeliveryOptionEligibilityDetails;
    }
    /**
     * Set DeliveryOptionEligibilityDetails value
     * @throws \InvalidArgumentException
     * @param DeliveryOptionEligibilityDetail[] $deliveryOptionEligibilityDetails
     * @return TrackDetail
     */
    public function setDeliveryOptionEligibilityDetails(array $deliveryOptionEligibilityDetails = array())
    {
        foreach ($deliveryOptionEligibilityDetails as $trackDetailDeliveryOptionEligibilityDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailDeliveryOptionEligibilityDetailsItem instanceof DeliveryOptionEligibilityDetail) {
                throw new \InvalidArgumentException(sprintf('The DeliveryOptionEligibilityDetails property can only contain items of DeliveryOptionEligibilityDetail, "%s" given', is_object($trackDetailDeliveryOptionEligibilityDetailsItem) ? get_class($trackDetailDeliveryOptionEligibilityDetailsItem) : gettype($trackDetailDeliveryOptionEligibilityDetailsItem)), __LINE__);
            }
        }
        $this->DeliveryOptionEligibilityDetails = $deliveryOptionEligibilityDetails;
        return $this;
    }
    /**
     * Add item to DeliveryOptionEligibilityDetails value
     * @throws \InvalidArgumentException
     * @param DeliveryOptionEligibilityDetail $item
     * @return TrackDetail
     */
    public function addToDeliveryOptionEligibilityDetails(DeliveryOptionEligibilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DeliveryOptionEligibilityDetail) {
            throw new \InvalidArgumentException(sprintf('The DeliveryOptionEligibilityDetails property can only contain items of DeliveryOptionEligibilityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryOptionEligibilityDetails[] = $item;
        return $this;
    }
    /**
     * Get Events value
     * @return TrackEvent[]|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @throws \InvalidArgumentException
     * @param TrackEvent[] $events
     * @return TrackDetail
     */
    public function setEvents(array $events = array())
    {
        foreach ($events as $trackDetailEventsItem) {
            // validation for constraint: itemType
            if (!$trackDetailEventsItem instanceof TrackEvent) {
                throw new \InvalidArgumentException(sprintf('The Events property can only contain items of TrackEvent, "%s" given', is_object($trackDetailEventsItem) ? get_class($trackDetailEventsItem) : gettype($trackDetailEventsItem)), __LINE__);
            }
        }
        $this->Events = $events;
        return $this;
    }
    /**
     * Add item to Events value
     * @throws \InvalidArgumentException
     * @param TrackEvent $item
     * @return TrackDetail
     */
    public function addToEvents(TrackEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackEvent) {
            throw new \InvalidArgumentException(sprintf('The Events property can only contain items of TrackEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Events[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return TrackDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
