<?php
/**
 * This class stands for ServiceType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The service type of the package/shipment.
 * @subpackage Enumerations
 */
class ServiceType
{
    /**
     * Constant for value 'EUROPE_FIRST_INTERNATIONAL_PRIORITY'
     * @return string 'EUROPE_FIRST_INTERNATIONAL_PRIORITY'
     */
    const VALUE_EUROPE_FIRST_INTERNATIONAL_PRIORITY = 'EUROPE_FIRST_INTERNATIONAL_PRIORITY';
    /**
     * Constant for value 'FEDEX_1_DAY_FREIGHT'
     * @return string 'FEDEX_1_DAY_FREIGHT'
     */
    const VALUE_FEDEX_1_DAY_FREIGHT = 'FEDEX_1_DAY_FREIGHT';
    /**
     * Constant for value 'FEDEX_2_DAY'
     * @return string 'FEDEX_2_DAY'
     */
    const VALUE_FEDEX_2_DAY = 'FEDEX_2_DAY';
    /**
     * Constant for value 'FEDEX_2_DAY_AM'
     * @return string 'FEDEX_2_DAY_AM'
     */
    const VALUE_FEDEX_2_DAY_AM = 'FEDEX_2_DAY_AM';
    /**
     * Constant for value 'FEDEX_2_DAY_FREIGHT'
     * @return string 'FEDEX_2_DAY_FREIGHT'
     */
    const VALUE_FEDEX_2_DAY_FREIGHT = 'FEDEX_2_DAY_FREIGHT';
    /**
     * Constant for value 'FEDEX_3_DAY_FREIGHT'
     * @return string 'FEDEX_3_DAY_FREIGHT'
     */
    const VALUE_FEDEX_3_DAY_FREIGHT = 'FEDEX_3_DAY_FREIGHT';
    /**
     * Constant for value 'FEDEX_CARGO_AIRPORT_TO_AIRPORT'
     * @return string 'FEDEX_CARGO_AIRPORT_TO_AIRPORT'
     */
    const VALUE_FEDEX_CARGO_AIRPORT_TO_AIRPORT = 'FEDEX_CARGO_AIRPORT_TO_AIRPORT';
    /**
     * Constant for value 'FEDEX_CARGO_FREIGHT_FORWARDING'
     * @return string 'FEDEX_CARGO_FREIGHT_FORWARDING'
     */
    const VALUE_FEDEX_CARGO_FREIGHT_FORWARDING = 'FEDEX_CARGO_FREIGHT_FORWARDING';
    /**
     * Constant for value 'FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT'
     * @return string 'FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT'
     */
    const VALUE_FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT = 'FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT';
    /**
     * Constant for value 'FEDEX_CARGO_INTERNATIONAL_PREMIUM'
     * @return string 'FEDEX_CARGO_INTERNATIONAL_PREMIUM'
     */
    const VALUE_FEDEX_CARGO_INTERNATIONAL_PREMIUM = 'FEDEX_CARGO_INTERNATIONAL_PREMIUM';
    /**
     * Constant for value 'FEDEX_CARGO_MAIL'
     * @return string 'FEDEX_CARGO_MAIL'
     */
    const VALUE_FEDEX_CARGO_MAIL = 'FEDEX_CARGO_MAIL';
    /**
     * Constant for value 'FEDEX_CARGO_REGISTERED_MAIL'
     * @return string 'FEDEX_CARGO_REGISTERED_MAIL'
     */
    const VALUE_FEDEX_CARGO_REGISTERED_MAIL = 'FEDEX_CARGO_REGISTERED_MAIL';
    /**
     * Constant for value 'FEDEX_CARGO_SURFACE_MAIL'
     * @return string 'FEDEX_CARGO_SURFACE_MAIL'
     */
    const VALUE_FEDEX_CARGO_SURFACE_MAIL = 'FEDEX_CARGO_SURFACE_MAIL';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE'
     * @return string 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE = 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE'
     * @return string 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE = 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK'
     * @return string 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK = 'FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_CHARTER_AIR'
     * @return string 'FEDEX_CUSTOM_CRITICAL_CHARTER_AIR'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_CHARTER_AIR = 'FEDEX_CUSTOM_CRITICAL_CHARTER_AIR';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT'
     * @return string 'FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT = 'FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE'
     * @return string 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE = 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE'
     * @return string 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE = 'FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR'
     * @return string 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR = 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR'
     * @return string 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR = 'FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR';
    /**
     * Constant for value 'FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES'
     * @return string 'FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES'
     */
    const VALUE_FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES = 'FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES';
    /**
     * Constant for value 'FEDEX_DISTANCE_DEFERRED'
     * @return string 'FEDEX_DISTANCE_DEFERRED'
     */
    const VALUE_FEDEX_DISTANCE_DEFERRED = 'FEDEX_DISTANCE_DEFERRED';
    /**
     * Constant for value 'FEDEX_EXPRESS_SAVER'
     * @return string 'FEDEX_EXPRESS_SAVER'
     */
    const VALUE_FEDEX_EXPRESS_SAVER = 'FEDEX_EXPRESS_SAVER';
    /**
     * Constant for value 'FEDEX_FIRST_FREIGHT'
     * @return string 'FEDEX_FIRST_FREIGHT'
     */
    const VALUE_FEDEX_FIRST_FREIGHT = 'FEDEX_FIRST_FREIGHT';
    /**
     * Constant for value 'FEDEX_FREIGHT_ECONOMY'
     * @return string 'FEDEX_FREIGHT_ECONOMY'
     */
    const VALUE_FEDEX_FREIGHT_ECONOMY = 'FEDEX_FREIGHT_ECONOMY';
    /**
     * Constant for value 'FEDEX_FREIGHT_PRIORITY'
     * @return string 'FEDEX_FREIGHT_PRIORITY'
     */
    const VALUE_FEDEX_FREIGHT_PRIORITY = 'FEDEX_FREIGHT_PRIORITY';
    /**
     * Constant for value 'FEDEX_GROUND'
     * @return string 'FEDEX_GROUND'
     */
    const VALUE_FEDEX_GROUND = 'FEDEX_GROUND';
    /**
     * Constant for value 'FEDEX_NEXT_DAY_AFTERNOON'
     * @return string 'FEDEX_NEXT_DAY_AFTERNOON'
     */
    const VALUE_FEDEX_NEXT_DAY_AFTERNOON = 'FEDEX_NEXT_DAY_AFTERNOON';
    /**
     * Constant for value 'FEDEX_NEXT_DAY_EARLY_MORNING'
     * @return string 'FEDEX_NEXT_DAY_EARLY_MORNING'
     */
    const VALUE_FEDEX_NEXT_DAY_EARLY_MORNING = 'FEDEX_NEXT_DAY_EARLY_MORNING';
    /**
     * Constant for value 'FEDEX_NEXT_DAY_END_OF_DAY'
     * @return string 'FEDEX_NEXT_DAY_END_OF_DAY'
     */
    const VALUE_FEDEX_NEXT_DAY_END_OF_DAY = 'FEDEX_NEXT_DAY_END_OF_DAY';
    /**
     * Constant for value 'FEDEX_NEXT_DAY_FREIGHT'
     * @return string 'FEDEX_NEXT_DAY_FREIGHT'
     */
    const VALUE_FEDEX_NEXT_DAY_FREIGHT = 'FEDEX_NEXT_DAY_FREIGHT';
    /**
     * Constant for value 'FEDEX_NEXT_DAY_MID_MORNING'
     * @return string 'FEDEX_NEXT_DAY_MID_MORNING'
     */
    const VALUE_FEDEX_NEXT_DAY_MID_MORNING = 'FEDEX_NEXT_DAY_MID_MORNING';
    /**
     * Constant for value 'FIRST_OVERNIGHT'
     * @return string 'FIRST_OVERNIGHT'
     */
    const VALUE_FIRST_OVERNIGHT = 'FIRST_OVERNIGHT';
    /**
     * Constant for value 'GROUND_HOME_DELIVERY'
     * @return string 'GROUND_HOME_DELIVERY'
     */
    const VALUE_GROUND_HOME_DELIVERY = 'GROUND_HOME_DELIVERY';
    /**
     * Constant for value 'INTERNATIONAL_DISTRIBUTION_FREIGHT'
     * @return string 'INTERNATIONAL_DISTRIBUTION_FREIGHT'
     */
    const VALUE_INTERNATIONAL_DISTRIBUTION_FREIGHT = 'INTERNATIONAL_DISTRIBUTION_FREIGHT';
    /**
     * Constant for value 'INTERNATIONAL_ECONOMY'
     * @return string 'INTERNATIONAL_ECONOMY'
     */
    const VALUE_INTERNATIONAL_ECONOMY = 'INTERNATIONAL_ECONOMY';
    /**
     * Constant for value 'INTERNATIONAL_ECONOMY_DISTRIBUTION'
     * @return string 'INTERNATIONAL_ECONOMY_DISTRIBUTION'
     */
    const VALUE_INTERNATIONAL_ECONOMY_DISTRIBUTION = 'INTERNATIONAL_ECONOMY_DISTRIBUTION';
    /**
     * Constant for value 'INTERNATIONAL_ECONOMY_FREIGHT'
     * @return string 'INTERNATIONAL_ECONOMY_FREIGHT'
     */
    const VALUE_INTERNATIONAL_ECONOMY_FREIGHT = 'INTERNATIONAL_ECONOMY_FREIGHT';
    /**
     * Constant for value 'INTERNATIONAL_FIRST'
     * @return string 'INTERNATIONAL_FIRST'
     */
    const VALUE_INTERNATIONAL_FIRST = 'INTERNATIONAL_FIRST';
    /**
     * Constant for value 'INTERNATIONAL_PRIORITY'
     * @return string 'INTERNATIONAL_PRIORITY'
     */
    const VALUE_INTERNATIONAL_PRIORITY = 'INTERNATIONAL_PRIORITY';
    /**
     * Constant for value 'INTERNATIONAL_PRIORITY_DISTRIBUTION'
     * @return string 'INTERNATIONAL_PRIORITY_DISTRIBUTION'
     */
    const VALUE_INTERNATIONAL_PRIORITY_DISTRIBUTION = 'INTERNATIONAL_PRIORITY_DISTRIBUTION';
    /**
     * Constant for value 'INTERNATIONAL_PRIORITY_FREIGHT'
     * @return string 'INTERNATIONAL_PRIORITY_FREIGHT'
     */
    const VALUE_INTERNATIONAL_PRIORITY_FREIGHT = 'INTERNATIONAL_PRIORITY_FREIGHT';
    /**
     * Constant for value 'PRIORITY_OVERNIGHT'
     * @return string 'PRIORITY_OVERNIGHT'
     */
    const VALUE_PRIORITY_OVERNIGHT = 'PRIORITY_OVERNIGHT';
    /**
     * Constant for value 'SAME_DAY'
     * @return string 'SAME_DAY'
     */
    const VALUE_SAME_DAY = 'SAME_DAY';
    /**
     * Constant for value 'SAME_DAY_CITY'
     * @return string 'SAME_DAY_CITY'
     */
    const VALUE_SAME_DAY_CITY = 'SAME_DAY_CITY';
    /**
     * Constant for value 'SMART_POST'
     * @return string 'SMART_POST'
     */
    const VALUE_SMART_POST = 'SMART_POST';
    /**
     * Constant for value 'STANDARD_OVERNIGHT'
     * @return string 'STANDARD_OVERNIGHT'
     */
    const VALUE_STANDARD_OVERNIGHT = 'STANDARD_OVERNIGHT';
    /**
     * Constant for value 'TRANSBORDER_DISTRIBUTION_CONSOLIDATION'
     * @return string 'TRANSBORDER_DISTRIBUTION_CONSOLIDATION'
     */
    const VALUE_TRANSBORDER_DISTRIBUTION_CONSOLIDATION = 'TRANSBORDER_DISTRIBUTION_CONSOLIDATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EUROPE_FIRST_INTERNATIONAL_PRIORITY
     * @uses self::VALUE_FEDEX_1_DAY_FREIGHT
     * @uses self::VALUE_FEDEX_2_DAY
     * @uses self::VALUE_FEDEX_2_DAY_AM
     * @uses self::VALUE_FEDEX_2_DAY_FREIGHT
     * @uses self::VALUE_FEDEX_3_DAY_FREIGHT
     * @uses self::VALUE_FEDEX_CARGO_AIRPORT_TO_AIRPORT
     * @uses self::VALUE_FEDEX_CARGO_FREIGHT_FORWARDING
     * @uses self::VALUE_FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT
     * @uses self::VALUE_FEDEX_CARGO_INTERNATIONAL_PREMIUM
     * @uses self::VALUE_FEDEX_CARGO_MAIL
     * @uses self::VALUE_FEDEX_CARGO_REGISTERED_MAIL
     * @uses self::VALUE_FEDEX_CARGO_SURFACE_MAIL
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_CHARTER_AIR
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR
     * @uses self::VALUE_FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES
     * @uses self::VALUE_FEDEX_DISTANCE_DEFERRED
     * @uses self::VALUE_FEDEX_EXPRESS_SAVER
     * @uses self::VALUE_FEDEX_FIRST_FREIGHT
     * @uses self::VALUE_FEDEX_FREIGHT_ECONOMY
     * @uses self::VALUE_FEDEX_FREIGHT_PRIORITY
     * @uses self::VALUE_FEDEX_GROUND
     * @uses self::VALUE_FEDEX_NEXT_DAY_AFTERNOON
     * @uses self::VALUE_FEDEX_NEXT_DAY_EARLY_MORNING
     * @uses self::VALUE_FEDEX_NEXT_DAY_END_OF_DAY
     * @uses self::VALUE_FEDEX_NEXT_DAY_FREIGHT
     * @uses self::VALUE_FEDEX_NEXT_DAY_MID_MORNING
     * @uses self::VALUE_FIRST_OVERNIGHT
     * @uses self::VALUE_GROUND_HOME_DELIVERY
     * @uses self::VALUE_INTERNATIONAL_DISTRIBUTION_FREIGHT
     * @uses self::VALUE_INTERNATIONAL_ECONOMY
     * @uses self::VALUE_INTERNATIONAL_ECONOMY_DISTRIBUTION
     * @uses self::VALUE_INTERNATIONAL_ECONOMY_FREIGHT
     * @uses self::VALUE_INTERNATIONAL_FIRST
     * @uses self::VALUE_INTERNATIONAL_PRIORITY
     * @uses self::VALUE_INTERNATIONAL_PRIORITY_DISTRIBUTION
     * @uses self::VALUE_INTERNATIONAL_PRIORITY_FREIGHT
     * @uses self::VALUE_PRIORITY_OVERNIGHT
     * @uses self::VALUE_SAME_DAY
     * @uses self::VALUE_SAME_DAY_CITY
     * @uses self::VALUE_SMART_POST
     * @uses self::VALUE_STANDARD_OVERNIGHT
     * @uses self::VALUE_TRANSBORDER_DISTRIBUTION_CONSOLIDATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EUROPE_FIRST_INTERNATIONAL_PRIORITY,
            self::VALUE_FEDEX_1_DAY_FREIGHT,
            self::VALUE_FEDEX_2_DAY,
            self::VALUE_FEDEX_2_DAY_AM,
            self::VALUE_FEDEX_2_DAY_FREIGHT,
            self::VALUE_FEDEX_3_DAY_FREIGHT,
            self::VALUE_FEDEX_CARGO_AIRPORT_TO_AIRPORT,
            self::VALUE_FEDEX_CARGO_FREIGHT_FORWARDING,
            self::VALUE_FEDEX_CARGO_INTERNATIONAL_EXPRESS_FREIGHT,
            self::VALUE_FEDEX_CARGO_INTERNATIONAL_PREMIUM,
            self::VALUE_FEDEX_CARGO_MAIL,
            self::VALUE_FEDEX_CARGO_REGISTERED_MAIL,
            self::VALUE_FEDEX_CARGO_SURFACE_MAIL,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_EXCLUSIVE_USE,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_AIR_EXPEDITE_NETWORK,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_CHARTER_AIR,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_POINT_TO_POINT,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_SURFACE_EXPEDITE_EXCLUSIVE_USE,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_AIR,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_TEMP_ASSURE_VALIDATED_AIR,
            self::VALUE_FEDEX_CUSTOM_CRITICAL_WHITE_GLOVE_SERVICES,
            self::VALUE_FEDEX_DISTANCE_DEFERRED,
            self::VALUE_FEDEX_EXPRESS_SAVER,
            self::VALUE_FEDEX_FIRST_FREIGHT,
            self::VALUE_FEDEX_FREIGHT_ECONOMY,
            self::VALUE_FEDEX_FREIGHT_PRIORITY,
            self::VALUE_FEDEX_GROUND,
            self::VALUE_FEDEX_NEXT_DAY_AFTERNOON,
            self::VALUE_FEDEX_NEXT_DAY_EARLY_MORNING,
            self::VALUE_FEDEX_NEXT_DAY_END_OF_DAY,
            self::VALUE_FEDEX_NEXT_DAY_FREIGHT,
            self::VALUE_FEDEX_NEXT_DAY_MID_MORNING,
            self::VALUE_FIRST_OVERNIGHT,
            self::VALUE_GROUND_HOME_DELIVERY,
            self::VALUE_INTERNATIONAL_DISTRIBUTION_FREIGHT,
            self::VALUE_INTERNATIONAL_ECONOMY,
            self::VALUE_INTERNATIONAL_ECONOMY_DISTRIBUTION,
            self::VALUE_INTERNATIONAL_ECONOMY_FREIGHT,
            self::VALUE_INTERNATIONAL_FIRST,
            self::VALUE_INTERNATIONAL_PRIORITY,
            self::VALUE_INTERNATIONAL_PRIORITY_DISTRIBUTION,
            self::VALUE_INTERNATIONAL_PRIORITY_FREIGHT,
            self::VALUE_PRIORITY_OVERNIGHT,
            self::VALUE_SAME_DAY,
            self::VALUE_SAME_DAY_CITY,
            self::VALUE_SMART_POST,
            self::VALUE_STANDARD_OVERNIGHT,
            self::VALUE_TRANSBORDER_DISTRIBUTION_CONSOLIDATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
