<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMailNotificationRecipient StructType
 * @subpackage Structs
 */
class EMailNotificationRecipient extends AbstractStructBase
{
    /**
     * The EMailAddress
     * Meta informations extracted from the WSDL
     * - documentation: The email address to send the notification to
     * - minOccurs: 1
     * @var string
     */
    public $EMailAddress;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - documentation: The format of the email notification.
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The EMailNotificationRecipientType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the relationship this email recipient has to the shipment.
     * - minOccurs: 0
     * @var string
     */
    public $EMailNotificationRecipientType;
    /**
     * The NotificationEventsRequested
     * Meta informations extracted from the WSDL
     * - documentation: The types of email notifications being requested for this recipient.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NotificationEventsRequested;
    /**
     * The Localization
     * Meta informations extracted from the WSDL
     * - documentation: The language/locale to be used in this email notification.
     * - minOccurs: 0
     * @var Localization
     */
    public $Localization;
    /**
     * Constructor method for EMailNotificationRecipient
     * @uses EMailNotificationRecipient::setEMailAddress()
     * @uses EMailNotificationRecipient::setFormat()
     * @uses EMailNotificationRecipient::setEMailNotificationRecipientType()
     * @uses EMailNotificationRecipient::setNotificationEventsRequested()
     * @uses EMailNotificationRecipient::setLocalization()
     * @param string $eMailAddress
     * @param string $format
     * @param string $eMailNotificationRecipientType
     * @param string[] $notificationEventsRequested
     * @param Localization $localization
     */
    public function __construct($eMailAddress = null, $format = null, $eMailNotificationRecipientType = null, array $notificationEventsRequested = array(), Localization $localization = null)
    {
        $this
            ->setEMailAddress($eMailAddress)
            ->setFormat($format)
            ->setEMailNotificationRecipientType($eMailNotificationRecipientType)
            ->setNotificationEventsRequested($notificationEventsRequested)
            ->setLocalization($localization);
    }
    /**
     * Get EMailAddress value
     * @return string
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return EMailNotificationRecipient
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses EMailNotificationFormatType::valueIsValid()
     * @uses EMailNotificationFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return EMailNotificationRecipient
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!EMailNotificationFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', EMailNotificationFormatType::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get EMailNotificationRecipientType value
     * @return string|null
     */
    public function getEMailNotificationRecipientType()
    {
        return $this->EMailNotificationRecipientType;
    }
    /**
     * Set EMailNotificationRecipientType value
     * @uses EMailNotificationRecipientType::valueIsValid()
     * @uses EMailNotificationRecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eMailNotificationRecipientType
     * @return EMailNotificationRecipient
     */
    public function setEMailNotificationRecipientType($eMailNotificationRecipientType = null)
    {
        // validation for constraint: enumeration
        if (!EMailNotificationRecipientType::valueIsValid($eMailNotificationRecipientType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eMailNotificationRecipientType, implode(', ', EMailNotificationRecipientType::getValidValues())), __LINE__);
        }
        $this->EMailNotificationRecipientType = $eMailNotificationRecipientType;
        return $this;
    }
    /**
     * Get NotificationEventsRequested value
     * @return string[]|null
     */
    public function getNotificationEventsRequested()
    {
        return $this->NotificationEventsRequested;
    }
    /**
     * Set NotificationEventsRequested value
     * @uses EMailNotificationEventType::valueIsValid()
     * @uses EMailNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $notificationEventsRequested
     * @return EMailNotificationRecipient
     */
    public function setNotificationEventsRequested(array $notificationEventsRequested = array())
    {
        $invalidValues = array();
        foreach ($notificationEventsRequested as $eMailNotificationRecipientNotificationEventsRequestedItem) {
            if (!EMailNotificationEventType::valueIsValid($eMailNotificationRecipientNotificationEventsRequestedItem)) {
                $invalidValues[] = var_export($eMailNotificationRecipientNotificationEventsRequestedItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', EMailNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsRequested = $notificationEventsRequested;
        return $this;
    }
    /**
     * Add item to NotificationEventsRequested value
     * @uses EMailNotificationEventType::valueIsValid()
     * @uses EMailNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return EMailNotificationRecipient
     */
    public function addToNotificationEventsRequested($item)
    {
        // validation for constraint: enumeration
        if (!EMailNotificationEventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', EMailNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsRequested[] = $item;
        return $this;
    }
    /**
     * Get Localization value
     * @return Localization|null
     */
    public function getLocalization()
    {
        return $this->Localization;
    }
    /**
     * Set Localization value
     * @param Localization $localization
     * @return EMailNotificationRecipient
     */
    public function setLocalization(Localization $localization = null)
    {
        $this->Localization = $localization;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EMailNotificationRecipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
