<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMailNotificationDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information describing email notifications that will be sent in relation to events that occur during package movement
 * @subpackage Structs
 */
class EMailNotificationDetail extends AbstractStructBase
{
    /**
     * The Recipients
     * Meta informations extracted from the WSDL
     * - documentation: Information describing the destination of the email, format of the email and events to be notified on
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var EMailNotificationRecipient[]
     */
    public $Recipients;
    /**
     * The PersonalMessage
     * Meta informations extracted from the WSDL
     * - documentation: A message that will be included in the email notifications
     * - minOccurs: 0
     * @var string
     */
    public $PersonalMessage;
    /**
     * Constructor method for EMailNotificationDetail
     * @uses EMailNotificationDetail::setRecipients()
     * @uses EMailNotificationDetail::setPersonalMessage()
     * @param EMailNotificationRecipient[] $recipients
     * @param string $personalMessage
     */
    public function __construct(array $recipients = array(), $personalMessage = null)
    {
        $this
            ->setRecipients($recipients)
            ->setPersonalMessage($personalMessage);
    }
    /**
     * Get Recipients value
     * @return EMailNotificationRecipient[]
     */
    public function getRecipients()
    {
        return $this->Recipients;
    }
    /**
     * Set Recipients value
     * @throws \InvalidArgumentException
     * @param EMailNotificationRecipient[] $recipients
     * @return EMailNotificationDetail
     */
    public function setRecipients(array $recipients = array())
    {
        foreach ($recipients as $eMailNotificationDetailRecipientsItem) {
            // validation for constraint: itemType
            if (!$eMailNotificationDetailRecipientsItem instanceof EMailNotificationRecipient) {
                throw new \InvalidArgumentException(sprintf('The Recipients property can only contain items of EMailNotificationRecipient, "%s" given', is_object($eMailNotificationDetailRecipientsItem) ? get_class($eMailNotificationDetailRecipientsItem) : gettype($eMailNotificationDetailRecipientsItem)), __LINE__);
            }
        }
        $this->Recipients = $recipients;
        return $this;
    }
    /**
     * Add item to Recipients value
     * @throws \InvalidArgumentException
     * @param EMailNotificationRecipient $item
     * @return EMailNotificationDetail
     */
    public function addToRecipients(EMailNotificationRecipient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof EMailNotificationRecipient) {
            throw new \InvalidArgumentException(sprintf('The Recipients property can only contain items of EMailNotificationRecipient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recipients[] = $item;
        return $this;
    }
    /**
     * Get PersonalMessage value
     * @return string|null
     */
    public function getPersonalMessage()
    {
        return $this->PersonalMessage;
    }
    /**
     * Set PersonalMessage value
     * @param string $personalMessage
     * @return EMailNotificationDetail
     */
    public function setPersonalMessage($personalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($personalMessage) && !is_string($personalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalMessage)), __LINE__);
        }
        $this->PersonalMessage = $personalMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EMailNotificationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
