<?php
/**
 * This class stands for TrackSpecialHandlingType EnumType
 * @subpackage Enumerations
 */
class TrackSpecialHandlingType
{
    /**
     * Constant for value 'ACCESSIBLE_DANGEROUS_GOODS'
     * @return string 'ACCESSIBLE_DANGEROUS_GOODS'
     */
    const VALUE_ACCESSIBLE_DANGEROUS_GOODS = 'ACCESSIBLE_DANGEROUS_GOODS';
    /**
     * Constant for value 'ADULT_SIGNATURE_OPTION'
     * @return string 'ADULT_SIGNATURE_OPTION'
     */
    const VALUE_ADULT_SIGNATURE_OPTION = 'ADULT_SIGNATURE_OPTION';
    /**
     * Constant for value 'AIRBILL_AUTOMATION'
     * @return string 'AIRBILL_AUTOMATION'
     */
    const VALUE_AIRBILL_AUTOMATION = 'AIRBILL_AUTOMATION';
    /**
     * Constant for value 'AIRBILL_DELIVERY'
     * @return string 'AIRBILL_DELIVERY'
     */
    const VALUE_AIRBILL_DELIVERY = 'AIRBILL_DELIVERY';
    /**
     * Constant for value 'ALCOHOL'
     * @return string 'ALCOHOL'
     */
    const VALUE_ALCOHOL = 'ALCOHOL';
    /**
     * Constant for value 'AM_DELIVERY_GUARANTEE'
     * @return string 'AM_DELIVERY_GUARANTEE'
     */
    const VALUE_AM_DELIVERY_GUARANTEE = 'AM_DELIVERY_GUARANTEE';
    /**
     * Constant for value 'APPOINTMENT_DELIVERY'
     * @return string 'APPOINTMENT_DELIVERY'
     */
    const VALUE_APPOINTMENT_DELIVERY = 'APPOINTMENT_DELIVERY';
    /**
     * Constant for value 'BILL_RECIPIENT'
     * @return string 'BILL_RECIPIENT'
     */
    const VALUE_BILL_RECIPIENT = 'BILL_RECIPIENT';
    /**
     * Constant for value 'BROKER_SELECT_OPTION'
     * @return string 'BROKER_SELECT_OPTION'
     */
    const VALUE_BROKER_SELECT_OPTION = 'BROKER_SELECT_OPTION';
    /**
     * Constant for value 'CALL_BEFORE_DELIVERY'
     * @return string 'CALL_BEFORE_DELIVERY'
     */
    const VALUE_CALL_BEFORE_DELIVERY = 'CALL_BEFORE_DELIVERY';
    /**
     * Constant for value 'CALL_TAG'
     * @return string 'CALL_TAG'
     */
    const VALUE_CALL_TAG = 'CALL_TAG';
    /**
     * Constant for value 'CALL_TAG_DAMAGE'
     * @return string 'CALL_TAG_DAMAGE'
     */
    const VALUE_CALL_TAG_DAMAGE = 'CALL_TAG_DAMAGE';
    /**
     * Constant for value 'CHARGEABLE_CODE'
     * @return string 'CHARGEABLE_CODE'
     */
    const VALUE_CHARGEABLE_CODE = 'CHARGEABLE_CODE';
    /**
     * Constant for value 'COD'
     * @return string 'COD'
     */
    const VALUE_COD = 'COD';
    /**
     * Constant for value 'COLLECT'
     * @return string 'COLLECT'
     */
    const VALUE_COLLECT = 'COLLECT';
    /**
     * Constant for value 'CONSOLIDATION'
     * @return string 'CONSOLIDATION'
     */
    const VALUE_CONSOLIDATION = 'CONSOLIDATION';
    /**
     * Constant for value 'CONSOLIDATION_SMALLS_BAG'
     * @return string 'CONSOLIDATION_SMALLS_BAG'
     */
    const VALUE_CONSOLIDATION_SMALLS_BAG = 'CONSOLIDATION_SMALLS_BAG';
    /**
     * Constant for value 'CURRENCY'
     * @return string 'CURRENCY'
     */
    const VALUE_CURRENCY = 'CURRENCY';
    /**
     * Constant for value 'CUT_FLOWERS'
     * @return string 'CUT_FLOWERS'
     */
    const VALUE_CUT_FLOWERS = 'CUT_FLOWERS';
    /**
     * Constant for value 'DATE_CERTAIN_DELIVERY'
     * @return string 'DATE_CERTAIN_DELIVERY'
     */
    const VALUE_DATE_CERTAIN_DELIVERY = 'DATE_CERTAIN_DELIVERY';
    /**
     * Constant for value 'DELIVERY_ON_INVOICE_ACCEPTANCE'
     * @return string 'DELIVERY_ON_INVOICE_ACCEPTANCE'
     */
    const VALUE_DELIVERY_ON_INVOICE_ACCEPTANCE = 'DELIVERY_ON_INVOICE_ACCEPTANCE';
    /**
     * Constant for value 'DELIVERY_REATTEMPT'
     * @return string 'DELIVERY_REATTEMPT'
     */
    const VALUE_DELIVERY_REATTEMPT = 'DELIVERY_REATTEMPT';
    /**
     * Constant for value 'DELIVERY_RECEIPT'
     * @return string 'DELIVERY_RECEIPT'
     */
    const VALUE_DELIVERY_RECEIPT = 'DELIVERY_RECEIPT';
    /**
     * Constant for value 'DELIVER_WEEKDAY'
     * @return string 'DELIVER_WEEKDAY'
     */
    const VALUE_DELIVER_WEEKDAY = 'DELIVER_WEEKDAY';
    /**
     * Constant for value 'DIRECT_SIGNATURE_OPTION'
     * @return string 'DIRECT_SIGNATURE_OPTION'
     */
    const VALUE_DIRECT_SIGNATURE_OPTION = 'DIRECT_SIGNATURE_OPTION';
    /**
     * Constant for value 'DOMESTIC'
     * @return string 'DOMESTIC'
     */
    const VALUE_DOMESTIC = 'DOMESTIC';
    /**
     * Constant for value 'DO_NOT_BREAK_DOWN_PALLETS'
     * @return string 'DO_NOT_BREAK_DOWN_PALLETS'
     */
    const VALUE_DO_NOT_BREAK_DOWN_PALLETS = 'DO_NOT_BREAK_DOWN_PALLETS';
    /**
     * Constant for value 'DO_NOT_STACK_PALLETS'
     * @return string 'DO_NOT_STACK_PALLETS'
     */
    const VALUE_DO_NOT_STACK_PALLETS = 'DO_NOT_STACK_PALLETS';
    /**
     * Constant for value 'DRY_ICE'
     * @return string 'DRY_ICE'
     */
    const VALUE_DRY_ICE = 'DRY_ICE';
    /**
     * Constant for value 'DRY_ICE_ADDED'
     * @return string 'DRY_ICE_ADDED'
     */
    const VALUE_DRY_ICE_ADDED = 'DRY_ICE_ADDED';
    /**
     * Constant for value 'EAST_COAST_SPECIAL'
     * @return string 'EAST_COAST_SPECIAL'
     */
    const VALUE_EAST_COAST_SPECIAL = 'EAST_COAST_SPECIAL';
    /**
     * Constant for value 'ELECTRONIC_COD'
     * @return string 'ELECTRONIC_COD'
     */
    const VALUE_ELECTRONIC_COD = 'ELECTRONIC_COD';
    /**
     * Constant for value 'ELECTRONIC_SIGNATURE_SERVICE'
     * @return string 'ELECTRONIC_SIGNATURE_SERVICE'
     */
    const VALUE_ELECTRONIC_SIGNATURE_SERVICE = 'ELECTRONIC_SIGNATURE_SERVICE';
    /**
     * Constant for value 'EVENING_DELIVERY'
     * @return string 'EVENING_DELIVERY'
     */
    const VALUE_EVENING_DELIVERY = 'EVENING_DELIVERY';
    /**
     * Constant for value 'EXCLUSIVE_USE'
     * @return string 'EXCLUSIVE_USE'
     */
    const VALUE_EXCLUSIVE_USE = 'EXCLUSIVE_USE';
    /**
     * Constant for value 'EXTENDED_DELIVERY'
     * @return string 'EXTENDED_DELIVERY'
     */
    const VALUE_EXTENDED_DELIVERY = 'EXTENDED_DELIVERY';
    /**
     * Constant for value 'EXTENDED_PICKUP'
     * @return string 'EXTENDED_PICKUP'
     */
    const VALUE_EXTENDED_PICKUP = 'EXTENDED_PICKUP';
    /**
     * Constant for value 'EXTRA_LABOR'
     * @return string 'EXTRA_LABOR'
     */
    const VALUE_EXTRA_LABOR = 'EXTRA_LABOR';
    /**
     * Constant for value 'EXTREME_LENGTH'
     * @return string 'EXTREME_LENGTH'
     */
    const VALUE_EXTREME_LENGTH = 'EXTREME_LENGTH';
    /**
     * Constant for value 'FOOD'
     * @return string 'FOOD'
     */
    const VALUE_FOOD = 'FOOD';
    /**
     * Constant for value 'FREIGHT_ON_VALUE_CARRIER_RISK'
     * @return string 'FREIGHT_ON_VALUE_CARRIER_RISK'
     */
    const VALUE_FREIGHT_ON_VALUE_CARRIER_RISK = 'FREIGHT_ON_VALUE_CARRIER_RISK';
    /**
     * Constant for value 'FREIGHT_ON_VALUE_OWN_RISK'
     * @return string 'FREIGHT_ON_VALUE_OWN_RISK'
     */
    const VALUE_FREIGHT_ON_VALUE_OWN_RISK = 'FREIGHT_ON_VALUE_OWN_RISK';
    /**
     * Constant for value 'FREIGHT_TO_COLLECT'
     * @return string 'FREIGHT_TO_COLLECT'
     */
    const VALUE_FREIGHT_TO_COLLECT = 'FREIGHT_TO_COLLECT';
    /**
     * Constant for value 'FULLY_REGULATED_DANGEROUS_GOODS'
     * @return string 'FULLY_REGULATED_DANGEROUS_GOODS'
     */
    const VALUE_FULLY_REGULATED_DANGEROUS_GOODS = 'FULLY_REGULATED_DANGEROUS_GOODS';
    /**
     * Constant for value 'GEL_PACKS_ADDED_OR_REPLACED'
     * @return string 'GEL_PACKS_ADDED_OR_REPLACED'
     */
    const VALUE_GEL_PACKS_ADDED_OR_REPLACED = 'GEL_PACKS_ADDED_OR_REPLACED';
    /**
     * Constant for value 'GROUND_SUPPORT_FOR_SMARTPOST'
     * @return string 'GROUND_SUPPORT_FOR_SMARTPOST'
     */
    const VALUE_GROUND_SUPPORT_FOR_SMARTPOST = 'GROUND_SUPPORT_FOR_SMARTPOST';
    /**
     * Constant for value 'GUARANTEED_FUNDS'
     * @return string 'GUARANTEED_FUNDS'
     */
    const VALUE_GUARANTEED_FUNDS = 'GUARANTEED_FUNDS';
    /**
     * Constant for value 'HAZMAT'
     * @return string 'HAZMAT'
     */
    const VALUE_HAZMAT = 'HAZMAT';
    /**
     * Constant for value 'HIGH_FLOOR'
     * @return string 'HIGH_FLOOR'
     */
    const VALUE_HIGH_FLOOR = 'HIGH_FLOOR';
    /**
     * Constant for value 'HOLD_AT_LOCATION'
     * @return string 'HOLD_AT_LOCATION'
     */
    const VALUE_HOLD_AT_LOCATION = 'HOLD_AT_LOCATION';
    /**
     * Constant for value 'HOLIDAY_DELIVERY'
     * @return string 'HOLIDAY_DELIVERY'
     */
    const VALUE_HOLIDAY_DELIVERY = 'HOLIDAY_DELIVERY';
    /**
     * Constant for value 'INACCESSIBLE_DANGEROUS_GOODS'
     * @return string 'INACCESSIBLE_DANGEROUS_GOODS'
     */
    const VALUE_INACCESSIBLE_DANGEROUS_GOODS = 'INACCESSIBLE_DANGEROUS_GOODS';
    /**
     * Constant for value 'INDIRECT_SIGNATURE_OPTION'
     * @return string 'INDIRECT_SIGNATURE_OPTION'
     */
    const VALUE_INDIRECT_SIGNATURE_OPTION = 'INDIRECT_SIGNATURE_OPTION';
    /**
     * Constant for value 'INSIDE_DELIVERY'
     * @return string 'INSIDE_DELIVERY'
     */
    const VALUE_INSIDE_DELIVERY = 'INSIDE_DELIVERY';
    /**
     * Constant for value 'INSIDE_PICKUP'
     * @return string 'INSIDE_PICKUP'
     */
    const VALUE_INSIDE_PICKUP = 'INSIDE_PICKUP';
    /**
     * Constant for value 'INTERNATIONAL'
     * @return string 'INTERNATIONAL'
     */
    const VALUE_INTERNATIONAL = 'INTERNATIONAL';
    /**
     * Constant for value 'INTERNATIONAL_CONTROLLED_EXPORT'
     * @return string 'INTERNATIONAL_CONTROLLED_EXPORT'
     */
    const VALUE_INTERNATIONAL_CONTROLLED_EXPORT = 'INTERNATIONAL_CONTROLLED_EXPORT';
    /**
     * Constant for value 'INTERNATIONAL_MAIL_SERVICE'
     * @return string 'INTERNATIONAL_MAIL_SERVICE'
     */
    const VALUE_INTERNATIONAL_MAIL_SERVICE = 'INTERNATIONAL_MAIL_SERVICE';
    /**
     * Constant for value 'INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS'
     * @return string 'INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS'
     */
    const VALUE_INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS = 'INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS';
    /**
     * Constant for value 'LIFTGATE'
     * @return string 'LIFTGATE'
     */
    const VALUE_LIFTGATE = 'LIFTGATE';
    /**
     * Constant for value 'LIFTGATE_DELIVERY'
     * @return string 'LIFTGATE_DELIVERY'
     */
    const VALUE_LIFTGATE_DELIVERY = 'LIFTGATE_DELIVERY';
    /**
     * Constant for value 'LIFTGATE_PICKUP'
     * @return string 'LIFTGATE_PICKUP'
     */
    const VALUE_LIFTGATE_PICKUP = 'LIFTGATE_PICKUP';
    /**
     * Constant for value 'LIMITED_ACCESS_DELIVERY'
     * @return string 'LIMITED_ACCESS_DELIVERY'
     */
    const VALUE_LIMITED_ACCESS_DELIVERY = 'LIMITED_ACCESS_DELIVERY';
    /**
     * Constant for value 'LIMITED_ACCESS_PICKUP'
     * @return string 'LIMITED_ACCESS_PICKUP'
     */
    const VALUE_LIMITED_ACCESS_PICKUP = 'LIMITED_ACCESS_PICKUP';
    /**
     * Constant for value 'LIMITED_QUANTITIES_DANGEROUS_GOODS'
     * @return string 'LIMITED_QUANTITIES_DANGEROUS_GOODS'
     */
    const VALUE_LIMITED_QUANTITIES_DANGEROUS_GOODS = 'LIMITED_QUANTITIES_DANGEROUS_GOODS';
    /**
     * Constant for value 'MARKING_OR_TAGGING'
     * @return string 'MARKING_OR_TAGGING'
     */
    const VALUE_MARKING_OR_TAGGING = 'MARKING_OR_TAGGING';
    /**
     * Constant for value 'NET_RETURN'
     * @return string 'NET_RETURN'
     */
    const VALUE_NET_RETURN = 'NET_RETURN';
    /**
     * Constant for value 'NON_BUSINESS_TIME'
     * @return string 'NON_BUSINESS_TIME'
     */
    const VALUE_NON_BUSINESS_TIME = 'NON_BUSINESS_TIME';
    /**
     * Constant for value 'NON_STANDARD_CONTAINER'
     * @return string 'NON_STANDARD_CONTAINER'
     */
    const VALUE_NON_STANDARD_CONTAINER = 'NON_STANDARD_CONTAINER';
    /**
     * Constant for value 'NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION'
     * @return string 'NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION'
     */
    const VALUE_NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION = 'NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION';
    /**
     * Constant for value 'ORDER_NOTIFY'
     * @return string 'ORDER_NOTIFY'
     */
    const VALUE_ORDER_NOTIFY = 'ORDER_NOTIFY';
    /**
     * Constant for value 'OTHER'
     * @return string 'OTHER'
     */
    const VALUE_OTHER = 'OTHER';
    /**
     * Constant for value 'OTHER_REGULATED_MATERIAL_DOMESTIC'
     * @return string 'OTHER_REGULATED_MATERIAL_DOMESTIC'
     */
    const VALUE_OTHER_REGULATED_MATERIAL_DOMESTIC = 'OTHER_REGULATED_MATERIAL_DOMESTIC';
    /**
     * Constant for value 'PACKAGE_RETURN_PROGRAM'
     * @return string 'PACKAGE_RETURN_PROGRAM'
     */
    const VALUE_PACKAGE_RETURN_PROGRAM = 'PACKAGE_RETURN_PROGRAM';
    /**
     * Constant for value 'PIECE_COUNT_VERIFICATION'
     * @return string 'PIECE_COUNT_VERIFICATION'
     */
    const VALUE_PIECE_COUNT_VERIFICATION = 'PIECE_COUNT_VERIFICATION';
    /**
     * Constant for value 'POISON'
     * @return string 'POISON'
     */
    const VALUE_POISON = 'POISON';
    /**
     * Constant for value 'PREPAID'
     * @return string 'PREPAID'
     */
    const VALUE_PREPAID = 'PREPAID';
    /**
     * Constant for value 'PRIORITY_ALERT'
     * @return string 'PRIORITY_ALERT'
     */
    const VALUE_PRIORITY_ALERT = 'PRIORITY_ALERT';
    /**
     * Constant for value 'PRIORITY_ALERT_PLUS'
     * @return string 'PRIORITY_ALERT_PLUS'
     */
    const VALUE_PRIORITY_ALERT_PLUS = 'PRIORITY_ALERT_PLUS';
    /**
     * Constant for value 'PROTECTION_FROM_FREEZING'
     * @return string 'PROTECTION_FROM_FREEZING'
     */
    const VALUE_PROTECTION_FROM_FREEZING = 'PROTECTION_FROM_FREEZING';
    /**
     * Constant for value 'RAIL_MODE'
     * @return string 'RAIL_MODE'
     */
    const VALUE_RAIL_MODE = 'RAIL_MODE';
    /**
     * Constant for value 'RECONSIGNMENT_CHARGES'
     * @return string 'RECONSIGNMENT_CHARGES'
     */
    const VALUE_RECONSIGNMENT_CHARGES = 'RECONSIGNMENT_CHARGES';
    /**
     * Constant for value 'REROUTE_CROSS_COUNTRY_DEFERRED'
     * @return string 'REROUTE_CROSS_COUNTRY_DEFERRED'
     */
    const VALUE_REROUTE_CROSS_COUNTRY_DEFERRED = 'REROUTE_CROSS_COUNTRY_DEFERRED';
    /**
     * Constant for value 'REROUTE_CROSS_COUNTRY_EXPEDITED'
     * @return string 'REROUTE_CROSS_COUNTRY_EXPEDITED'
     */
    const VALUE_REROUTE_CROSS_COUNTRY_EXPEDITED = 'REROUTE_CROSS_COUNTRY_EXPEDITED';
    /**
     * Constant for value 'REROUTE_LOCAL'
     * @return string 'REROUTE_LOCAL'
     */
    const VALUE_REROUTE_LOCAL = 'REROUTE_LOCAL';
    /**
     * Constant for value 'RESIDENTIAL_DELIVERY'
     * @return string 'RESIDENTIAL_DELIVERY'
     */
    const VALUE_RESIDENTIAL_DELIVERY = 'RESIDENTIAL_DELIVERY';
    /**
     * Constant for value 'RESIDENTIAL_PICKUP'
     * @return string 'RESIDENTIAL_PICKUP'
     */
    const VALUE_RESIDENTIAL_PICKUP = 'RESIDENTIAL_PICKUP';
    /**
     * Constant for value 'RETURNS_CLEARANCE'
     * @return string 'RETURNS_CLEARANCE'
     */
    const VALUE_RETURNS_CLEARANCE = 'RETURNS_CLEARANCE';
    /**
     * Constant for value 'RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED'
     * @return string 'RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED'
     */
    const VALUE_RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED = 'RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED';
    /**
     * Constant for value 'RETURN_MANAGER'
     * @return string 'RETURN_MANAGER'
     */
    const VALUE_RETURN_MANAGER = 'RETURN_MANAGER';
    /**
     * Constant for value 'SATURDAY_DELIVERY'
     * @return string 'SATURDAY_DELIVERY'
     */
    const VALUE_SATURDAY_DELIVERY = 'SATURDAY_DELIVERY';
    /**
     * Constant for value 'SHIPMENT_PLACED_IN_COLD_STORAGE'
     * @return string 'SHIPMENT_PLACED_IN_COLD_STORAGE'
     */
    const VALUE_SHIPMENT_PLACED_IN_COLD_STORAGE = 'SHIPMENT_PLACED_IN_COLD_STORAGE';
    /**
     * Constant for value 'SINGLE_SHIPMENT'
     * @return string 'SINGLE_SHIPMENT'
     */
    const VALUE_SINGLE_SHIPMENT = 'SINGLE_SHIPMENT';
    /**
     * Constant for value 'SMALL_QUANTITY_EXCEPTION'
     * @return string 'SMALL_QUANTITY_EXCEPTION'
     */
    const VALUE_SMALL_QUANTITY_EXCEPTION = 'SMALL_QUANTITY_EXCEPTION';
    /**
     * Constant for value 'SORT_AND_SEGREGATE'
     * @return string 'SORT_AND_SEGREGATE'
     */
    const VALUE_SORT_AND_SEGREGATE = 'SORT_AND_SEGREGATE';
    /**
     * Constant for value 'SPECIAL_DELIVERY'
     * @return string 'SPECIAL_DELIVERY'
     */
    const VALUE_SPECIAL_DELIVERY = 'SPECIAL_DELIVERY';
    /**
     * Constant for value 'SPECIAL_EQUIPMENT'
     * @return string 'SPECIAL_EQUIPMENT'
     */
    const VALUE_SPECIAL_EQUIPMENT = 'SPECIAL_EQUIPMENT';
    /**
     * Constant for value 'STANDARD_GROUND_SERVICE'
     * @return string 'STANDARD_GROUND_SERVICE'
     */
    const VALUE_STANDARD_GROUND_SERVICE = 'STANDARD_GROUND_SERVICE';
    /**
     * Constant for value 'STORAGE'
     * @return string 'STORAGE'
     */
    const VALUE_STORAGE = 'STORAGE';
    /**
     * Constant for value 'SUNDAY_DELIVERY'
     * @return string 'SUNDAY_DELIVERY'
     */
    const VALUE_SUNDAY_DELIVERY = 'SUNDAY_DELIVERY';
    /**
     * Constant for value 'THIRD_PARTY_BILLING'
     * @return string 'THIRD_PARTY_BILLING'
     */
    const VALUE_THIRD_PARTY_BILLING = 'THIRD_PARTY_BILLING';
    /**
     * Constant for value 'THIRD_PARTY_CONSIGNEE'
     * @return string 'THIRD_PARTY_CONSIGNEE'
     */
    const VALUE_THIRD_PARTY_CONSIGNEE = 'THIRD_PARTY_CONSIGNEE';
    /**
     * Constant for value 'TOP_LOAD'
     * @return string 'TOP_LOAD'
     */
    const VALUE_TOP_LOAD = 'TOP_LOAD';
    /**
     * Constant for value 'WEEKEND_DELIVERY'
     * @return string 'WEEKEND_DELIVERY'
     */
    const VALUE_WEEKEND_DELIVERY = 'WEEKEND_DELIVERY';
    /**
     * Constant for value 'WEEKEND_PICKUP'
     * @return string 'WEEKEND_PICKUP'
     */
    const VALUE_WEEKEND_PICKUP = 'WEEKEND_PICKUP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESSIBLE_DANGEROUS_GOODS
     * @uses self::VALUE_ADULT_SIGNATURE_OPTION
     * @uses self::VALUE_AIRBILL_AUTOMATION
     * @uses self::VALUE_AIRBILL_DELIVERY
     * @uses self::VALUE_ALCOHOL
     * @uses self::VALUE_AM_DELIVERY_GUARANTEE
     * @uses self::VALUE_APPOINTMENT_DELIVERY
     * @uses self::VALUE_BILL_RECIPIENT
     * @uses self::VALUE_BROKER_SELECT_OPTION
     * @uses self::VALUE_CALL_BEFORE_DELIVERY
     * @uses self::VALUE_CALL_TAG
     * @uses self::VALUE_CALL_TAG_DAMAGE
     * @uses self::VALUE_CHARGEABLE_CODE
     * @uses self::VALUE_COD
     * @uses self::VALUE_COLLECT
     * @uses self::VALUE_CONSOLIDATION
     * @uses self::VALUE_CONSOLIDATION_SMALLS_BAG
     * @uses self::VALUE_CURRENCY
     * @uses self::VALUE_CUT_FLOWERS
     * @uses self::VALUE_DATE_CERTAIN_DELIVERY
     * @uses self::VALUE_DELIVERY_ON_INVOICE_ACCEPTANCE
     * @uses self::VALUE_DELIVERY_REATTEMPT
     * @uses self::VALUE_DELIVERY_RECEIPT
     * @uses self::VALUE_DELIVER_WEEKDAY
     * @uses self::VALUE_DIRECT_SIGNATURE_OPTION
     * @uses self::VALUE_DOMESTIC
     * @uses self::VALUE_DO_NOT_BREAK_DOWN_PALLETS
     * @uses self::VALUE_DO_NOT_STACK_PALLETS
     * @uses self::VALUE_DRY_ICE
     * @uses self::VALUE_DRY_ICE_ADDED
     * @uses self::VALUE_EAST_COAST_SPECIAL
     * @uses self::VALUE_ELECTRONIC_COD
     * @uses self::VALUE_ELECTRONIC_SIGNATURE_SERVICE
     * @uses self::VALUE_EVENING_DELIVERY
     * @uses self::VALUE_EXCLUSIVE_USE
     * @uses self::VALUE_EXTENDED_DELIVERY
     * @uses self::VALUE_EXTENDED_PICKUP
     * @uses self::VALUE_EXTRA_LABOR
     * @uses self::VALUE_EXTREME_LENGTH
     * @uses self::VALUE_FOOD
     * @uses self::VALUE_FREIGHT_ON_VALUE_CARRIER_RISK
     * @uses self::VALUE_FREIGHT_ON_VALUE_OWN_RISK
     * @uses self::VALUE_FREIGHT_TO_COLLECT
     * @uses self::VALUE_FULLY_REGULATED_DANGEROUS_GOODS
     * @uses self::VALUE_GEL_PACKS_ADDED_OR_REPLACED
     * @uses self::VALUE_GROUND_SUPPORT_FOR_SMARTPOST
     * @uses self::VALUE_GUARANTEED_FUNDS
     * @uses self::VALUE_HAZMAT
     * @uses self::VALUE_HIGH_FLOOR
     * @uses self::VALUE_HOLD_AT_LOCATION
     * @uses self::VALUE_HOLIDAY_DELIVERY
     * @uses self::VALUE_INACCESSIBLE_DANGEROUS_GOODS
     * @uses self::VALUE_INDIRECT_SIGNATURE_OPTION
     * @uses self::VALUE_INSIDE_DELIVERY
     * @uses self::VALUE_INSIDE_PICKUP
     * @uses self::VALUE_INTERNATIONAL
     * @uses self::VALUE_INTERNATIONAL_CONTROLLED_EXPORT
     * @uses self::VALUE_INTERNATIONAL_MAIL_SERVICE
     * @uses self::VALUE_INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS
     * @uses self::VALUE_LIFTGATE
     * @uses self::VALUE_LIFTGATE_DELIVERY
     * @uses self::VALUE_LIFTGATE_PICKUP
     * @uses self::VALUE_LIMITED_ACCESS_DELIVERY
     * @uses self::VALUE_LIMITED_ACCESS_PICKUP
     * @uses self::VALUE_LIMITED_QUANTITIES_DANGEROUS_GOODS
     * @uses self::VALUE_MARKING_OR_TAGGING
     * @uses self::VALUE_NET_RETURN
     * @uses self::VALUE_NON_BUSINESS_TIME
     * @uses self::VALUE_NON_STANDARD_CONTAINER
     * @uses self::VALUE_NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION
     * @uses self::VALUE_ORDER_NOTIFY
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_OTHER_REGULATED_MATERIAL_DOMESTIC
     * @uses self::VALUE_PACKAGE_RETURN_PROGRAM
     * @uses self::VALUE_PIECE_COUNT_VERIFICATION
     * @uses self::VALUE_POISON
     * @uses self::VALUE_PREPAID
     * @uses self::VALUE_PRIORITY_ALERT
     * @uses self::VALUE_PRIORITY_ALERT_PLUS
     * @uses self::VALUE_PROTECTION_FROM_FREEZING
     * @uses self::VALUE_RAIL_MODE
     * @uses self::VALUE_RECONSIGNMENT_CHARGES
     * @uses self::VALUE_REROUTE_CROSS_COUNTRY_DEFERRED
     * @uses self::VALUE_REROUTE_CROSS_COUNTRY_EXPEDITED
     * @uses self::VALUE_REROUTE_LOCAL
     * @uses self::VALUE_RESIDENTIAL_DELIVERY
     * @uses self::VALUE_RESIDENTIAL_PICKUP
     * @uses self::VALUE_RETURNS_CLEARANCE
     * @uses self::VALUE_RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED
     * @uses self::VALUE_RETURN_MANAGER
     * @uses self::VALUE_SATURDAY_DELIVERY
     * @uses self::VALUE_SHIPMENT_PLACED_IN_COLD_STORAGE
     * @uses self::VALUE_SINGLE_SHIPMENT
     * @uses self::VALUE_SMALL_QUANTITY_EXCEPTION
     * @uses self::VALUE_SORT_AND_SEGREGATE
     * @uses self::VALUE_SPECIAL_DELIVERY
     * @uses self::VALUE_SPECIAL_EQUIPMENT
     * @uses self::VALUE_STANDARD_GROUND_SERVICE
     * @uses self::VALUE_STORAGE
     * @uses self::VALUE_SUNDAY_DELIVERY
     * @uses self::VALUE_THIRD_PARTY_BILLING
     * @uses self::VALUE_THIRD_PARTY_CONSIGNEE
     * @uses self::VALUE_TOP_LOAD
     * @uses self::VALUE_WEEKEND_DELIVERY
     * @uses self::VALUE_WEEKEND_PICKUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESSIBLE_DANGEROUS_GOODS,
            self::VALUE_ADULT_SIGNATURE_OPTION,
            self::VALUE_AIRBILL_AUTOMATION,
            self::VALUE_AIRBILL_DELIVERY,
            self::VALUE_ALCOHOL,
            self::VALUE_AM_DELIVERY_GUARANTEE,
            self::VALUE_APPOINTMENT_DELIVERY,
            self::VALUE_BILL_RECIPIENT,
            self::VALUE_BROKER_SELECT_OPTION,
            self::VALUE_CALL_BEFORE_DELIVERY,
            self::VALUE_CALL_TAG,
            self::VALUE_CALL_TAG_DAMAGE,
            self::VALUE_CHARGEABLE_CODE,
            self::VALUE_COD,
            self::VALUE_COLLECT,
            self::VALUE_CONSOLIDATION,
            self::VALUE_CONSOLIDATION_SMALLS_BAG,
            self::VALUE_CURRENCY,
            self::VALUE_CUT_FLOWERS,
            self::VALUE_DATE_CERTAIN_DELIVERY,
            self::VALUE_DELIVERY_ON_INVOICE_ACCEPTANCE,
            self::VALUE_DELIVERY_REATTEMPT,
            self::VALUE_DELIVERY_RECEIPT,
            self::VALUE_DELIVER_WEEKDAY,
            self::VALUE_DIRECT_SIGNATURE_OPTION,
            self::VALUE_DOMESTIC,
            self::VALUE_DO_NOT_BREAK_DOWN_PALLETS,
            self::VALUE_DO_NOT_STACK_PALLETS,
            self::VALUE_DRY_ICE,
            self::VALUE_DRY_ICE_ADDED,
            self::VALUE_EAST_COAST_SPECIAL,
            self::VALUE_ELECTRONIC_COD,
            self::VALUE_ELECTRONIC_SIGNATURE_SERVICE,
            self::VALUE_EVENING_DELIVERY,
            self::VALUE_EXCLUSIVE_USE,
            self::VALUE_EXTENDED_DELIVERY,
            self::VALUE_EXTENDED_PICKUP,
            self::VALUE_EXTRA_LABOR,
            self::VALUE_EXTREME_LENGTH,
            self::VALUE_FOOD,
            self::VALUE_FREIGHT_ON_VALUE_CARRIER_RISK,
            self::VALUE_FREIGHT_ON_VALUE_OWN_RISK,
            self::VALUE_FREIGHT_TO_COLLECT,
            self::VALUE_FULLY_REGULATED_DANGEROUS_GOODS,
            self::VALUE_GEL_PACKS_ADDED_OR_REPLACED,
            self::VALUE_GROUND_SUPPORT_FOR_SMARTPOST,
            self::VALUE_GUARANTEED_FUNDS,
            self::VALUE_HAZMAT,
            self::VALUE_HIGH_FLOOR,
            self::VALUE_HOLD_AT_LOCATION,
            self::VALUE_HOLIDAY_DELIVERY,
            self::VALUE_INACCESSIBLE_DANGEROUS_GOODS,
            self::VALUE_INDIRECT_SIGNATURE_OPTION,
            self::VALUE_INSIDE_DELIVERY,
            self::VALUE_INSIDE_PICKUP,
            self::VALUE_INTERNATIONAL,
            self::VALUE_INTERNATIONAL_CONTROLLED_EXPORT,
            self::VALUE_INTERNATIONAL_MAIL_SERVICE,
            self::VALUE_INTERNATIONAL_TRAFFIC_IN_ARMS_REGULATIONS,
            self::VALUE_LIFTGATE,
            self::VALUE_LIFTGATE_DELIVERY,
            self::VALUE_LIFTGATE_PICKUP,
            self::VALUE_LIMITED_ACCESS_DELIVERY,
            self::VALUE_LIMITED_ACCESS_PICKUP,
            self::VALUE_LIMITED_QUANTITIES_DANGEROUS_GOODS,
            self::VALUE_MARKING_OR_TAGGING,
            self::VALUE_NET_RETURN,
            self::VALUE_NON_BUSINESS_TIME,
            self::VALUE_NON_STANDARD_CONTAINER,
            self::VALUE_NO_SIGNATURE_REQUIRED_SIGNATURE_OPTION,
            self::VALUE_ORDER_NOTIFY,
            self::VALUE_OTHER,
            self::VALUE_OTHER_REGULATED_MATERIAL_DOMESTIC,
            self::VALUE_PACKAGE_RETURN_PROGRAM,
            self::VALUE_PIECE_COUNT_VERIFICATION,
            self::VALUE_POISON,
            self::VALUE_PREPAID,
            self::VALUE_PRIORITY_ALERT,
            self::VALUE_PRIORITY_ALERT_PLUS,
            self::VALUE_PROTECTION_FROM_FREEZING,
            self::VALUE_RAIL_MODE,
            self::VALUE_RECONSIGNMENT_CHARGES,
            self::VALUE_REROUTE_CROSS_COUNTRY_DEFERRED,
            self::VALUE_REROUTE_CROSS_COUNTRY_EXPEDITED,
            self::VALUE_REROUTE_LOCAL,
            self::VALUE_RESIDENTIAL_DELIVERY,
            self::VALUE_RESIDENTIAL_PICKUP,
            self::VALUE_RETURNS_CLEARANCE,
            self::VALUE_RETURNS_CLEARANCE_SPECIAL_ROUTING_REQUIRED,
            self::VALUE_RETURN_MANAGER,
            self::VALUE_SATURDAY_DELIVERY,
            self::VALUE_SHIPMENT_PLACED_IN_COLD_STORAGE,
            self::VALUE_SINGLE_SHIPMENT,
            self::VALUE_SMALL_QUANTITY_EXCEPTION,
            self::VALUE_SORT_AND_SEGREGATE,
            self::VALUE_SPECIAL_DELIVERY,
            self::VALUE_SPECIAL_EQUIPMENT,
            self::VALUE_STANDARD_GROUND_SERVICE,
            self::VALUE_STORAGE,
            self::VALUE_SUNDAY_DELIVERY,
            self::VALUE_THIRD_PARTY_BILLING,
            self::VALUE_THIRD_PARTY_CONSIGNEE,
            self::VALUE_TOP_LOAD,
            self::VALUE_WEEKEND_DELIVERY,
            self::VALUE_WEEKEND_PICKUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
