<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsOptionDetail StructType
 * @subpackage Structs
 */
class CustomsOptionDetail extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Specifies additional description about customs options. This is a required field when the customs options type is "OTHER".
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for CustomsOptionDetail
     * @uses CustomsOptionDetail::setType()
     * @uses CustomsOptionDetail::setDescription()
     * @param string $type
     * @param string $description
     */
    public function __construct($type = null, $description = null)
    {
        $this
            ->setType($type)
            ->setDescription($description);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses CustomsOptionType::valueIsValid()
     * @uses CustomsOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return CustomsOptionDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!CustomsOptionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', CustomsOptionType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return CustomsOptionDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return CustomsOptionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
