<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Initialize ServiceType
 * @subpackage Services
 */
class Initialize extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Initialize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $appl
     * @param string $v
     * @param string $v501
     * @param string $v700
     * @param string $v800
     * @param string $vx1000
     * @return array|bool
     */
    public function Initialize($user, $appl, $v, $v501, $v700, $v800, $vx1000)
    {
        try {
            $this->setResult(self::getSoapClient()->Initialize($user, $appl, $v, $v501, $v700, $v800, $vx1000));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
