<?php

namespace EnumType;

/**
 * This class stands for PresenceActivity EnumType
 * @subpackage Enumerations
 */
class PresenceActivity
{
    /**
     * Constant for value 'appointment'
     * @return string 'appointment'
     */
    const VALUE_APPOINTMENT = 'appointment';
    /**
     * Constant for value 'away'
     * @return string 'away'
     */
    const VALUE_AWAY = 'away';
    /**
     * Constant for value 'breakfast'
     * @return string 'breakfast'
     */
    const VALUE_BREAKFAST = 'breakfast';
    /**
     * Constant for value 'busy'
     * @return string 'busy'
     */
    const VALUE_BUSY = 'busy';
    /**
     * Constant for value 'dinner'
     * @return string 'dinner'
     */
    const VALUE_DINNER = 'dinner';
    /**
     * Constant for value 'holiday'
     * @return string 'holiday'
     */
    const VALUE_HOLIDAY = 'holiday';
    /**
     * Constant for value 'in-transit'
     * @return string 'in-transit'
     */
    const VALUE_IN_TRANSIT = 'in-transit';
    /**
     * Constant for value 'looking-for-work'
     * @return string 'looking-for-work'
     */
    const VALUE_LOOKING_FOR_WORK = 'looking-for-work';
    /**
     * Constant for value 'lunch'
     * @return string 'lunch'
     */
    const VALUE_LUNCH = 'lunch';
    /**
     * Constant for value 'meal'
     * @return string 'meal'
     */
    const VALUE_MEAL = 'meal';
    /**
     * Constant for value 'meeting'
     * @return string 'meeting'
     */
    const VALUE_MEETING = 'meeting';
    /**
     * Constant for value 'on-the-phone'
     * @return string 'on-the-phone'
     */
    const VALUE_ON_THE_PHONE = 'on-the-phone';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Constant for value 'performance'
     * @return string 'performance'
     */
    const VALUE_PERFORMANCE = 'performance';
    /**
     * Constant for value 'permanent-absence'
     * @return string 'permanent-absence'
     */
    const VALUE_PERMANENT_ABSENCE = 'permanent-absence';
    /**
     * Constant for value 'playing'
     * @return string 'playing'
     */
    const VALUE_PLAYING = 'playing';
    /**
     * Constant for value 'presentation'
     * @return string 'presentation'
     */
    const VALUE_PRESENTATION = 'presentation';
    /**
     * Constant for value 'shopping'
     * @return string 'shopping'
     */
    const VALUE_SHOPPING = 'shopping';
    /**
     * Constant for value 'sleeping'
     * @return string 'sleeping'
     */
    const VALUE_SLEEPING = 'sleeping';
    /**
     * Constant for value 'spectator'
     * @return string 'spectator'
     */
    const VALUE_SPECTATOR = 'spectator';
    /**
     * Constant for value 'steering'
     * @return string 'steering'
     */
    const VALUE_STEERING = 'steering';
    /**
     * Constant for value 'travel'
     * @return string 'travel'
     */
    const VALUE_TRAVEL = 'travel';
    /**
     * Constant for value 'tv'
     * @return string 'tv'
     */
    const VALUE_TV = 'tv';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'vacation'
     * @return string 'vacation'
     */
    const VALUE_VACATION = 'vacation';
    /**
     * Constant for value 'working'
     * @return string 'working'
     */
    const VALUE_WORKING = 'working';
    /**
     * Constant for value 'worship'
     * @return string 'worship'
     */
    const VALUE_WORSHIP = 'worship';
    /**
     * Constant for value 'dnd'
     * @return string 'dnd'
     */
    const VALUE_DND = 'dnd';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_AWAY
     * @uses self::VALUE_BREAKFAST
     * @uses self::VALUE_BUSY
     * @uses self::VALUE_DINNER
     * @uses self::VALUE_HOLIDAY
     * @uses self::VALUE_IN_TRANSIT
     * @uses self::VALUE_LOOKING_FOR_WORK
     * @uses self::VALUE_LUNCH
     * @uses self::VALUE_MEAL
     * @uses self::VALUE_MEETING
     * @uses self::VALUE_ON_THE_PHONE
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_PERFORMANCE
     * @uses self::VALUE_PERMANENT_ABSENCE
     * @uses self::VALUE_PLAYING
     * @uses self::VALUE_PRESENTATION
     * @uses self::VALUE_SHOPPING
     * @uses self::VALUE_SLEEPING
     * @uses self::VALUE_SPECTATOR
     * @uses self::VALUE_STEERING
     * @uses self::VALUE_TRAVEL
     * @uses self::VALUE_TV
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VACATION
     * @uses self::VALUE_WORKING
     * @uses self::VALUE_WORSHIP
     * @uses self::VALUE_DND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPOINTMENT,
            self::VALUE_AWAY,
            self::VALUE_BREAKFAST,
            self::VALUE_BUSY,
            self::VALUE_DINNER,
            self::VALUE_HOLIDAY,
            self::VALUE_IN_TRANSIT,
            self::VALUE_LOOKING_FOR_WORK,
            self::VALUE_LUNCH,
            self::VALUE_MEAL,
            self::VALUE_MEETING,
            self::VALUE_ON_THE_PHONE,
            self::VALUE_OTHER,
            self::VALUE_PERFORMANCE,
            self::VALUE_PERMANENT_ABSENCE,
            self::VALUE_PLAYING,
            self::VALUE_PRESENTATION,
            self::VALUE_SHOPPING,
            self::VALUE_SLEEPING,
            self::VALUE_SPECTATOR,
            self::VALUE_STEERING,
            self::VALUE_TRAVEL,
            self::VALUE_TV,
            self::VALUE_UNKNOWN,
            self::VALUE_VACATION,
            self::VALUE_WORKING,
            self::VALUE_WORSHIP,
            self::VALUE_DND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
