<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.innovaphone.com/wsdl/pbx10_00.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.innovaphone.com/wsdl/pbx10_00.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Version ServiceType
 */
$version = new \ServiceType\Version($options);
/**
 * Sample call for Version operation/method
 */
if ($version->Version() !== false) {
    print_r($version->getResult());
} else {
    print_r($version->getLastError());
}
/**
 * Samples for Echo ServiceType
 */
$echo = new \ServiceType\_Echo($options);
/**
 * Sample call for _Echo operation/method
 */
if ($echo->_Echo($session, $key) !== false) {
    print_r($echo->getResult());
} else {
    print_r($echo->getLastError());
}
/**
 * Samples for Admin ServiceType
 */
$admin = new \ServiceType\Admin($options);
/**
 * Sample call for Admin operation/method
 */
if ($admin->Admin($xml) !== false) {
    print_r($admin->getResult());
} else {
    print_r($admin->getLastError());
}
/**
 * Samples for Initialize ServiceType
 */
$initialize = new \ServiceType\Initialize($options);
/**
 * Sample call for Initialize operation/method
 */
if ($initialize->Initialize($user, $appl, $v, $v501, $v700, $v800, $vx1000) !== false) {
    print_r($initialize->getResult());
} else {
    print_r($initialize->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
/**
 * Sample call for End operation/method
 */
if ($end->End($session) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Poll ServiceType
 */
$poll = new \ServiceType\Poll($options);
/**
 * Sample call for Poll operation/method
 */
if ($poll->Poll($session) !== false) {
    print_r($poll->getResult());
} else {
    print_r($poll->getLastError());
}
/**
 * Samples for License ServiceType
 */
$license = new \ServiceType\License($options);
/**
 * Sample call for License operation/method
 */
if ($license->License($session, $name) !== false) {
    print_r($license->getResult());
} else {
    print_r($license->getLastError());
}
/**
 * Samples for Devices ServiceType
 */
$devices = new \ServiceType\Devices($options);
/**
 * Sample call for Devices operation/method
 */
if ($devices->Devices($session, $user) !== false) {
    print_r($devices->getResult());
} else {
    print_r($devices->getLastError());
}
/**
 * Samples for Calls ServiceType
 */
$calls = new \ServiceType\Calls($options);
/**
 * Sample call for Calls operation/method
 */
if ($calls->Calls($session, $user) !== false) {
    print_r($calls->getResult());
} else {
    print_r($calls->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for UserInitialize operation/method
 */
if ($user->UserInitialize($session, $user, $xfer, $disc, $hw) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserEnd operation/method
 */
if ($user->UserEnd($user) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserCall operation/method
 */
if ($user->UserCall($user, $cn, $e164, $h323, $reg, $info, $rc, $srce164) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserClear operation/method
 */
if ($user->UserClear($call, $cause, $info) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserConnect operation/method
 */
if ($user->UserConnect($call) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRc operation/method
 */
if ($user->UserRc($call, $rc) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserInfo operation/method
 */
if ($user->UserInfo($call, $recv, $cdpn, $key, $dsp) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserDTMF operation/method
 */
if ($user->UserDTMF($call, $recv, $dtmf) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserUUI operation/method
 */
if ($user->UserUUI($call, $recv, $uui) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserPickup operation/method
 */
if ($user->UserPickup($user, $cn, $call, $group, $reg, $info) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRedirect operation/method
 */
if ($user->UserRedirect($call, $cn, $e164, $h323, $info, $rc) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserReroute operation/method
 */
if ($user->UserReroute($call, $cn, $e164, $h323, $info) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserTransfer operation/method
 */
if ($user->UserTransfer($a, $b) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserMediaTransfer operation/method
 */
if ($user->UserMediaTransfer($a, $b, $user, $peer) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserCtComplete operation/method
 */
if ($user->UserCtComplete($call, $e164, $h323) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserHold operation/method
 */
if ($user->UserHold($call, $remote) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserRetrieve operation/method
 */
if ($user->UserRetrieve($call) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserPark operation/method
 */
if ($user->UserPark($call, $cn, $position) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserMessage operation/method
 */
if ($user->UserMessage($user, $e164, $h323, $msg, $src_e164, $src_h323) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserLocalNum operation/method
 */
if ($user->UserLocalNum($user, $num) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserFindDestination operation/method
 */
if ($user->UserFindDestination($user, $e164, $h323) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserLicense operation/method
 */
if ($user->UserLicense($guid, $type) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for FindUser operation/method
 */
if ($find->FindUser($v501, $v700, $v800, $vx1000, $cn, $h323, $e164, $count, $next, $nohide) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetPresence operation/method
 */
if ($set->SetPresence(new \StructType\Presence(), $im, $contact, $guid, $h323) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Location ServiceType
 */
$location = new \ServiceType\Location($options);
/**
 * Sample call for LocationUrl operation/method
 */
if ($location->LocationUrl($v501, $v700, $v800, $vx1000, $loc, $tls) !== false) {
    print_r($location->getResult());
} else {
    print_r($location->getLastError());
}
