<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfo StructType
 * @subpackage Structs
 */
class UserInfo extends AbstractStructBase
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guid;
    /**
     * The active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $active;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $state;
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $channel;
    /**
     * The alert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $alert;
    /**
     * The cn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cn;
    /**
     * The dn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dn;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $e164;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $h323;
    /**
     * The presence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Presence
     */
    public $presence;
    /**
     * The groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:Group[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:Group
     * @var \StructType\Group[]
     */
    public $groups;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:Info[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:Info
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * The loc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loc;
    /**
     * The node
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $node;
    /**
     * The nodenum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodenum;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $object;
    /**
     * The cfg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cfg;
    /**
     * Constructor method for UserInfo
     * @uses UserInfo::setGuid()
     * @uses UserInfo::setActive()
     * @uses UserInfo::setState()
     * @uses UserInfo::setChannel()
     * @uses UserInfo::setAlert()
     * @uses UserInfo::setCn()
     * @uses UserInfo::setDn()
     * @uses UserInfo::setType()
     * @uses UserInfo::setE164()
     * @uses UserInfo::setH323()
     * @uses UserInfo::setPresence()
     * @uses UserInfo::setGroups()
     * @uses UserInfo::setInfo()
     * @uses UserInfo::setLoc()
     * @uses UserInfo::setNode()
     * @uses UserInfo::setNodenum()
     * @uses UserInfo::setObject()
     * @uses UserInfo::setCfg()
     * @param string $guid
     * @param bool $active
     * @param int $state
     * @param int $channel
     * @param int $alert
     * @param string $cn
     * @param string $dn
     * @param string $type
     * @param string $e164
     * @param string $h323
     * @param \StructType\Presence $presence
     * @param \StructType\Group[] $groups
     * @param \StructType\Info[] $info
     * @param string $loc
     * @param string $node
     * @param string $nodenum
     * @param string $object
     * @param bool $cfg
     */
    public function __construct($guid = null, $active = null, $state = null, $channel = null, $alert = null, $cn = null, $dn = null, $type = null, $e164 = null, $h323 = null, \StructType\Presence $presence = null, array $groups = array(), array $info = array(), $loc = null, $node = null, $nodenum = null, $object = null, $cfg = null)
    {
        $this
            ->setGuid($guid)
            ->setActive($active)
            ->setState($state)
            ->setChannel($channel)
            ->setAlert($alert)
            ->setCn($cn)
            ->setDn($dn)
            ->setType($type)
            ->setE164($e164)
            ->setH323($h323)
            ->setPresence($presence)
            ->setGroups($groups)
            ->setInfo($info)
            ->setLoc($loc)
            ->setNode($node)
            ->setNodenum($nodenum)
            ->setObject($object)
            ->setCfg($cfg);
    }
    /**
     * Get guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\UserInfo
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get active value
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\UserInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get state value
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param int $state
     * @return \StructType\UserInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: int
        if (!is_null($state) && !is_numeric($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get channel value
     * @return int
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param int $channel
     * @return \StructType\UserInfo
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: int
        if (!is_null($channel) && !is_numeric($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get alert value
     * @return int
     */
    public function getAlert()
    {
        return $this->alert;
    }
    /**
     * Set alert value
     * @param int $alert
     * @return \StructType\UserInfo
     */
    public function setAlert($alert = null)
    {
        // validation for constraint: int
        if (!is_null($alert) && !is_numeric($alert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alert)), __LINE__);
        }
        $this->alert = $alert;
        return $this;
    }
    /**
     * Get cn value
     * @return string
     */
    public function getCn()
    {
        return $this->cn;
    }
    /**
     * Set cn value
     * @param string $cn
     * @return \StructType\UserInfo
     */
    public function setCn($cn = null)
    {
        // validation for constraint: string
        if (!is_null($cn) && !is_string($cn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cn)), __LINE__);
        }
        $this->cn = $cn;
        return $this;
    }
    /**
     * Get dn value
     * @return string
     */
    public function getDn()
    {
        return $this->dn;
    }
    /**
     * Set dn value
     * @param string $dn
     * @return \StructType\UserInfo
     */
    public function setDn($dn = null)
    {
        // validation for constraint: string
        if (!is_null($dn) && !is_string($dn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dn)), __LINE__);
        }
        $this->dn = $dn;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\UserInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get e164 value
     * @return string
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \StructType\UserInfo
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get h323 value
     * @return string
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\UserInfo
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Get presence value
     * @return \StructType\Presence
     */
    public function getPresence()
    {
        return $this->presence;
    }
    /**
     * Set presence value
     * @param \StructType\Presence $presence
     * @return \StructType\UserInfo
     */
    public function setPresence(\StructType\Presence $presence = null)
    {
        $this->presence = $presence;
        return $this;
    }
    /**
     * Get groups value
     * @return \StructType\Group[]
     */
    public function getGroups()
    {
        return $this->groups;
    }
    /**
     * Set groups value
     * @throws \InvalidArgumentException
     * @param \StructType\Group[] $groups
     * @return \StructType\UserInfo
     */
    public function setGroups(array $groups = array())
    {
        foreach ($groups as $userInfoGroupsItem) {
            // validation for constraint: itemType
            if (!$userInfoGroupsItem instanceof \StructType\Group) {
                throw new \InvalidArgumentException(sprintf('The groups property can only contain items of \StructType\Group, "%s" given', is_object($userInfoGroupsItem) ? get_class($userInfoGroupsItem) : gettype($userInfoGroupsItem)), __LINE__);
            }
        }
        $this->groups = $groups;
        return $this;
    }
    /**
     * Add item to groups value
     * @throws \InvalidArgumentException
     * @param \StructType\Group $item
     * @return \StructType\UserInfo
     */
    public function addToGroups(\StructType\Group $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Group) {
            throw new \InvalidArgumentException(sprintf('The groups property can only contain items of \StructType\Group, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->groups[] = $item;
        return $this;
    }
    /**
     * Get info value
     * @return \StructType\Info[]
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\UserInfo
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $userInfoInfoItem) {
            // validation for constraint: itemType
            if (!$userInfoInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($userInfoInfoItem) ? get_class($userInfoInfoItem) : gettype($userInfoInfoItem)), __LINE__);
            }
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\UserInfo
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Get loc value
     * @return string|null
     */
    public function getLoc()
    {
        return $this->loc;
    }
    /**
     * Set loc value
     * @param string $loc
     * @return \StructType\UserInfo
     */
    public function setLoc($loc = null)
    {
        // validation for constraint: string
        if (!is_null($loc) && !is_string($loc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loc)), __LINE__);
        }
        $this->loc = $loc;
        return $this;
    }
    /**
     * Get node value
     * @return string|null
     */
    public function getNode()
    {
        return $this->node;
    }
    /**
     * Set node value
     * @param string $node
     * @return \StructType\UserInfo
     */
    public function setNode($node = null)
    {
        // validation for constraint: string
        if (!is_null($node) && !is_string($node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($node)), __LINE__);
        }
        $this->node = $node;
        return $this;
    }
    /**
     * Get nodenum value
     * @return string|null
     */
    public function getNodenum()
    {
        return $this->nodenum;
    }
    /**
     * Set nodenum value
     * @param string $nodenum
     * @return \StructType\UserInfo
     */
    public function setNodenum($nodenum = null)
    {
        // validation for constraint: string
        if (!is_null($nodenum) && !is_string($nodenum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nodenum)), __LINE__);
        }
        $this->nodenum = $nodenum;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\UserInfo
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get cfg value
     * @return bool|null
     */
    public function getCfg()
    {
        return $this->cfg;
    }
    /**
     * Set cfg value
     * @param bool $cfg
     * @return \StructType\UserInfo
     */
    public function setCfg($cfg = null)
    {
        // validation for constraint: boolean
        if (!is_null($cfg) && !is_bool($cfg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cfg)), __LINE__);
        }
        $this->cfg = $cfg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
