<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Presence StructType
 * @subpackage Structs
 */
class Presence extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $activity;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * Constructor method for Presence
     * @uses Presence::setStatus()
     * @uses Presence::setActivity()
     * @uses Presence::setNote()
     * @param string $status
     * @param string $activity
     * @param string $note
     */
    public function __construct($status = null, $activity = null, $note = null)
    {
        $this
            ->setStatus($status)
            ->setActivity($activity)
            ->setNote($note);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\PresenceStatus::valueIsValid()
     * @uses \EnumType\PresenceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Presence
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PresenceStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\PresenceStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get activity value
     * @return string|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @uses \EnumType\PresenceActivity::valueIsValid()
     * @uses \EnumType\PresenceActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activity
     * @return \StructType\Presence
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PresenceActivity::valueIsValid($activity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $activity, implode(', ', \EnumType\PresenceActivity::getValidValues())), __LINE__);
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\Presence
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Presence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
