<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Info StructType
 * @subpackage Structs
 */
class Info extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The vali
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vali;
    /**
     * The vals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vals;
    /**
     * Constructor method for Info
     * @uses Info::setType()
     * @uses Info::setVali()
     * @uses Info::setVals()
     * @param string $type
     * @param int $vali
     * @param string $vals
     */
    public function __construct($type = null, $vali = null, $vals = null)
    {
        $this
            ->setType($type)
            ->setVali($vali)
            ->setVals($vals);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Info
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get vali value
     * @return int
     */
    public function getVali()
    {
        return $this->vali;
    }
    /**
     * Set vali value
     * @param int $vali
     * @return \StructType\Info
     */
    public function setVali($vali = null)
    {
        // validation for constraint: int
        if (!is_null($vali) && !is_numeric($vali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vali)), __LINE__);
        }
        $this->vali = $vali;
        return $this;
    }
    /**
     * Get vals value
     * @return string
     */
    public function getVals()
    {
        return $this->vals;
    }
    /**
     * Set vals value
     * @param string $vals
     * @return \StructType\Info
     */
    public function setVals($vals = null)
    {
        // validation for constraint: string
        if (!is_null($vals) && !is_string($vals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vals)), __LINE__);
        }
        $this->vals = $vals;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
