<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UserInitialize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session
     * @param string $user
     * @param string $xfer
     * @param string $disc
     * @param string $hw
     * @return int|bool
     */
    public function UserInitialize($session, $user, $xfer, $disc, $hw)
    {
        try {
            $this->setResult(self::getSoapClient()->UserInitialize($session, $user, $xfer, $disc, $hw));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserEnd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @return void|bool
     */
    public function UserEnd($user)
    {
        try {
            $this->setResult(self::getSoapClient()->UserEnd($user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserCall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $cn
     * @param string $e164
     * @param string $h323
     * @param string $reg
     * @param string $info
     * @param string $rc
     * @param string $srce164
     * @return int|bool
     */
    public function UserCall($user, $cn, $e164, $h323, $reg, $info, $rc, $srce164)
    {
        try {
            $this->setResult(self::getSoapClient()->UserCall($user, $cn, $e164, $h323, $reg, $info, $rc, $srce164));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserClear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $cause
     * @param string $info
     * @return void|bool
     */
    public function UserClear($call, $cause, $info)
    {
        try {
            $this->setResult(self::getSoapClient()->UserClear($call, $cause, $info));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserConnect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @return void|bool
     */
    public function UserConnect($call)
    {
        try {
            $this->setResult(self::getSoapClient()->UserConnect($call));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $rc
     * @return void|bool
     */
    public function UserRc($call, $rc)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRc($call, $rc));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $recv
     * @param string $cdpn
     * @param string $key
     * @param string $dsp
     * @return void|bool
     */
    public function UserInfo($call, $recv, $cdpn, $key, $dsp)
    {
        try {
            $this->setResult(self::getSoapClient()->UserInfo($call, $recv, $cdpn, $key, $dsp));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserDTMF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $recv
     * @param string $dtmf
     * @return void|bool
     */
    public function UserDTMF($call, $recv, $dtmf)
    {
        try {
            $this->setResult(self::getSoapClient()->UserDTMF($call, $recv, $dtmf));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserUUI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $recv
     * @param string $uui
     * @return void|bool
     */
    public function UserUUI($call, $recv, $uui)
    {
        try {
            $this->setResult(self::getSoapClient()->UserUUI($call, $recv, $uui));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $cn
     * @param string $call
     * @param string $group
     * @param string $reg
     * @param string $info
     * @return int|bool
     */
    public function UserPickup($user, $cn, $call, $group, $reg, $info)
    {
        try {
            $this->setResult(self::getSoapClient()->UserPickup($user, $cn, $call, $group, $reg, $info));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRedirect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $cn
     * @param string $e164
     * @param string $h323
     * @param string $info
     * @param string $rc
     * @return boolean|bool
     */
    public function UserRedirect($call, $cn, $e164, $h323, $info, $rc)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRedirect($call, $cn, $e164, $h323, $info, $rc));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserReroute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $cn
     * @param string $e164
     * @param string $h323
     * @param string $info
     * @return boolean|bool
     */
    public function UserReroute($call, $cn, $e164, $h323, $info)
    {
        try {
            $this->setResult(self::getSoapClient()->UserReroute($call, $cn, $e164, $h323, $info));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $a
     * @param string $b
     * @return void|bool
     */
    public function UserTransfer($a, $b)
    {
        try {
            $this->setResult(self::getSoapClient()->UserTransfer($a, $b));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserMediaTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $a
     * @param string $b
     * @param string $user
     * @param string $peer
     * @return void|bool
     */
    public function UserMediaTransfer($a, $b, $user, $peer)
    {
        try {
            $this->setResult(self::getSoapClient()->UserMediaTransfer($a, $b, $user, $peer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserCtComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $e164
     * @param string $h323
     * @return void|bool
     */
    public function UserCtComplete($call, $e164, $h323)
    {
        try {
            $this->setResult(self::getSoapClient()->UserCtComplete($call, $e164, $h323));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserHold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $remote
     * @return void|bool
     */
    public function UserHold($call, $remote)
    {
        try {
            $this->setResult(self::getSoapClient()->UserHold($call, $remote));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRetrieve
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @return void|bool
     */
    public function UserRetrieve($call)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRetrieve($call));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $call
     * @param string $cn
     * @param string $position
     * @return int|bool
     */
    public function UserPark($call, $cn, $position)
    {
        try {
            $this->setResult(self::getSoapClient()->UserPark($call, $cn, $position));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $e164
     * @param string $h323
     * @param string $msg
     * @param string $src_e164
     * @param string $src_h323
     * @return int|bool
     */
    public function UserMessage($user, $e164, $h323, $msg, $src_e164, $src_h323)
    {
        try {
            $this->setResult(self::getSoapClient()->UserMessage($user, $e164, $h323, $msg, $src_e164, $src_h323));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserLocalNum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $num
     * @return string|bool
     */
    public function UserLocalNum($user, $num)
    {
        try {
            $this->setResult(self::getSoapClient()->UserLocalNum($user, $num));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserFindDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $e164
     * @param string $h323
     * @return array|bool
     */
    public function UserFindDestination($user, $e164, $h323)
    {
        try {
            $this->setResult(self::getSoapClient()->UserFindDestination($user, $e164, $h323));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|boolean|int|string|void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
