<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FindUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $v501
     * @param string $v700
     * @param string $v800
     * @param string $vx1000
     * @param string $cn
     * @param string $h323
     * @param string $e164
     * @param string $count
     * @param string $next
     * @return \StructType\UserInfo[]|bool
     */
    public function FindUser($v501, $v700, $v800, $vx1000, $cn, $h323, $e164, $count, $next)
    {
        try {
            $this->setResult(self::getSoapClient()->FindUser($v501, $v700, $v800, $vx1000, $cn, $h323, $e164, $count, $next));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserInfo[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
