<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTable StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a table attribute in UpdateData in the response of a Save data action.
 * @subpackage Structs
 */
class UpdateTable extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the table.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The row
     * Meta informations extracted from the WSDL
     * - documentation: An instance of the table.
     * - maxOccurs: unbounded
     * @var \StructType\UpdateRow[]
     */
    public $row;
    /**
     * Constructor method for UpdateTable
     * @uses UpdateTable::setName()
     * @uses UpdateTable::setRow()
     * @param string $name
     * @param \StructType\UpdateRow[] $row
     */
    public function __construct($name = null, array $row = array())
    {
        $this
            ->setName($name)
            ->setRow($row);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UpdateTable
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get row value
     * @return \StructType\UpdateRow[]|null
     */
    public function getRow()
    {
        return $this->row;
    }
    /**
     * Set row value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdateRow[] $row
     * @return \StructType\UpdateTable
     */
    public function setRow(array $row = array())
    {
        foreach ($row as $updateTableRowItem) {
            // validation for constraint: itemType
            if (!$updateTableRowItem instanceof \StructType\UpdateRow) {
                throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\UpdateRow, "%s" given', is_object($updateTableRowItem) ? get_class($updateTableRowItem) : gettype($updateTableRowItem)), __LINE__);
            }
        }
        $this->row = $row;
        return $this;
    }
    /**
     * Add item to row value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdateRow $item
     * @return \StructType\UpdateTable
     */
    public function addToRow(\StructType\UpdateRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UpdateRow) {
            throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\UpdateRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->row[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
