<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the tables attribute in the response of a Save data action.
 * @subpackage Structs
 */
class UpdateData extends AbstractStructBase
{
    /**
     * The table
     * Meta informations extracted from the WSDL
     * - documentation: A table containing data retrieved by the web service connector.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UpdateTable[]
     */
    public $table;
    /**
     * Constructor method for UpdateData
     * @uses UpdateData::setTable()
     * @param \StructType\UpdateTable[] $table
     */
    public function __construct(array $table = array())
    {
        $this
            ->setTable($table);
    }
    /**
     * Get table value
     * @return \StructType\UpdateTable[]|null
     */
    public function getTable()
    {
        return $this->table;
    }
    /**
     * Set table value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdateTable[] $table
     * @return \StructType\UpdateData
     */
    public function setTable(array $table = array())
    {
        foreach ($table as $updateDataTableItem) {
            // validation for constraint: itemType
            if (!$updateDataTableItem instanceof \StructType\UpdateTable) {
                throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\UpdateTable, "%s" given', is_object($updateDataTableItem) ? get_class($updateDataTableItem) : gettype($updateDataTableItem)), __LINE__);
            }
        }
        $this->table = $table;
        return $this;
    }
    /**
     * Add item to table value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdateTable $item
     * @return \StructType\UpdateData
     */
    public function addToTable(\StructType\UpdateTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UpdateTable) {
            throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\UpdateTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->table[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
