<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitRow StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a row attribute in SubmitTable in the request of a Save data action.
 * @subpackage Structs
 */
class SubmitRow extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The ID of a row. If the row was pre-seeded from a Load request, the same id value will be used, otherwise it will be auto-generated by the determinations server.
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - documentation: The action the web service connector should take on the row.
     * - use: required
     * @var string
     */
    public $action;
    /**
     * The input_field
     * Meta informations extracted from the WSDL
     * - documentation: A field with a value to submit to the connector.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataField[]
     */
    public $input_field;
    /**
     * The output_field
     * Meta informations extracted from the WSDL
     * - documentation: A field to retrieve a value for in the save-response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataField[]
     */
    public $output_field;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: A link from the row to specific rows in a target table.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataLink[]
     */
    public $link;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: A list of attachments to submit to the connector.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttachmentList
     */
    public $attachments;
    /**
     * Constructor method for SubmitRow
     * @uses SubmitRow::setId()
     * @uses SubmitRow::setAction()
     * @uses SubmitRow::setInput_field()
     * @uses SubmitRow::setOutput_field()
     * @uses SubmitRow::setLink()
     * @uses SubmitRow::setAttachments()
     * @param string $id
     * @param string $action
     * @param \StructType\DataField[] $input_field
     * @param \StructType\DataField[] $output_field
     * @param \StructType\DataLink[] $link
     * @param \StructType\AttachmentList $attachments
     */
    public function __construct($id = null, $action = null, array $input_field = array(), array $output_field = array(), array $link = array(), \StructType\AttachmentList $attachments = null)
    {
        $this
            ->setId($id)
            ->setAction($action)
            ->setInput_field($input_field)
            ->setOutput_field($output_field)
            ->setLink($link)
            ->setAttachments($attachments);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SubmitRow
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get action value
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\RowAction::valueIsValid()
     * @uses \EnumType\RowAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\SubmitRow
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RowAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\RowAction::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get input_field value
     * @return \StructType\DataField[]|null
     */
    public function getInput_field()
    {
        return $this->{'input-field'};
    }
    /**
     * Set input_field value
     * @throws \InvalidArgumentException
     * @param \StructType\DataField[] $input_field
     * @return \StructType\SubmitRow
     */
    public function setInput_field(array $input_field = array())
    {
        foreach ($input_field as $submitRowInput_fieldItem) {
            // validation for constraint: itemType
            if (!$submitRowInput_fieldItem instanceof \StructType\DataField) {
                throw new \InvalidArgumentException(sprintf('The input_field property can only contain items of \StructType\DataField, "%s" given', is_object($submitRowInput_fieldItem) ? get_class($submitRowInput_fieldItem) : gettype($submitRowInput_fieldItem)), __LINE__);
            }
        }
        $this->input_field = $this->{'input-field'} = $input_field;
        return $this;
    }
    /**
     */
    public function addToInput_field(\StructType\DataField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataField) {
            throw new \InvalidArgumentException(sprintf('The input_field property can only contain items of \StructType\DataField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->input_field[] = $item;
        return $this;
    }
    /**
     * Get output_field value
     * @return \StructType\DataField[]|null
     */
    public function getOutput_field()
    {
        return $this->{'output-field'};
    }
    /**
     * Set output_field value
     * @throws \InvalidArgumentException
     * @param \StructType\DataField[] $output_field
     * @return \StructType\SubmitRow
     */
    public function setOutput_field(array $output_field = array())
    {
        foreach ($output_field as $submitRowOutput_fieldItem) {
            // validation for constraint: itemType
            if (!$submitRowOutput_fieldItem instanceof \StructType\DataField) {
                throw new \InvalidArgumentException(sprintf('The output_field property can only contain items of \StructType\DataField, "%s" given', is_object($submitRowOutput_fieldItem) ? get_class($submitRowOutput_fieldItem) : gettype($submitRowOutput_fieldItem)), __LINE__);
            }
        }
        $this->output_field = $this->{'output-field'} = $output_field;
        return $this;
    }
    /**
     */
    public function addToOutput_field(\StructType\DataField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataField) {
            throw new \InvalidArgumentException(sprintf('The output_field property can only contain items of \StructType\DataField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->output_field[] = $item;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\DataLink[]|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @throws \InvalidArgumentException
     * @param \StructType\DataLink[] $link
     * @return \StructType\SubmitRow
     */
    public function setLink(array $link = array())
    {
        foreach ($link as $submitRowLinkItem) {
            // validation for constraint: itemType
            if (!$submitRowLinkItem instanceof \StructType\DataLink) {
                throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\DataLink, "%s" given', is_object($submitRowLinkItem) ? get_class($submitRowLinkItem) : gettype($submitRowLinkItem)), __LINE__);
            }
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Add item to link value
     * @throws \InvalidArgumentException
     * @param \StructType\DataLink $item
     * @return \StructType\SubmitRow
     */
    public function addToLink(\StructType\DataLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataLink) {
            throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\DataLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->link[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentList|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentList $attachments
     * @return \StructType\SubmitRow
     */
    public function setAttachments(\StructType\AttachmentList $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
