<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for load-request StructType
 * @subpackage Structs
 */
class Load_request extends AbstractStructBase
{
    /**
     * The tables
     * Meta informations extracted from the WSDL
     * - documentation: An element containing a list of Tables for the request.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeedDataDescription
     */
    public $tables;
    /**
     * The root
     * Meta informations extracted from the WSDL
     * - documentation: The name of the table which was mapped to Global input.
     * - use: required
     * @var string
     */
    public $root;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - documentation: The deployment's region code. The connector may need to utilize this information if it is responsible for formatting currency, dates or other values to a field designated as a STRING field. Values passed as DECIMAL, DATE, DATETIME or
     * TIMEOFDAY will be formatted in the interview according to the settings of the policy model. (see Localization - Region)
     * - use: required
     * @var string
     */
    public $region;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - documentation: The deployment's language code. Useful if the connector is responsible for returning data in different languages, i.e. string values for fields which were described by the metadata as STRING data types.
     * - use: required
     * @var string
     */
    public $language;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - documentation: The timezone attribute is the Timezone as specified in the deployment. This affects all "Date and Time" Policy Modeling attributes as the value mapped out will carry this Timezone value. Any Date and Time values in the response must
     * already be converted to the project's Timezone.
     * - use: required
     * @var string
     */
    public $timezone;
    /**
     * The request_context
     * Meta informations extracted from the WSDL
     * - documentation: This element contains additional parameters specified on the start session url. See Persist data using WSC.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestContext
     */
    public $request_context;
    /**
     * Constructor method for load-request
     * @uses Load_request::setTables()
     * @uses Load_request::setRoot()
     * @uses Load_request::setRegion()
     * @uses Load_request::setLanguage()
     * @uses Load_request::setTimezone()
     * @uses Load_request::setRequest_context()
     * @param \StructType\SeedDataDescription $tables
     * @param string $root
     * @param string $region
     * @param string $language
     * @param string $timezone
     * @param \StructType\RequestContext $request_context
     */
    public function __construct(\StructType\SeedDataDescription $tables = null, $root = null, $region = null, $language = null, $timezone = null, \StructType\RequestContext $request_context = null)
    {
        $this
            ->setTables($tables)
            ->setRoot($root)
            ->setRegion($region)
            ->setLanguage($language)
            ->setTimezone($timezone)
            ->setRequest_context($request_context);
    }
    /**
     * Get tables value
     * @return \StructType\SeedDataDescription
     */
    public function getTables()
    {
        return $this->tables;
    }
    /**
     * Set tables value
     * @param \StructType\SeedDataDescription $tables
     * @return \StructType\Load_request
     */
    public function setTables(\StructType\SeedDataDescription $tables = null)
    {
        $this->tables = $tables;
        return $this;
    }
    /**
     * Get root value
     * @return string
     */
    public function getRoot()
    {
        return $this->root;
    }
    /**
     * Set root value
     * @param string $root
     * @return \StructType\Load_request
     */
    public function setRoot($root = null)
    {
        // validation for constraint: string
        if (!is_null($root) && !is_string($root)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($root)), __LINE__);
        }
        $this->root = $root;
        return $this;
    }
    /**
     * Get region value
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Load_request
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Load_request
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get timezone value
     * @return string
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param string $timezone
     * @return \StructType\Load_request
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timezone)), __LINE__);
        }
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Get request_context value
     * @return \StructType\RequestContext|null
     */
    public function getRequest_context()
    {
        return $this->{'request-context'};
    }
    /**
     * Set request_context value
     * @param \StructType\RequestContext $request_context
     * @return \StructType\Load_request
     */
    public function setRequest_context(\StructType\RequestContext $request_context = null)
    {
        $this->request_context = $this->{'request-context'} = $request_context;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Load_request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
