<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get-metadata-request StructType
 * @subpackage Structs
 */
class Get_metadata_request extends AbstractStructBase
{
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - documentation: The language of the project is included so that a web service connector is able to return a contextual response using descriptions in the language specified.
     * - use: required
     * @var string
     */
    public $language;
    /**
     * Constructor method for get-metadata-request
     * @uses Get_metadata_request::setLanguage()
     * @param string $language
     */
    public function __construct($language = null)
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Get_metadata_request
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get_metadata_request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
