<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildEnumValues StructType
 * @subpackage Structs
 */
class ChildEnumValues extends AbstractStructBase
{
    /**
     * The NumberValue
     * @var float
     */
    public $NumberValue;
    /**
     * The StringValue
     * @var string
     */
    public $StringValue;
    /**
     * The DateValue
     * @var string
     */
    public $DateValue;
    /**
     * The TimeValue
     * @var string
     */
    public $TimeValue;
    /**
     * The DateTimeValue
     * @var string
     */
    public $DateTimeValue;
    /**
     * The BooleanValue
     * @var bool
     */
    public $BooleanValue;
    /**
     * Constructor method for ChildEnumValues
     * @uses ChildEnumValues::setNumberValue()
     * @uses ChildEnumValues::setStringValue()
     * @uses ChildEnumValues::setDateValue()
     * @uses ChildEnumValues::setTimeValue()
     * @uses ChildEnumValues::setDateTimeValue()
     * @uses ChildEnumValues::setBooleanValue()
     * @param float $numberValue
     * @param string $stringValue
     * @param string $dateValue
     * @param string $timeValue
     * @param string $dateTimeValue
     * @param bool $booleanValue
     */
    public function __construct($numberValue = null, $stringValue = null, $dateValue = null, $timeValue = null, $dateTimeValue = null, $booleanValue = null)
    {
        $this
            ->setNumberValue($numberValue)
            ->setStringValue($stringValue)
            ->setDateValue($dateValue)
            ->setTimeValue($timeValue)
            ->setDateTimeValue($dateTimeValue)
            ->setBooleanValue($booleanValue);
    }
    /**
     * Get NumberValue value
     * @return float|null
     */
    public function getNumberValue()
    {
        return $this->NumberValue;
    }
    /**
     * Set NumberValue value
     * @param float $numberValue
     * @return \StructType\ChildEnumValues
     */
    public function setNumberValue($numberValue = null)
    {
        $this->NumberValue = $numberValue;
        return $this;
    }
    /**
     * Get StringValue value
     * @return string|null
     */
    public function getStringValue()
    {
        return $this->StringValue;
    }
    /**
     * Set StringValue value
     * @param string $stringValue
     * @return \StructType\ChildEnumValues
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stringValue)), __LINE__);
        }
        $this->StringValue = $stringValue;
        return $this;
    }
    /**
     * Get DateValue value
     * @return string|null
     */
    public function getDateValue()
    {
        return $this->DateValue;
    }
    /**
     * Set DateValue value
     * @param string $dateValue
     * @return \StructType\ChildEnumValues
     */
    public function setDateValue($dateValue = null)
    {
        // validation for constraint: string
        if (!is_null($dateValue) && !is_string($dateValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateValue)), __LINE__);
        }
        $this->DateValue = $dateValue;
        return $this;
    }
    /**
     * Get TimeValue value
     * @return string|null
     */
    public function getTimeValue()
    {
        return $this->TimeValue;
    }
    /**
     * Set TimeValue value
     * @param string $timeValue
     * @return \StructType\ChildEnumValues
     */
    public function setTimeValue($timeValue = null)
    {
        // validation for constraint: string
        if (!is_null($timeValue) && !is_string($timeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeValue)), __LINE__);
        }
        $this->TimeValue = $timeValue;
        return $this;
    }
    /**
     * Get DateTimeValue value
     * @return string|null
     */
    public function getDateTimeValue()
    {
        return $this->DateTimeValue;
    }
    /**
     * Set DateTimeValue value
     * @param string $dateTimeValue
     * @return \StructType\ChildEnumValues
     */
    public function setDateTimeValue($dateTimeValue = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeValue) && !is_string($dateTimeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTimeValue)), __LINE__);
        }
        $this->DateTimeValue = $dateTimeValue;
        return $this;
    }
    /**
     * Get BooleanValue value
     * @return bool|null
     */
    public function getBooleanValue()
    {
        return $this->BooleanValue;
    }
    /**
     * Set BooleanValue value
     * @param bool $booleanValue
     * @return \StructType\ChildEnumValues
     */
    public function setBooleanValue($booleanValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($booleanValue) && !is_bool($booleanValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($booleanValue)), __LINE__);
        }
        $this->BooleanValue = $booleanValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChildEnumValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
