<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuditReportList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the audit-reports attribute in the request of a Save data action.
 * @subpackage Structs
 */
class AuditReportList extends AbstractStructBase
{
    /**
     * The report
     * Meta informations extracted from the WSDL
     * - documentation: The top level element for an audit report. There's a report for each instance of the entity containing the attribute selected for saving an audit report.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttributeAuditNode[]
     */
    public $report;
    /**
     * Constructor method for AuditReportList
     * @uses AuditReportList::setReport()
     * @param \StructType\AttributeAuditNode[] $report
     */
    public function __construct(array $report = array())
    {
        $this
            ->setReport($report);
    }
    /**
     * Get report value
     * @return \StructType\AttributeAuditNode[]|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeAuditNode[] $report
     * @return \StructType\AuditReportList
     */
    public function setReport(array $report = array())
    {
        foreach ($report as $auditReportListReportItem) {
            // validation for constraint: itemType
            if (!$auditReportListReportItem instanceof \StructType\AttributeAuditNode) {
                throw new \InvalidArgumentException(sprintf('The report property can only contain items of \StructType\AttributeAuditNode, "%s" given', is_object($auditReportListReportItem) ? get_class($auditReportListReportItem) : gettype($auditReportListReportItem)), __LINE__);
            }
        }
        $this->report = $report;
        return $this;
    }
    /**
     * Add item to report value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeAuditNode $item
     * @return \StructType\AuditReportList
     */
    public function addToReport(\StructType\AttributeAuditNode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeAuditNode) {
            throw new \InvalidArgumentException(sprintf('The report property can only contain items of \StructType\AttributeAuditNode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->report[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuditReportList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
