<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Table StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the table attribute of SeedDataDescription in the request of a Load data action.
 * @subpackage Structs
 */
class Table extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the Table.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - documentation: A mapped Field.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Field[]
     */
    public $field;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: A mapped Link.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Link[]
     */
    public $link;
    /**
     * Constructor method for Table
     * @uses Table::setName()
     * @uses Table::setField()
     * @uses Table::setLink()
     * @param string $name
     * @param \StructType\Field[] $field
     * @param \StructType\Link[] $link
     */
    public function __construct($name = null, array $field = array(), array $link = array())
    {
        $this
            ->setName($name)
            ->setField($field)
            ->setLink($link);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Table
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get field value
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Table
     */
    public function setField(array $field = array())
    {
        foreach ($field as $tableFieldItem) {
            // validation for constraint: itemType
            if (!$tableFieldItem instanceof \StructType\Field) {
                throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\Field, "%s" given', is_object($tableFieldItem) ? get_class($tableFieldItem) : gettype($tableFieldItem)), __LINE__);
            }
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Add item to field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Table
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\Field, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->field[] = $item;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\Link[]|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @throws \InvalidArgumentException
     * @param \StructType\Link[] $link
     * @return \StructType\Table
     */
    public function setLink(array $link = array())
    {
        foreach ($link as $tableLinkItem) {
            // validation for constraint: itemType
            if (!$tableLinkItem instanceof \StructType\Link) {
                throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\Link, "%s" given', is_object($tableLinkItem) ? get_class($tableLinkItem) : gettype($tableLinkItem)), __LINE__);
            }
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Add item to link value
     * @throws \InvalidArgumentException
     * @param \StructType\Link $item
     * @return \StructType\Table
     */
    public function addToLink(\StructType\Link $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Link) {
            throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\Link, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->link[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Table
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
