<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the tables attribute in the request of a Save data action.
 * @subpackage Structs
 */
class SubmitData extends AbstractStructBase
{
    /**
     * The table
     * Meta informations extracted from the WSDL
     * - documentation: A table with instances (rows) containing data collected from an interview.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubmitTable[]
     */
    public $table;
    /**
     * Constructor method for SubmitData
     * @uses SubmitData::setTable()
     * @param \StructType\SubmitTable[] $table
     */
    public function __construct(array $table = array())
    {
        $this
            ->setTable($table);
    }
    /**
     * Get table value
     * @return \StructType\SubmitTable[]|null
     */
    public function getTable()
    {
        return $this->table;
    }
    /**
     * Set table value
     * @throws \InvalidArgumentException
     * @param \StructType\SubmitTable[] $table
     * @return \StructType\SubmitData
     */
    public function setTable(array $table = array())
    {
        foreach ($table as $submitDataTableItem) {
            // validation for constraint: itemType
            if (!$submitDataTableItem instanceof \StructType\SubmitTable) {
                throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\SubmitTable, "%s" given', is_object($submitDataTableItem) ? get_class($submitDataTableItem) : gettype($submitDataTableItem)), __LINE__);
            }
        }
        $this->table = $table;
        return $this;
    }
    /**
     * Add item to table value
     * @throws \InvalidArgumentException
     * @param \StructType\SubmitTable $item
     * @return \StructType\SubmitData
     */
    public function addToTable(\StructType\SubmitTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubmitTable) {
            throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\SubmitTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->table[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
