<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringEnumeration StructType
 * @subpackage Structs
 */
class StringEnumeration extends AbstractStructBase
{
    /**
     * The EnumValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\StringEnumVal[]
     */
    public $EnumValue;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The UncertainValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UncertainEnumVal
     */
    public $UncertainValue;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * The child_enum_id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $child_enum_id;
    /**
     * Constructor method for StringEnumeration
     * @uses StringEnumeration::setEnumValue()
     * @uses StringEnumeration::setId()
     * @uses StringEnumeration::setUncertainValue()
     * @uses StringEnumeration::setDescription()
     * @uses StringEnumeration::setChild_enum_id()
     * @param \StructType\StringEnumVal[] $enumValue
     * @param string $id
     * @param \StructType\UncertainEnumVal $uncertainValue
     * @param string $description
     * @param string $child_enum_id
     */
    public function __construct(array $enumValue = array(), $id = null, \StructType\UncertainEnumVal $uncertainValue = null, $description = null, $child_enum_id = null)
    {
        $this
            ->setEnumValue($enumValue)
            ->setId($id)
            ->setUncertainValue($uncertainValue)
            ->setDescription($description)
            ->setChild_enum_id($child_enum_id);
    }
    /**
     * Get EnumValue value
     * @return \StructType\StringEnumVal[]
     */
    public function getEnumValue()
    {
        return $this->EnumValue;
    }
    /**
     * Set EnumValue value
     * @throws \InvalidArgumentException
     * @param \StructType\StringEnumVal[] $enumValue
     * @return \StructType\StringEnumeration
     */
    public function setEnumValue(array $enumValue = array())
    {
        foreach ($enumValue as $stringEnumerationEnumValueItem) {
            // validation for constraint: itemType
            if (!$stringEnumerationEnumValueItem instanceof \StructType\StringEnumVal) {
                throw new \InvalidArgumentException(sprintf('The EnumValue property can only contain items of \StructType\StringEnumVal, "%s" given', is_object($stringEnumerationEnumValueItem) ? get_class($stringEnumerationEnumValueItem) : gettype($stringEnumerationEnumValueItem)), __LINE__);
            }
        }
        $this->EnumValue = $enumValue;
        return $this;
    }
    /**
     * Add item to EnumValue value
     * @throws \InvalidArgumentException
     * @param \StructType\StringEnumVal $item
     * @return \StructType\StringEnumeration
     */
    public function addToEnumValue(\StructType\StringEnumVal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StringEnumVal) {
            throw new \InvalidArgumentException(sprintf('The EnumValue property can only contain items of \StructType\StringEnumVal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EnumValue[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\StringEnumeration
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get UncertainValue value
     * @return \StructType\UncertainEnumVal|null
     */
    public function getUncertainValue()
    {
        return $this->UncertainValue;
    }
    /**
     * Set UncertainValue value
     * @param \StructType\UncertainEnumVal $uncertainValue
     * @return \StructType\StringEnumeration
     */
    public function setUncertainValue(\StructType\UncertainEnumVal $uncertainValue = null)
    {
        $this->UncertainValue = $uncertainValue;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\StringEnumeration
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get child_enum_id value
     * @return string|null
     */
    public function getChild_enum_id()
    {
        return $this->{'child-enum-id'};
    }
    /**
     * Set child_enum_id value
     * @param string $child_enum_id
     * @return \StructType\StringEnumeration
     */
    public function setChild_enum_id($child_enum_id = null)
    {
        // validation for constraint: string
        if (!is_null($child_enum_id) && !is_string($child_enum_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($child_enum_id)), __LINE__);
        }
        $this->child_enum_id = $this->{'child-enum-id'} = $child_enum_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StringEnumeration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
