<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeedDataDescription StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the tables attribute in the request of a Load data action, and for get-seed-data-definition-response in the response of the interview API's GetInputDataDefinition action.
 * @subpackage Structs
 */
class SeedDataDescription extends AbstractStructBase
{
    /**
     * The table
     * Meta informations extracted from the WSDL
     * - documentation: A mapped Table.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Table[]
     */
    public $table;
    /**
     * Constructor method for SeedDataDescription
     * @uses SeedDataDescription::setTable()
     * @param \StructType\Table[] $table
     */
    public function __construct(array $table = array())
    {
        $this
            ->setTable($table);
    }
    /**
     * Get table value
     * @return \StructType\Table[]|null
     */
    public function getTable()
    {
        return $this->table;
    }
    /**
     * Set table value
     * @throws \InvalidArgumentException
     * @param \StructType\Table[] $table
     * @return \StructType\SeedDataDescription
     */
    public function setTable(array $table = array())
    {
        foreach ($table as $seedDataDescriptionTableItem) {
            // validation for constraint: itemType
            if (!$seedDataDescriptionTableItem instanceof \StructType\Table) {
                throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\Table, "%s" given', is_object($seedDataDescriptionTableItem) ? get_class($seedDataDescriptionTableItem) : gettype($seedDataDescriptionTableItem)), __LINE__);
            }
        }
        $this->table = $table;
        return $this;
    }
    /**
     * Add item to table value
     * @throws \InvalidArgumentException
     * @param \StructType\Table $item
     * @return \StructType\SeedDataDescription
     */
    public function addToTable(\StructType\Table $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Table) {
            throw new \InvalidArgumentException(sprintf('The table property can only contain items of \StructType\Table, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->table[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeedDataDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
