<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for request-fault StructType
 * Meta informations extracted from the WSDL
 * - documentation: A request-fault is encapsulated within the description parameter of the SOAP envelope definition for Fault. RequestFault exceptions may be returned in the body of a save-response, load-response, set-checkpoint-response or
 * get-checkpoint-response
 * @subpackage Structs
 */
class Request_fault extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: A description of what caused the error plus any other information useful to the developer troubleshooting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for request-fault
     * @uses Request_fault::setMessage()
     * @param string $message
     */
    public function __construct($message = null)
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Request_fault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Request_fault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
