<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the request-context attribute in the request of a Load or Save data action.
 * @subpackage Structs
 */
class RequestContext extends AbstractStructBase
{
    /**
     * The parameter
     * Meta informations extracted from the WSDL
     * - documentation: This element contains parameters which were specified on the start session url. See Persist data using WSC.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RequestContextParam[]
     */
    public $parameter;
    /**
     * Constructor method for RequestContext
     * @uses RequestContext::setParameter()
     * @param \StructType\RequestContextParam[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get parameter value
     * @return \StructType\RequestContextParam[]|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\RequestContextParam[] $parameter
     * @return \StructType\RequestContext
     */
    public function setParameter(array $parameter = array())
    {
        foreach ($parameter as $requestContextParameterItem) {
            // validation for constraint: itemType
            if (!$requestContextParameterItem instanceof \StructType\RequestContextParam) {
                throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of \StructType\RequestContextParam, "%s" given', is_object($requestContextParameterItem) ? get_class($requestContextParameterItem) : gettype($requestContextParameterItem)), __LINE__);
            }
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Add item to parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\RequestContextParam $item
     * @return \StructType\RequestContext
     */
    public function addToParameter(\StructType\RequestContextParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequestContextParam) {
            throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of \StructType\RequestContextParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
