<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceAuditNode StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the already-proven-node element of AttributeAuditNode and of RelationshipAuditNode in the request of a Save data action.
 * @subpackage Structs
 */
class ReferenceAuditNode extends AbstractStructBase
{
    /**
     * The ref_node_id
     * Meta informations extracted from the WSDL
     * - documentation: A reference to another node, identified by its node-id, elsewhere in the decision report.
     * - use: required
     * @var string
     */
    public $ref_node_id;
    /**
     * Constructor method for ReferenceAuditNode
     * @uses ReferenceAuditNode::setRef_node_id()
     * @param string $ref_node_id
     */
    public function __construct($ref_node_id = null)
    {
        $this
            ->setRef_node_id($ref_node_id);
    }
    /**
     * Get ref_node_id value
     * @return string
     */
    public function getRef_node_id()
    {
        return $this->{'ref-node-id'};
    }
    /**
     * Set ref_node_id value
     * @param string $ref_node_id
     * @return \StructType\ReferenceAuditNode
     */
    public function setRef_node_id($ref_node_id = null)
    {
        // validation for constraint: string
        if (!is_null($ref_node_id) && !is_string($ref_node_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ref_node_id)), __LINE__);
        }
        $this->ref_node_id = $this->{'ref-node-id'} = $ref_node_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceAuditNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
