<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaField StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for an attribute of MetaTable in the metadata response of a GetMetadata action.
 * @subpackage Structs
 */
class MetaField extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the field. This will appear to policy model authors if a description is not provided.
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The can_be_input
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the field can be mapped in to an attribute for the purposes of Seeding data.
     * - use: required
     * @var bool
     */
    public $can_be_input;
    /**
     * The can_be_output
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the field can mapped out from an attribute for the purpose of Submitting data.
     * - use: required
     * @var bool
     */
    public $can_be_output;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Describes the value type which the field may have, which in turn defines the attribute types compatible with the field. Implementers must specify either type or enum-type for a meta field.
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * The enum_type
     * Meta informations extracted from the WSDL
     * - documentation: Specifes the ID of the enumeration that defines this field's data type. Implementers must specify either type or enum-type for a meta field.
     * - use: optional
     * @var string
     */
    public $enum_type;
    /**
     * The is_required
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the field must be mapped out from an attribute in a policy model.
     * - use: optional
     * @var bool
     */
    public $is_required;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: If provided, will be displayed as the field's name in OPM, but SOAP requests and responses will continue to use the name attribute's value as the field's identifier. This attribute is intended for providing localized metadata
     * descriptions.
     * - use: optional
     * @var string
     */
    public $description;
    /**
     * Constructor method for MetaField
     * @uses MetaField::setName()
     * @uses MetaField::setCan_be_input()
     * @uses MetaField::setCan_be_output()
     * @uses MetaField::setType()
     * @uses MetaField::setEnum_type()
     * @uses MetaField::setIs_required()
     * @uses MetaField::setDescription()
     * @param string $name
     * @param bool $can_be_input
     * @param bool $can_be_output
     * @param string $type
     * @param string $enum_type
     * @param bool $is_required
     * @param string $description
     */
    public function __construct($name = null, $can_be_input = null, $can_be_output = null, $type = null, $enum_type = null, $is_required = null, $description = null)
    {
        $this
            ->setName($name)
            ->setCan_be_input($can_be_input)
            ->setCan_be_output($can_be_output)
            ->setType($type)
            ->setEnum_type($enum_type)
            ->setIs_required($is_required)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MetaField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get can_be_input value
     * @return bool
     */
    public function getCan_be_input()
    {
        return $this->{'can-be-input'};
    }
    /**
     * Set can_be_input value
     * @param bool $can_be_input
     * @return \StructType\MetaField
     */
    public function setCan_be_input($can_be_input = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_be_input) && !is_bool($can_be_input)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_be_input)), __LINE__);
        }
        $this->can_be_input = $this->{'can-be-input'} = $can_be_input;
        return $this;
    }
    /**
     * Get can_be_output value
     * @return bool
     */
    public function getCan_be_output()
    {
        return $this->{'can-be-output'};
    }
    /**
     * Set can_be_output value
     * @param bool $can_be_output
     * @return \StructType\MetaField
     */
    public function setCan_be_output($can_be_output = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_be_output) && !is_bool($can_be_output)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_be_output)), __LINE__);
        }
        $this->can_be_output = $this->{'can-be-output'} = $can_be_output;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\MetaFieldDataType::valueIsValid()
     * @uses \EnumType\MetaFieldDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\MetaField
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MetaFieldDataType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\MetaFieldDataType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get enum_type value
     * @return string|null
     */
    public function getEnum_type()
    {
        return $this->{'enum-type'};
    }
    /**
     * Set enum_type value
     * @param string $enum_type
     * @return \StructType\MetaField
     */
    public function setEnum_type($enum_type = null)
    {
        // validation for constraint: string
        if (!is_null($enum_type) && !is_string($enum_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enum_type)), __LINE__);
        }
        $this->enum_type = $this->{'enum-type'} = $enum_type;
        return $this;
    }
    /**
     * Get is_required value
     * @return bool|null
     */
    public function getIs_required()
    {
        return $this->{'is-required'};
    }
    /**
     * Set is_required value
     * @param bool $is_required
     * @return \StructType\MetaField
     */
    public function setIs_required($is_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_required) && !is_bool($is_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_required)), __LINE__);
        }
        $this->is_required = $this->{'is-required'} = $is_required;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MetaField
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MetaField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
