<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataRow StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a row attribute in DataTable in the response of a Load data action.
 * @subpackage Structs
 */
class DataRow extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The ID which will be known internally for this row. If the row is involved in any subsequent Save actions, this id will be used to identify the row for the web service connector.
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - documentation: A field with a value populated by the web service connector.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataField[]
     */
    public $field;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: A link with values populated by the web service connector.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataLink[]
     */
    public $link;
    /**
     * Constructor method for DataRow
     * @uses DataRow::setId()
     * @uses DataRow::setField()
     * @uses DataRow::setLink()
     * @param string $id
     * @param \StructType\DataField[] $field
     * @param \StructType\DataLink[] $link
     */
    public function __construct($id = null, array $field = array(), array $link = array())
    {
        $this
            ->setId($id)
            ->setField($field)
            ->setLink($link);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DataRow
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get field value
     * @return \StructType\DataField[]|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @throws \InvalidArgumentException
     * @param \StructType\DataField[] $field
     * @return \StructType\DataRow
     */
    public function setField(array $field = array())
    {
        foreach ($field as $dataRowFieldItem) {
            // validation for constraint: itemType
            if (!$dataRowFieldItem instanceof \StructType\DataField) {
                throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\DataField, "%s" given', is_object($dataRowFieldItem) ? get_class($dataRowFieldItem) : gettype($dataRowFieldItem)), __LINE__);
            }
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Add item to field value
     * @throws \InvalidArgumentException
     * @param \StructType\DataField $item
     * @return \StructType\DataRow
     */
    public function addToField(\StructType\DataField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataField) {
            throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\DataField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->field[] = $item;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\DataLink[]|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @throws \InvalidArgumentException
     * @param \StructType\DataLink[] $link
     * @return \StructType\DataRow
     */
    public function setLink(array $link = array())
    {
        foreach ($link as $dataRowLinkItem) {
            // validation for constraint: itemType
            if (!$dataRowLinkItem instanceof \StructType\DataLink) {
                throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\DataLink, "%s" given', is_object($dataRowLinkItem) ? get_class($dataRowLinkItem) : gettype($dataRowLinkItem)), __LINE__);
            }
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Add item to link value
     * @throws \InvalidArgumentException
     * @param \StructType\DataLink $item
     * @return \StructType\DataRow
     */
    public function addToLink(\StructType\DataLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataLink) {
            throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\DataLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->link[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
