<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for the attachments attribute in the request of a Save data action.
 * @subpackage Structs
 */
class AttachmentList extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - documentation: An attachment, including any generated forms or items uploaded via an upload control.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * Constructor method for AttachmentList
     * @uses AttachmentList::setAttachment()
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\AttachmentList
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $attachmentListAttachmentItem) {
            // validation for constraint: itemType
            if (!$attachmentListAttachmentItem instanceof \StructType\Attachment) {
                throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\Attachment, "%s" given', is_object($attachmentListAttachmentItem) ? get_class($attachmentListAttachmentItem) : gettype($attachmentListAttachmentItem)), __LINE__);
            }
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\AttachmentList
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
