<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetCheckpoint
     * Meta informations extracted from the WSDL
     * - documentation: The SetCheckpoint action may be called during an interview to send the serialized session data (a checkpoint) to the Web Service Connector, which is then responsible for storing the data. Later on, a GetCheckpoint request can be made
     * which will expect to have the requested checkpoint data returned. If the Web Service Connector is unable to store the session data for whatever reason, a RequestFault should be returned to explain the cause. | If the response of a SetCheckpoint
     * action contains unexpected values or structure the response will be logged.If an error is raised by the web service connector, the body of the response may instead consist of a RequestFault. This defined fault structure allows the Hub log display the
     * error in a cleaner format, as opposed to a stack trace.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Set_checkpoint_request $request
     * @return \StructType\Set_checkpoint_response|bool
     */
    public function SetCheckpoint(\StructType\Set_checkpoint_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCheckpoint($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Set_checkpoint_response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
