<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Save
     * Meta informations extracted from the WSDL
     * - documentation: The Save action may be called during an interview with a defined Global output table. The request will include data for tables, links and fields which were mapped for output on, as well as any attachments and audit reports. The
     * response looks similar to a Load response because some attributes are populated with data only after a Submit occurs. | If the response of a Save action contains unexpected values or structure will be logged. Depending on the severity of the issue,
     * the interview may fail to proceed after the Submit. Be aware that the interview may have continued if the errors were not blocking.If an error is raised by the web service connector, the body of the response may instead consist of a RequestFault.
     * This defined fault structure allows the Hub log display the error in a cleaner format, as opposed to a stack trace.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Save_request $request
     * @return \StructType\Save_response|bool
     */
    public function Save(\StructType\Save_request $request)
    {
        try {
            $this->setResult(self::getSoapClient()->Save($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Save_response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
