<?php

namespace EnumType;

/**
 * This class stands for ImageType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration for the image type of BinaryImage in the metadata response of a GetMetadata action.
 * @subpackage Enumerations
 */
class ImageType
{
    /**
     * Constant for value 'gif'
     * @return string 'gif'
     */
    const VALUE_GIF = 'gif';
    /**
     * Constant for value 'jpeg'
     * @return string 'jpeg'
     */
    const VALUE_JPEG = 'jpeg';
    /**
     * Constant for value 'png'
     * @return string 'png'
     */
    const VALUE_PNG = 'png';
    /**
     * Constant for value 'svg'
     * @return string 'svg'
     */
    const VALUE_SVG = 'svg';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIF
     * @uses self::VALUE_JPEG
     * @uses self::VALUE_PNG
     * @uses self::VALUE_SVG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIF,
            self::VALUE_JPEG,
            self::VALUE_PNG,
            self::VALUE_SVG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
