<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRow StructType
 * Meta informations extracted from the WSDL
 * - documentation: Node for a row attribute in UpdateTable in the response of a Save data action.
 * @subpackage Structs
 */
class UpdateRow extends DataRow
{
    /**
     * The orig_id
     * Meta informations extracted from the WSDL
     * - documentation: If the id for the instance was changed from the original value supplied in the save-request, this attribute must hold the original value so that determination server knows which instance it is.
     * - use: optional
     * @var string
     */
    public $orig_id;
    /**
     * Constructor method for UpdateRow
     * @uses UpdateRow::setOrig_id()
     * @param string $orig_id
     */
    public function __construct($orig_id = null)
    {
        $this
            ->setOrig_id($orig_id);
    }
    /**
     * Get orig_id value
     * @return string|null
     */
    public function getOrig_id()
    {
        return $this->{'orig-id'};
    }
    /**
     * Set orig_id value
     * @param string $orig_id
     * @return \StructType\UpdateRow
     */
    public function setOrig_id($orig_id = null)
    {
        // validation for constraint: string
        if (!is_null($orig_id) && !is_string($orig_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orig_id)), __LINE__);
        }
        $this->orig_id = $this->{'orig-id'} = $orig_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
