<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UncertainValue StructType
 * Meta informations extracted from the WSDL
 * - documentation: Used to indicate the uncertain value for attribute values (and change points) provided to and returned from an Assess action. Unlike unknown, uncertain is considered a value, and prevents any further attempts to ask for or determine
 * a value of that attribute.Uncertain is most often used when a question has been asked of a real person, and the response is given that no answer is available. For example, if the question is "have you been vaccinated against measles" and the answer
 * is "I don't know" you might use the uncertain value to indicate that the individual has neither definitely been vaccinated nor definitely not been vaccinated against measles.
 * @subpackage Structs
 */
class UncertainValue extends AbstractStructBase
{
    /**
     * Constructor method for UncertainValue
     */
    public function __construct()
    {
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UncertainValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
